/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition zum Austausch von dynamischen Mengen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlAustauschDynamischeMengen implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlMengenReferenzLokal
			 _dynamischeMengeLokal
			= new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlMengenReferenzLokal
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlMengenReferenzRemote
			 _dynamischeMengeRemote
			= new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlMengenReferenzRemote
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttAustauschRichtung
			 _richtung
			;
	
		/**
		Lokale dynamische Menge.
		<p>
		
		</p>
		
		@return der Wert von DynamischeMengeLokal.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlMengenReferenzLokal
			 getDynamischeMengeLokal() {
			return _dynamischeMengeLokal;
		}
	
		/**
		Lokale dynamische Menge.
		<p>
		
		</p>
		
		@param _dynamischeMengeLokal der neue Wert von DynamischeMengeLokal.
		*/
		public void setDynamischeMengeLokal(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlMengenReferenzLokal
		 _dynamischeMengeLokal) {
			this._dynamischeMengeLokal = _dynamischeMengeLokal;
		}
	
		/**
		Entfernte Dynamische Menge.
		<p>
		
		</p>
		
		@return der Wert von DynamischeMengeRemote.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlMengenReferenzRemote
			 getDynamischeMengeRemote() {
			return _dynamischeMengeRemote;
		}
	
		/**
		Entfernte Dynamische Menge.
		<p>
		
		</p>
		
		@param _dynamischeMengeRemote der neue Wert von DynamischeMengeRemote.
		*/
		public void setDynamischeMengeRemote(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AtlMengenReferenzRemote
		 _dynamischeMengeRemote) {
			this._dynamischeMengeRemote = _dynamischeMengeRemote;
		}
	
		/**
		Angabe der Richtung des Datenaustausches.
		<p>
		
		</p>
		
		@return der Wert von Richtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttAustauschRichtung
			 getRichtung() {
			return _richtung;
		}
	
		/**
		Angabe der Richtung des Datenaustausches.
		<p>
		
		</p>
		
		@param _richtung der neue Wert von Richtung.
		*/
		public void setRichtung(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttAustauschRichtung
		 _richtung) {
			this._richtung = _richtung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					getDynamischeMengeLokal().bean2Atl(datum.getItem("DynamischeMengeLokal"), factory);
				// AttributListenDefinition
					getDynamischeMengeRemote().bean2Atl(datum.getItem("DynamischeMengeRemote"), factory);
				// GanzzahlAttributTyp
				if (getRichtung() != null) {
	                if (getRichtung().isZustand()) {
	                    datum.getUnscaledValue("Richtung").setText(getRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Richtung").set(getRichtung().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					getDynamischeMengeLokal().atl2Bean(daten.getItem("DynamischeMengeLokal"), factory);
				// AttributListenDefinition
					getDynamischeMengeRemote().atl2Bean(daten.getItem("DynamischeMengeRemote"), factory);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Richtung").isState()) {
							setRichtung(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttAustauschRichtung
							.getZustand(daten.getScaledValue("Richtung").getText()));
						} else {
						setRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttAustauschRichtung
						(daten.
							getUnscaledValue
						("Richtung").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAustauschDynamischeMengen clone() {
		AtlAustauschDynamischeMengen klon = new AtlAustauschDynamischeMengen();
		
						klon._dynamischeMengeLokal = getDynamischeMengeLokal().clone();
						klon._dynamischeMengeRemote = getDynamischeMengeRemote().clone();
						klon.setRichtung(getRichtung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
