/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition zum Austausch von OnlineDaten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlDatenidentifikationenAustauschOnlinedaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 _atgLokal
			;
			@Defaultwert(wert = "")
			private String
			 _atgRemote
			= new String
			()
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 _aspektLokal
			;
			@Defaultwert(wert = "")
			private String
			 _aspektRemote
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
			 _simLokal
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
			 _simRemote
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _delta
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _nachgeliefert
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttOnlinedatenRichtung
			 _richtung
			;
	
		/**
		Attributgruppe im Lokalsystem.
		<p>
		
		</p>
		
		@return der Wert von AtgLokal.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 getAtgLokal() {
			return _atgLokal;
		}
	
		/**
		Attributgruppe im Lokalsystem.
		<p>
		
		</p>
		
		@param _atgLokal der neue Wert von AtgLokal.
		*/
		public void setAtgLokal(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
		 _atgLokal) {
			this._atgLokal = _atgLokal;
		}
	
		/**
		Attributgruppe im Remote-System (falls leer wird die korrespondierende Attributgruppe zu AtgLokal benutzt).
		<p>
		
		</p>
		
		@return der Wert von AtgRemote.
		*/
			public String
			 getAtgRemote() {
			return _atgRemote;
		}
	
		/**
		Attributgruppe im Remote-System (falls leer wird die korrespondierende Attributgruppe zu AtgLokal benutzt).
		<p>
		
		</p>
		
		@param _atgRemote der neue Wert von AtgRemote.
		*/
		public void setAtgRemote(String
		 _atgRemote) {
			if (_atgRemote.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._atgRemote = _atgRemote;
		}
	
		/**
		Aspekt im Lokal-System.
		<p>
		
		</p>
		
		@return der Wert von AspektLokal.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 getAspektLokal() {
			return _aspektLokal;
		}
	
		/**
		Aspekt im Lokal-System.
		<p>
		
		</p>
		
		@param _aspektLokal der neue Wert von AspektLokal.
		*/
		public void setAspektLokal(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
		 _aspektLokal) {
			this._aspektLokal = _aspektLokal;
		}
	
		/**
		Aspekt im Remote-System (falls leer wird der korrespondierende Aspekt zu AspektLokal benutzt).
		<p>
		
		</p>
		
		@return der Wert von AspektRemote.
		*/
			public String
			 getAspektRemote() {
			return _aspektRemote;
		}
	
		/**
		Aspekt im Remote-System (falls leer wird der korrespondierende Aspekt zu AspektLokal benutzt).
		<p>
		
		</p>
		
		@param _aspektRemote der neue Wert von AspektRemote.
		*/
		public void setAspektRemote(String
		 _aspektRemote) {
			if (_aspektRemote.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._aspektRemote = _aspektRemote;
		}
	
		/**
		Simulationsvariante im Lokal-System.
		<p>
		
		</p>
		
		@return der Wert von SimLokal.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
			 getSimLokal() {
			return _simLokal;
		}
	
		/**
		Simulationsvariante im Lokal-System.
		<p>
		
		</p>
		
		@param _simLokal der neue Wert von SimLokal.
		*/
		public void setSimLokal(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
		 _simLokal) {
			this._simLokal = _simLokal;
		}
	
		/**
		Simulationsvariante im Remote-System.
		<p>
		
		</p>
		
		@return der Wert von SimRemote.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
			 getSimRemote() {
			return _simRemote;
		}
	
		/**
		Simulationsvariante im Remote-System.
		<p>
		
		</p>
		
		@param _simRemote der neue Wert von SimRemote.
		*/
		public void setSimRemote(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
		 _simRemote) {
			this._simRemote = _simRemote;
		}
	
		/**
		Legt fest, ob nur geänderte Daten übertragen werden sollen.
		<p>
		
		</p>
		
		@return der Wert von Delta.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getDelta() {
			return _delta;
		}
	
		/**
		Legt fest, ob nur geänderte Daten übertragen werden sollen.
		<p>
		
		</p>
		
		@param _delta der neue Wert von Delta.
		*/
		public void setDelta(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _delta) {
			this._delta = _delta;
		}
	
		/**
		Legt fest, ob nachgelieferte Daten übertragen werden sollen. Kann nicht zusammen mit Delta benutzt werden.
		<p>
		
		</p>
		
		@return der Wert von Nachgeliefert.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getNachgeliefert() {
			return _nachgeliefert;
		}
	
		/**
		Legt fest, ob nachgelieferte Daten übertragen werden sollen. Kann nicht zusammen mit Delta benutzt werden.
		<p>
		
		</p>
		
		@param _nachgeliefert der neue Wert von Nachgeliefert.
		*/
		public void setNachgeliefert(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _nachgeliefert) {
			this._nachgeliefert = _nachgeliefert;
		}
	
		/**
		Richtung des Datenaustausches.
		<p>
		
		</p>
		
		@return der Wert von Richtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttOnlinedatenRichtung
			 getRichtung() {
			return _richtung;
		}
	
		/**
		Richtung des Datenaustausches.
		<p>
		
		</p>
		
		@param _richtung der neue Wert von Richtung.
		*/
		public void setRichtung(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttOnlinedatenRichtung
		 _richtung) {
			this._richtung = _richtung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soAtgLokal = getAtgLokal();
					final SystemObject tmpAtgLokal;
						if (soAtgLokal instanceof SystemObject) {
							tmpAtgLokal = (SystemObject)soAtgLokal;
						} else if(soAtgLokal instanceof SystemObjekt){
							tmpAtgLokal = ((SystemObjekt)soAtgLokal).getSystemObject();
						} else{
							tmpAtgLokal = null;
						}
					datum.getReferenceValue("AtgLokal").setSystemObject(tmpAtgLokal);
				// ZeichenkettenAttributTyp
				if (getAtgRemote() != null) {
					datum.getTextValue("AtgRemote").setText(getAtgRemote());
				}
				// ObjektReferenzAttributTyp
					final Object soAspektLokal = getAspektLokal();
					final SystemObject tmpAspektLokal;
						if (soAspektLokal instanceof SystemObject) {
							tmpAspektLokal = (SystemObject)soAspektLokal;
						} else if(soAspektLokal instanceof SystemObjekt){
							tmpAspektLokal = ((SystemObjekt)soAspektLokal).getSystemObject();
						} else{
							tmpAspektLokal = null;
						}
					datum.getReferenceValue("AspektLokal").setSystemObject(tmpAspektLokal);
				// ZeichenkettenAttributTyp
				if (getAspektRemote() != null) {
					datum.getTextValue("AspektRemote").setText(getAspektRemote());
				}
				// GanzzahlAttributTyp
				if (getSimLokal() != null) {
	                if (getSimLokal().isZustand()) {
	                    datum.getUnscaledValue("SimLokal").setText(getSimLokal().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SimLokal").set(getSimLokal().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getSimRemote() != null) {
	                if (getSimRemote().isZustand()) {
	                    datum.getUnscaledValue("SimRemote").setText(getSimRemote().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SimRemote").set(getSimRemote().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getDelta() != null) {
	                if (getDelta().isZustand()) {
	                    datum.getUnscaledValue("Delta").setText(getDelta().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Delta").set(getDelta().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getNachgeliefert() != null) {
	                if (getNachgeliefert().isZustand()) {
	                    datum.getUnscaledValue("Nachgeliefert").setText(getNachgeliefert().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Nachgeliefert").set(getNachgeliefert().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getRichtung() != null) {
	                if (getRichtung().isZustand()) {
	                    datum.getUnscaledValue("Richtung").setText(getRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Richtung").set(getRichtung().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idAtgLokal = daten.getReferenceValue("AtgLokal").getId();
					final SystemObjekt tmpAtgLokal;
					if (idAtgLokal == 0) {
						tmpAtgLokal = null;
					} else {
						final SystemObject soAtgLokal = factory.getDav().getDataModel().getObject(idAtgLokal);
						if (soAtgLokal == null) {
								tmpAtgLokal = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AttributgruppeUngueltig(idAtgLokal);
						} else {
							tmpAtgLokal = factory.getModellobjekt(soAtgLokal);
						}
					}
					setAtgLokal((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
					) tmpAtgLokal);
				// ZeichenkettenAttributTyp
					setAtgRemote(daten.getTextValue("AtgRemote").getText());
				// ObjektReferenzAttributTyp
					final long idAspektLokal = daten.getReferenceValue("AspektLokal").getId();
					final SystemObjekt tmpAspektLokal;
					if (idAspektLokal == 0) {
						tmpAspektLokal = null;
					} else {
						final SystemObject soAspektLokal = factory.getDav().getDataModel().getObject(idAspektLokal);
						if (soAspektLokal == null) {
								tmpAspektLokal = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektUngueltig(idAspektLokal);
						} else {
							tmpAspektLokal = factory.getModellobjekt(soAspektLokal);
						}
					}
					setAspektLokal((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
					) tmpAspektLokal);
				// ZeichenkettenAttributTyp
					setAspektRemote(daten.getTextValue("AspektRemote").getText());
				// GanzzahlAttributTyp
						setSimLokal(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
						(daten.
							getUnscaledValue
						("SimLokal").
								shortValue
						()));
				// GanzzahlAttributTyp
						setSimRemote(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
						(daten.
							getUnscaledValue
						("SimRemote").
								shortValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Delta").isState()) {
							setDelta(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Delta").getText()));
						} else {
						setDelta(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Delta").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Nachgeliefert").isState()) {
							setNachgeliefert(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Nachgeliefert").getText()));
						} else {
						setNachgeliefert(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Nachgeliefert").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Richtung").isState()) {
							setRichtung(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttOnlinedatenRichtung
							.getZustand(daten.getScaledValue("Richtung").getText()));
						} else {
						setRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute.AttOnlinedatenRichtung
						(daten.
							getUnscaledValue
						("Richtung").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlDatenidentifikationenAustauschOnlinedaten clone() {
		AtlDatenidentifikationenAustauschOnlinedaten klon = new AtlDatenidentifikationenAustauschOnlinedaten();
		
						klon.setAtgLokal(getAtgLokal());
						klon.setAtgRemote(getAtgRemote());
						klon.setAspektLokal(getAspektLokal());
						klon.setAspektRemote(getAspektRemote());
						klon.setSimLokal(getSimLokal());
						klon.setSimRemote(getSimRemote());
						klon.setDelta(getDelta());
						klon.setNachgeliefert(getNachgeliefert());
						klon.setRichtung(getRichtung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
