/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Angabe von IP und Port zur Auswahl von Datenverteilern.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlDatenverteilerIP implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _iPAdresse
			= new String
			()
			;
			@Defaultwert(wert = "8083")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _portnummer
			;
	
		/**
		IP-Adresse oder Hostname für den Verbindungsaufbau zum Remote-Datenverteiler.
		<p>
		
		</p>
		
		@return der Wert von IPAdresse.
		*/
			public String
			 getIPAdresse() {
			return _iPAdresse;
		}
	
		/**
		IP-Adresse oder Hostname für den Verbindungsaufbau zum Remote-Datenverteiler.
		<p>
		
		</p>
		
		@param _iPAdresse der neue Wert von IPAdresse.
		*/
		public void setIPAdresse(String
		 _iPAdresse) {
			if (_iPAdresse.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._iPAdresse = _iPAdresse;
		}
	
		/**
		Portnummer für den Verbindungsaufbau zum Remote-Datenverteiler.
		<p>
		
		</p>
		
		@return der Wert von Portnummer.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getPortnummer() {
			return _portnummer;
		}
	
		/**
		Portnummer für den Verbindungsaufbau zum Remote-Datenverteiler.
		<p>
		
		</p>
		
		@param _portnummer der neue Wert von Portnummer.
		*/
		public void setPortnummer(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _portnummer) {
			this._portnummer = _portnummer;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getIPAdresse() != null) {
					datum.getTextValue("IP-Adresse").setText(getIPAdresse());
				}
				// GanzzahlAttributTyp
				if (getPortnummer() != null) {
	                if (getPortnummer().isZustand()) {
	                    datum.getUnscaledValue("Portnummer").setText(getPortnummer().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Portnummer").set(getPortnummer().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setIPAdresse(daten.getTextValue("IP-Adresse").getText());
				// GanzzahlAttributTyp
						setPortnummer(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Portnummer").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlDatenverteilerIP clone() {
		AtlDatenverteilerIP klon = new AtlDatenverteilerIP();
		
						klon.setIPAdresse(getIPAdresse());
						klon.setPortnummer(getPortnummer());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
