/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class AtlAnzeigeEigenschaft implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WvzInhalt
			 _anzeigeInhalt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _blinken
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
			 _blinktakt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _passiviert
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WzgInhaltGrafik
			> _grafikDarstellungen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WzgInhaltGrafik
			>(0, true);
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Wechseltext
			 _wechseltext
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlDynWechseltext
			 _dynamischerWechseltext
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlDynWechseltext
			()
			;
	
		/**
		Referenz auf WVZInhalt.
		<p>
		
		</p>
		
		@return der Wert von AnzeigeInhalt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WvzInhalt
			 getAnzeigeInhalt() {
			return _anzeigeInhalt;
		}
	
		/**
		Referenz auf WVZInhalt.
		<p>
		
		</p>
		
		@param _anzeigeInhalt der neue Wert von AnzeigeInhalt.
		*/
		public void setAnzeigeInhalt(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WvzInhalt
		 _anzeigeInhalt) {
			this._anzeigeInhalt = _anzeigeInhalt;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von Blinken.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getBlinken() {
			return _blinken;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _blinken der neue Wert von Blinken.
		*/
		public void setBlinken(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _blinken) {
			this._blinken = _blinken;
		}
	
		/**
		Blinktakt des Inhalts.
		<p>
		Zeit für einen kompletten Zyklus von Beginn der sichtbaren Anzeige der Anzeige
								bis zur erneuten sichtbaren Anzeige der Anzeige. Es ist von einem Tastverhältnis
								von 0,5 auszugehen, dieses kann jedoch bei der tatsächlichen Realisierung vor Ort variieren
		</p>
		
		@return der Wert von Blinktakt.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
			 getBlinktakt() {
			return _blinktakt;
		}
	
		/**
		Blinktakt des Inhalts.
		<p>
		Zeit für einen kompletten Zyklus von Beginn der sichtbaren Anzeige der Anzeige
								bis zur erneuten sichtbaren Anzeige der Anzeige. Es ist von einem Tastverhältnis
								von 0,5 auszugehen, dieses kann jedoch bei der tatsächlichen Realisierung vor Ort variieren
		</p>
		
		@param _blinktakt der neue Wert von Blinktakt.
		*/
		public void setBlinktakt(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
		 _blinktakt) {
			this._blinktakt = _blinktakt;
		}
	
		/**
		Die Anzeige soll passiviert werden, d.h. keine Schaltbefehle annehmen.
		<p>
		
		</p>
		
		@return der Wert von Passiviert.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getPassiviert() {
			return _passiviert;
		}
	
		/**
		Die Anzeige soll passiviert werden, d.h. keine Schaltbefehle annehmen.
		<p>
		
		</p>
		
		@param _passiviert der neue Wert von Passiviert.
		*/
		public void setPassiviert(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _passiviert) {
			this._passiviert = _passiviert;
		}
	
		/**
		Grafiken für die Darstellung der Grafik, wenn verwendet.
		<p>
		
		</p>
		
		@return der Wert von GrafikDarstellungen.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WzgInhaltGrafik
			> getGrafikDarstellungen() {
			return _grafikDarstellungen;
		}
	
	
		/**
		Benutzter Wechseltext, wenn verwendet.
		<p>
		
		</p>
		
		@return der Wert von Wechseltext.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Wechseltext
			 getWechseltext() {
			return _wechseltext;
		}
	
		/**
		Benutzter Wechseltext, wenn verwendet.
		<p>
		
		</p>
		
		@param _wechseltext der neue Wert von Wechseltext.
		*/
		public void setWechseltext(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Wechseltext
		 _wechseltext) {
			this._wechseltext = _wechseltext;
		}
	
		/**
		Wechseltext bestehend aus Font und Referenzen auf die einzelnen Zeichen.
		<p>
		
		</p>
		
		@return der Wert von DynamischerWechseltext.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlDynWechseltext
			 getDynamischerWechseltext() {
			return _dynamischerWechseltext;
		}
	
		/**
		Wechseltext bestehend aus Font und Referenzen auf die einzelnen Zeichen.
		<p>
		
		</p>
		
		@param _dynamischerWechseltext der neue Wert von DynamischerWechseltext.
		*/
		public void setDynamischerWechseltext(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlDynWechseltext
		 _dynamischerWechseltext) {
			this._dynamischerWechseltext = _dynamischerWechseltext;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soAnzeigeInhalt = getAnzeigeInhalt();
					final SystemObject tmpAnzeigeInhalt;
						if (soAnzeigeInhalt instanceof SystemObject) {
							tmpAnzeigeInhalt = (SystemObject)soAnzeigeInhalt;
						} else if(soAnzeigeInhalt instanceof SystemObjekt){
							tmpAnzeigeInhalt = ((SystemObjekt)soAnzeigeInhalt).getSystemObject();
						} else{
							tmpAnzeigeInhalt = null;
						}
					datum.getReferenceValue("AnzeigeInhalt").setSystemObject(tmpAnzeigeInhalt);
				// GanzzahlAttributTyp
				if (getBlinken() != null) {
	                if (getBlinken().isZustand()) {
	                    datum.getUnscaledValue("Blinken").setText(getBlinken().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Blinken").set(getBlinken().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getBlinktakt() != null) {
	                if (getBlinktakt().isZustand()) {
	                    datum.getUnscaledValue("Blinktakt").setText(getBlinktakt().toString());
	                } else {
						datum.
						getScaledValue
	                	("Blinktakt").set(getBlinktakt().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getPassiviert() != null) {
	                if (getPassiviert().isZustand()) {
	                    datum.getUnscaledValue("Passiviert").setText(getPassiviert().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Passiviert").set(getPassiviert().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayGrafikDarstellungen = datum.getReferenceArray("GrafikDarstellungen");
					arrayGrafikDarstellungen.setLength(getGrafikDarstellungen().size());
					for (int i = 0; i < arrayGrafikDarstellungen.getLength(); ++i) {
						final Object soGrafikDarstellungen = getGrafikDarstellungen().get(i);
						final SystemObject tmpGrafikDarstellungen;
						if (soGrafikDarstellungen instanceof SystemObject) {
							tmpGrafikDarstellungen = (SystemObject)soGrafikDarstellungen;
						} else if(soGrafikDarstellungen instanceof SystemObjekt){
							tmpGrafikDarstellungen = ((SystemObjekt)soGrafikDarstellungen).getSystemObject();
						} else{
							tmpGrafikDarstellungen = null;
						}
						arrayGrafikDarstellungen.getReferenceValue(i).setSystemObject(tmpGrafikDarstellungen);
					}
				// ObjektReferenzAttributTyp
					final Object soWechseltext = getWechseltext();
					final SystemObject tmpWechseltext;
						if (soWechseltext instanceof SystemObject) {
							tmpWechseltext = (SystemObject)soWechseltext;
						} else if(soWechseltext instanceof SystemObjekt){
							tmpWechseltext = ((SystemObjekt)soWechseltext).getSystemObject();
						} else{
							tmpWechseltext = null;
						}
					datum.getReferenceValue("Wechseltext").setSystemObject(tmpWechseltext);
				// AttributListenDefinition
					getDynamischerWechseltext().bean2Atl(datum.getItem("DynamischerWechseltext"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idAnzeigeInhalt = daten.getReferenceValue("AnzeigeInhalt").getId();
					final SystemObjekt tmpAnzeigeInhalt;
					if (idAnzeigeInhalt == 0) {
						tmpAnzeigeInhalt = null;
					} else {
						final SystemObject soAnzeigeInhalt = factory.getDav().getDataModel().getObject(idAnzeigeInhalt);
						if (soAnzeigeInhalt == null) {
								tmpAnzeigeInhalt = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.WvzInhaltUngueltig(idAnzeigeInhalt);
						} else {
							tmpAnzeigeInhalt = factory.getModellobjekt(soAnzeigeInhalt);
						}
					}
					setAnzeigeInhalt((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WvzInhalt
					) tmpAnzeigeInhalt);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Blinken").isState()) {
							setBlinken(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Blinken").getText()));
						} else {
						setBlinken(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Blinken").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Blinktakt").isState()) {
							setBlinktakt(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
							.getZustand(daten.getScaledValue("Blinktakt").getText()));
						} else {
						setBlinktakt(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
						(daten.
							getScaledValue
						("Blinktakt").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Passiviert").isState()) {
							setPassiviert(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Passiviert").getText()));
						} else {
						setPassiviert(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Passiviert").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayGrafikDarstellungen = daten.getReferenceArray("GrafikDarstellungen");
					for (int i = 0; i < arrayGrafikDarstellungen.getLength(); ++i) {
						final long idGrafikDarstellungen = daten.getReferenceArray("GrafikDarstellungen").getReferenceValue(i).getId();
						final SystemObjekt tmpGrafikDarstellungen;
						if (idGrafikDarstellungen == 0) {
							tmpGrafikDarstellungen = null;
						} else {
							final SystemObject soGrafikDarstellungen = factory.getDav().getDataModel().getObject(idGrafikDarstellungen);
							if (soGrafikDarstellungen == null) {
									tmpGrafikDarstellungen = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.WzgInhaltGrafikUngueltig(idGrafikDarstellungen);
							} else {
								tmpGrafikDarstellungen = factory.getModellobjekt(soGrafikDarstellungen);
							}
						}
							getGrafikDarstellungen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WzgInhaltGrafik
							) tmpGrafikDarstellungen);
					}
				// ObjektReferenzAttributTyp
					final long idWechseltext = daten.getReferenceValue("Wechseltext").getId();
					final SystemObjekt tmpWechseltext;
					if (idWechseltext == 0) {
						tmpWechseltext = null;
					} else {
						final SystemObject soWechseltext = factory.getDav().getDataModel().getObject(idWechseltext);
						if (soWechseltext == null) {
								tmpWechseltext = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.WechseltextUngueltig(idWechseltext);
						} else {
							tmpWechseltext = factory.getModellobjekt(soWechseltext);
						}
					}
					setWechseltext((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Wechseltext
					) tmpWechseltext);
				// AttributListenDefinition
					getDynamischerWechseltext().atl2Bean(daten.getItem("DynamischerWechseltext"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAnzeigeEigenschaft clone() {
		AtlAnzeigeEigenschaft klon = new AtlAnzeigeEigenschaft();
		
						klon.setAnzeigeInhalt(getAnzeigeInhalt());
						klon.setBlinken(getBlinken());
						klon.setBlinktakt(getBlinktakt());
						klon.setPassiviert(getPassiviert());
					klon._grafikDarstellungen = getGrafikDarstellungen().clone();
						klon.setWechseltext(getWechseltext());
						klon._dynamischerWechseltext = getDynamischerWechseltext().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
