/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Quellen VLT für Interimslösung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 17
 */
public class AtlAnzeigeQuerschnittQuellenVlt implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.DeVlt
			> _deVltReferenzen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.DeVlt
			>(0, true);
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 _attributGruppenReferenz
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 _aspektReferenz
			;
			private String
			 _attribut
			= new String
			()
			;
			private String
			 _attributwert
			= new String
			()
			;
	
		/**
		Referenzen auf DeVlt.
		<p>
		
		</p>
		
		@return der Wert von DeVltReferenzen.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.DeVlt
			> getDeVltReferenzen() {
			return _deVltReferenzen;
		}
	
	
		/**
		Referenz auf AttributGruppe (optional).
		<p>
		
		</p>
		
		@return der Wert von AttributGruppenReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 getAttributGruppenReferenz() {
			return _attributGruppenReferenz;
		}
	
		/**
		Referenz auf AttributGruppe (optional).
		<p>
		
		</p>
		
		@param _attributGruppenReferenz der neue Wert von AttributGruppenReferenz.
		*/
		public void setAttributGruppenReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
		 _attributGruppenReferenz) {
			this._attributGruppenReferenz = _attributGruppenReferenz;
		}
	
		/**
		Referenz auf Aspekt (optional).
		<p>
		
		</p>
		
		@return der Wert von AspektReferenz.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 getAspektReferenz() {
			return _aspektReferenz;
		}
	
		/**
		Referenz auf Aspekt (optional).
		<p>
		
		</p>
		
		@param _aspektReferenz der neue Wert von AspektReferenz.
		*/
		public void setAspektReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
		 _aspektReferenz) {
			this._aspektReferenz = _aspektReferenz;
		}
	
		/**
		Attribut mit Status.
		<p>
		
		</p>
		
		@return der Wert von Attribut.
		*/
			public String
			 getAttribut() {
			return _attribut;
		}
	
		/**
		Attribut mit Status.
		<p>
		
		</p>
		
		@param _attribut der neue Wert von Attribut.
		*/
		public void setAttribut(String
		 _attribut) {
			if (_attribut.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._attribut = _attribut;
		}
	
		/**
		Attributwert für Status.
		<p>
		
		</p>
		
		@return der Wert von Attributwert.
		*/
			public String
			 getAttributwert() {
			return _attributwert;
		}
	
		/**
		Attributwert für Status.
		<p>
		
		</p>
		
		@param _attributwert der neue Wert von Attributwert.
		*/
		public void setAttributwert(String
		 _attributwert) {
			if (_attributwert.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._attributwert = _attributwert;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayDeVltReferenzen = datum.getReferenceArray("DeVltReferenzen");
					arrayDeVltReferenzen.setLength(getDeVltReferenzen().size());
					for (int i = 0; i < arrayDeVltReferenzen.getLength(); ++i) {
						final Object soDeVltReferenzen = getDeVltReferenzen().get(i);
						final SystemObject tmpDeVltReferenzen;
						if (soDeVltReferenzen instanceof SystemObject) {
							tmpDeVltReferenzen = (SystemObject)soDeVltReferenzen;
						} else if(soDeVltReferenzen instanceof SystemObjekt){
							tmpDeVltReferenzen = ((SystemObjekt)soDeVltReferenzen).getSystemObject();
						} else{
							tmpDeVltReferenzen = null;
						}
						arrayDeVltReferenzen.getReferenceValue(i).setSystemObject(tmpDeVltReferenzen);
					}
				// ObjektReferenzAttributTyp
					final Object soAttributGruppenReferenz = getAttributGruppenReferenz();
					final SystemObject tmpAttributGruppenReferenz;
						if (soAttributGruppenReferenz instanceof SystemObject) {
							tmpAttributGruppenReferenz = (SystemObject)soAttributGruppenReferenz;
						} else if(soAttributGruppenReferenz instanceof SystemObjekt){
							tmpAttributGruppenReferenz = ((SystemObjekt)soAttributGruppenReferenz).getSystemObject();
						} else{
							tmpAttributGruppenReferenz = null;
						}
					datum.getReferenceValue("AttributGruppenReferenz").setSystemObject(tmpAttributGruppenReferenz);
				// ObjektReferenzAttributTyp
					final Object soAspektReferenz = getAspektReferenz();
					final SystemObject tmpAspektReferenz;
						if (soAspektReferenz instanceof SystemObject) {
							tmpAspektReferenz = (SystemObject)soAspektReferenz;
						} else if(soAspektReferenz instanceof SystemObjekt){
							tmpAspektReferenz = ((SystemObjekt)soAspektReferenz).getSystemObject();
						} else{
							tmpAspektReferenz = null;
						}
					datum.getReferenceValue("AspektReferenz").setSystemObject(tmpAspektReferenz);
				// ZeichenkettenAttributTyp
				if (getAttribut() != null) {
					datum.getTextValue("Attribut").setText(getAttribut());
				}
				// ZeichenkettenAttributTyp
				if (getAttributwert() != null) {
					datum.getTextValue("Attributwert").setText(getAttributwert());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayDeVltReferenzen = daten.getReferenceArray("DeVltReferenzen");
					for (int i = 0; i < arrayDeVltReferenzen.getLength(); ++i) {
						final long idDeVltReferenzen = daten.getReferenceArray("DeVltReferenzen").getReferenceValue(i).getId();
						final SystemObjekt tmpDeVltReferenzen;
						if (idDeVltReferenzen == 0) {
							tmpDeVltReferenzen = null;
						} else {
							final SystemObject soDeVltReferenzen = factory.getDav().getDataModel().getObject(idDeVltReferenzen);
							if (soDeVltReferenzen == null) {
									tmpDeVltReferenzen = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.impl.DeVltUngueltig(idDeVltReferenzen);
							} else {
								tmpDeVltReferenzen = factory.getModellobjekt(soDeVltReferenzen);
							}
						}
							getDeVltReferenzen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.DeVlt
							) tmpDeVltReferenzen);
					}
				// ObjektReferenzAttributTyp
					final long idAttributGruppenReferenz = daten.getReferenceValue("AttributGruppenReferenz").getId();
					final SystemObjekt tmpAttributGruppenReferenz;
					if (idAttributGruppenReferenz == 0) {
						tmpAttributGruppenReferenz = null;
					} else {
						final SystemObject soAttributGruppenReferenz = factory.getDav().getDataModel().getObject(idAttributGruppenReferenz);
						if (soAttributGruppenReferenz == null) {
								tmpAttributGruppenReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AttributgruppeUngueltig(idAttributGruppenReferenz);
						} else {
							tmpAttributGruppenReferenz = factory.getModellobjekt(soAttributGruppenReferenz);
						}
					}
					setAttributGruppenReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
					) tmpAttributGruppenReferenz);
				// ObjektReferenzAttributTyp
					final long idAspektReferenz = daten.getReferenceValue("AspektReferenz").getId();
					final SystemObjekt tmpAspektReferenz;
					if (idAspektReferenz == 0) {
						tmpAspektReferenz = null;
					} else {
						final SystemObject soAspektReferenz = factory.getDav().getDataModel().getObject(idAspektReferenz);
						if (soAspektReferenz == null) {
								tmpAspektReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektUngueltig(idAspektReferenz);
						} else {
							tmpAspektReferenz = factory.getModellobjekt(soAspektReferenz);
						}
					}
					setAspektReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
					) tmpAspektReferenz);
				// ZeichenkettenAttributTyp
					setAttribut(daten.getTextValue("Attribut").getText());
				// ZeichenkettenAttributTyp
					setAttributwert(daten.getTextValue("Attributwert").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAnzeigeQuerschnittQuellenVlt clone() {
		AtlAnzeigeQuerschnittQuellenVlt klon = new AtlAnzeigeQuerschnittQuellenVlt();
		
					klon._deVltReferenzen = getDeVltReferenzen().clone();
						klon.setAttributGruppenReferenz(getAttributGruppenReferenz());
						klon.setAspektReferenz(getAspektReferenz());
						klon.setAttribut(getAttribut());
						klon.setAttributwert(getAttributwert());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
