/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class AtlDirigentEigenschaft implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WvzInhalt
			 _anzeigeInhalt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _passiviert
			;
	
		/**
		Referenz auf WVZInhalt.
		<p>
		
		</p>
		
		@return der Wert von AnzeigeInhalt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WvzInhalt
			 getAnzeigeInhalt() {
			return _anzeigeInhalt;
		}
	
		/**
		Referenz auf WVZInhalt.
		<p>
		
		</p>
		
		@param _anzeigeInhalt der neue Wert von AnzeigeInhalt.
		*/
		public void setAnzeigeInhalt(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WvzInhalt
		 _anzeigeInhalt) {
			this._anzeigeInhalt = _anzeigeInhalt;
		}
	
		/**
		Der Dirigent soll passiviert werden, d.h. keine Schaltbefehle annehmen.
		<p>
		
		</p>
		
		@return der Wert von Passiviert.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getPassiviert() {
			return _passiviert;
		}
	
		/**
		Der Dirigent soll passiviert werden, d.h. keine Schaltbefehle annehmen.
		<p>
		
		</p>
		
		@param _passiviert der neue Wert von Passiviert.
		*/
		public void setPassiviert(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _passiviert) {
			this._passiviert = _passiviert;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soAnzeigeInhalt = getAnzeigeInhalt();
					final SystemObject tmpAnzeigeInhalt;
						if (soAnzeigeInhalt instanceof SystemObject) {
							tmpAnzeigeInhalt = (SystemObject)soAnzeigeInhalt;
						} else if(soAnzeigeInhalt instanceof SystemObjekt){
							tmpAnzeigeInhalt = ((SystemObjekt)soAnzeigeInhalt).getSystemObject();
						} else{
							tmpAnzeigeInhalt = null;
						}
					datum.getReferenceValue("AnzeigeInhalt").setSystemObject(tmpAnzeigeInhalt);
				// GanzzahlAttributTyp
				if (getPassiviert() != null) {
	                if (getPassiviert().isZustand()) {
	                    datum.getUnscaledValue("Passiviert").setText(getPassiviert().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Passiviert").set(getPassiviert().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idAnzeigeInhalt = daten.getReferenceValue("AnzeigeInhalt").getId();
					final SystemObjekt tmpAnzeigeInhalt;
					if (idAnzeigeInhalt == 0) {
						tmpAnzeigeInhalt = null;
					} else {
						final SystemObject soAnzeigeInhalt = factory.getDav().getDataModel().getObject(idAnzeigeInhalt);
						if (soAnzeigeInhalt == null) {
								tmpAnzeigeInhalt = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.WvzInhaltUngueltig(idAnzeigeInhalt);
						} else {
							tmpAnzeigeInhalt = factory.getModellobjekt(soAnzeigeInhalt);
						}
					}
					setAnzeigeInhalt((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WvzInhalt
					) tmpAnzeigeInhalt);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Passiviert").isState()) {
							setPassiviert(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Passiviert").getText()));
						} else {
						setPassiviert(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Passiviert").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlDirigentEigenschaft clone() {
		AtlDirigentEigenschaft klon = new AtlDirigentEigenschaft();
		
						klon.setAnzeigeInhalt(getAnzeigeInhalt());
						klon.setPassiviert(getPassiviert());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
