/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Wechseltext bestehend aus Font und Referenzen auf die einzelnen Zeichen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class AtlDynWechseltext implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Font
			 _font
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTextAusrichtung
			 _textAusrichtung
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Zeichen
			> _textdefinition = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Zeichen
			>(0, true);
	
		/**
		Typ des Fonts.
		<p>
		
		</p>
		
		@return der Wert von Font.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Font
			 getFont() {
			return _font;
		}
	
		/**
		Typ des Fonts.
		<p>
		
		</p>
		
		@param _font der neue Wert von Font.
		*/
		public void setFont(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Font
		 _font) {
			this._font = _font;
		}
	
		/**
		Text-Ausrichtung in der Anzeige.
		<p>
		
		</p>
		
		@return der Wert von TextAusrichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTextAusrichtung
			 getTextAusrichtung() {
			return _textAusrichtung;
		}
	
		/**
		Text-Ausrichtung in der Anzeige.
		<p>
		
		</p>
		
		@param _textAusrichtung der neue Wert von TextAusrichtung.
		*/
		public void setTextAusrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTextAusrichtung
		 _textAusrichtung) {
			this._textAusrichtung = _textAusrichtung;
		}
	
		/**
		Geordnete Liste mit den Referenzen auf die im Wechseltext enthaltenen Zeichen. .
		<p>
		
		</p>
		
		@return der Wert von Textdefinition.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Zeichen
			> getTextdefinition() {
			return _textdefinition;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soFont = getFont();
					final SystemObject tmpFont;
						if (soFont instanceof SystemObject) {
							tmpFont = (SystemObject)soFont;
						} else if(soFont instanceof SystemObjekt){
							tmpFont = ((SystemObjekt)soFont).getSystemObject();
						} else{
							tmpFont = null;
						}
					datum.getReferenceValue("Font").setSystemObject(tmpFont);
				// GanzzahlAttributTyp
				if (getTextAusrichtung() != null) {
	                if (getTextAusrichtung().isZustand()) {
	                    datum.getUnscaledValue("TextAusrichtung").setText(getTextAusrichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("TextAusrichtung").set(getTextAusrichtung().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayTextdefinition = datum.getReferenceArray("Textdefinition");
					arrayTextdefinition.setLength(getTextdefinition().size());
					for (int i = 0; i < arrayTextdefinition.getLength(); ++i) {
						final Object soTextdefinition = getTextdefinition().get(i);
						final SystemObject tmpTextdefinition;
						if (soTextdefinition instanceof SystemObject) {
							tmpTextdefinition = (SystemObject)soTextdefinition;
						} else if(soTextdefinition instanceof SystemObjekt){
							tmpTextdefinition = ((SystemObjekt)soTextdefinition).getSystemObject();
						} else{
							tmpTextdefinition = null;
						}
						arrayTextdefinition.getReferenceValue(i).setSystemObject(tmpTextdefinition);
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idFont = daten.getReferenceValue("Font").getId();
					final SystemObjekt tmpFont;
					if (idFont == 0) {
						tmpFont = null;
					} else {
						final SystemObject soFont = factory.getDav().getDataModel().getObject(idFont);
						if (soFont == null) {
								tmpFont = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.FontUngueltig(idFont);
						} else {
							tmpFont = factory.getModellobjekt(soFont);
						}
					}
					setFont((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Font
					) tmpFont);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("TextAusrichtung").isState()) {
							setTextAusrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTextAusrichtung
							.getZustand(daten.getScaledValue("TextAusrichtung").getText()));
						} else {
						setTextAusrichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTextAusrichtung
						(daten.
							getUnscaledValue
						("TextAusrichtung").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayTextdefinition = daten.getReferenceArray("Textdefinition");
					for (int i = 0; i < arrayTextdefinition.getLength(); ++i) {
						final long idTextdefinition = daten.getReferenceArray("Textdefinition").getReferenceValue(i).getId();
						final SystemObjekt tmpTextdefinition;
						if (idTextdefinition == 0) {
							tmpTextdefinition = null;
						} else {
							final SystemObject soTextdefinition = factory.getDav().getDataModel().getObject(idTextdefinition);
							if (soTextdefinition == null) {
									tmpTextdefinition = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.ZeichenUngueltig(idTextdefinition);
							} else {
								tmpTextdefinition = factory.getModellobjekt(soTextdefinition);
							}
						}
							getTextdefinition().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Zeichen
							) tmpTextdefinition);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlDynWechseltext clone() {
		AtlDynWechseltext klon = new AtlDynWechseltext();
		
						klon.setFont(getFont());
						klon.setTextAusrichtung(getTextAusrichtung());
					klon._textdefinition = getTextdefinition().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
