/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attribut für mögliche Betriebszustände AQ.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttAqBetriebsZustaende extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Betriebsart kann nicht ermittelt werden.
	<p>
	
	</p>
	*/
	public static final AttAqBetriebsZustaende ZUSTAND_1N_UNDEFINIERT = new AttAqBetriebsZustaende("Undefiniert", 		Byte
	.valueOf("-1"));

	/**
	Normalbetrieb im Sinne der der Definition der TLS.
	<p>
	
	</p>
	*/
	public static final AttAqBetriebsZustaende ZUSTAND_0_AQNORMALBETRIEB = new AttAqBetriebsZustaende("AQNormalbetrieb", 		Byte
	.valueOf("0"));

	/**
	Blindbetrieb im Sinne der Definition der TLS.
	<p>
	
	</p>
	*/
	public static final AttAqBetriebsZustaende ZUSTAND_1_AQBLINDBETRIEB = new AttAqBetriebsZustaende("AQBlindbetrieb", 		Byte
	.valueOf("1"));

	/**
	Vorortbetrieb im Sinne der Definition der TLS.
	<p>
	
	</p>
	*/
	public static final AttAqBetriebsZustaende ZUSTAND_2_AQVORORTBETRIEB = new AttAqBetriebsZustaende("AQVorortbetrieb", 		Byte
	.valueOf("2"));

	/**
	Autarkbetrieb im Sinne der Definition der TLS.
	<p>
	
	</p>
	*/
	public static final AttAqBetriebsZustaende ZUSTAND_3_AQAUTARKBETRIEB = new AttAqBetriebsZustaende("AQAutarkbetrieb", 		Byte
	.valueOf("3"));

	/**
	Testbetrieb im Sinne der Definition der TLS.
	<p>
	
	</p>
	*/
	public static final AttAqBetriebsZustaende ZUSTAND_4_AQTESTBETRIEB = new AttAqBetriebsZustaende("AQTestbetrieb", 		Byte
	.valueOf("4"));

	/**
	Notbetrieb im Sinne der Definition der TLS.
	<p>
	
	</p>
	*/
	public static final AttAqBetriebsZustaende ZUSTAND_5_AQNOTBETRIEB = new AttAqBetriebsZustaende("AQNotbetrieb", 		Byte
	.valueOf("5"));

	/**
	Externe Steuerung: Steuerung der Anzeige wurde von einem Dritten System vorgenommen. (Beispiel KRI2c, TunnelEAK).
	<p>
	
	</p>
	*/
	public static final AttAqBetriebsZustaende ZUSTAND_6_AQEXTERNESTEUERUNG = new AttAqBetriebsZustaende("AQExterneSteuerung", 		Byte
	.valueOf("6"));

	/**
	Tunnelbetrieb: Steuerung wurde von einem Tunnel vorgenommen, und diesem System mitgeteilt. Beispiel: "read only" Verbindung zu einem Tunnelbetriebsrechner, Anbindung an einen Tunnel, der die Schaltungen dieser Anlage gegenüber seinen eigenen Schaltanforderungen einer Priorisierung unterzieht und die resultierende Schaltung in einer Rückmeldung als Tunnelbetrieb oder Normalbetrieb je nach Schaltungsursache zurückmeldet.
	<p>
	
	</p>
	*/
	public static final AttAqBetriebsZustaende ZUSTAND_7_AQTUNNELBETRIEB = new AttAqBetriebsZustaende("AQTunnelbetrieb", 		Byte
	.valueOf("7"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttAqBetriebsZustaende getZustand(final 		Byte
	 value) {
		for (AttAqBetriebsZustaende e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttAqBetriebsZustaende getZustand(final String value) {
		for (AttAqBetriebsZustaende e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttAqBetriebsZustaende> getZustaende() {
		List<AttAqBetriebsZustaende> list = new ArrayList<AttAqBetriebsZustaende>();
		list.add(ZUSTAND_1N_UNDEFINIERT);
		list.add(ZUSTAND_0_AQNORMALBETRIEB);
		list.add(ZUSTAND_1_AQBLINDBETRIEB);
		list.add(ZUSTAND_2_AQVORORTBETRIEB);
		list.add(ZUSTAND_3_AQAUTARKBETRIEB);
		list.add(ZUSTAND_4_AQTESTBETRIEB);
		list.add(ZUSTAND_5_AQNOTBETRIEB);
		list.add(ZUSTAND_6_AQEXTERNESTEUERUNG);
		list.add(ZUSTAND_7_AQTUNNELBETRIEB);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut AqBetriebsZustände.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttAqBetriebsZustaende(final 		Byte
	 value) {
		super(value);
	}
	
	private AttAqBetriebsZustaende(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
