/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attribut für mögliche Fehlerzustände eines Dirigenten.
<p>
Semantisch von Steueralgorithmen und Benutzeroberflächen auswertbarer Fehlerzustand des Dirigenten. Weitere Zustände sind im Rahmen der Fortschreibung des Datenmodells zu ergänzen. Für lokal notwendige Erweiterungen sollten abgeleitete Variablen verwendet werden.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 11
 */
public class AttDirigentFehlerZustand extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttDirigentFehlerZustand ZUSTAND_1N_UNDEFINIERT = new AttDirigentFehlerZustand("Undefiniert", 		Byte
	.valueOf("-1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDirigentFehlerZustand ZUSTAND_0_OK = new AttDirigentFehlerZustand("OK", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDirigentFehlerZustand ZUSTAND_1_GESTOERT = new AttDirigentFehlerZustand("Gestört", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDirigentFehlerZustand ZUSTAND_2_TEILSTOERUNG = new AttDirigentFehlerZustand("Teilstörung", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDirigentFehlerZustand ZUSTAND_3_STROMAUSFALL = new AttDirigentFehlerZustand("Stromausfall", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDirigentFehlerZustand ZUSTAND_4_KOMMUNIKATIONSAUSFALL = new AttDirigentFehlerZustand("Kommunikationsausfall", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDirigentFehlerZustand ZUSTAND_5_TUERKONTAKT = new AttDirigentFehlerZustand("Türkontakt", 		Byte
	.valueOf("5"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttDirigentFehlerZustand getZustand(final 		Byte
	 value) {
		for (AttDirigentFehlerZustand e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttDirigentFehlerZustand getZustand(final String value) {
		for (AttDirigentFehlerZustand e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttDirigentFehlerZustand> getZustaende() {
		List<AttDirigentFehlerZustand> list = new ArrayList<AttDirigentFehlerZustand>();
		list.add(ZUSTAND_1N_UNDEFINIERT);
		list.add(ZUSTAND_0_OK);
		list.add(ZUSTAND_1_GESTOERT);
		list.add(ZUSTAND_2_TEILSTOERUNG);
		list.add(ZUSTAND_3_STROMAUSFALL);
		list.add(ZUSTAND_4_KOMMUNIKATIONSAUSFALL);
		list.add(ZUSTAND_5_TUERKONTAKT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut DirigentFehlerZustand.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttDirigentFehlerZustand(final 		Byte
	 value) {
		super(value);
	}
	
	private AttDirigentFehlerZustand(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
