/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class KdAnzeigeQuerschnitt extends AbstractKonfigurationsDatensatz<KdAnzeigeQuerschnitt.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnittTyp
				 _anzeigeQuerschnittTyp
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.HochbauSchrankSchacht
				> _zuHochbauSchrankSchacht = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.HochbauSchrankSchacht
				>(0, true);
		
			/**
			Typ des Anzeigequerschnitts.
			<p>
			
			</p>
			
			@return der Wert von AnzeigeQuerschnittTyp.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnittTyp
				 getAnzeigeQuerschnittTyp() {
				return _anzeigeQuerschnittTyp;
			}
		
			/**
			Typ des Anzeigequerschnitts.
			<p>
			
			</p>
			
			@param _anzeigeQuerschnittTyp der neue Wert von AnzeigeQuerschnittTyp.
			*/
			public void setAnzeigeQuerschnittTyp(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnittTyp
			 _anzeigeQuerschnittTyp) {
				this._anzeigeQuerschnittTyp = _anzeigeQuerschnittTyp;
			}
		
			/**
			Liste von Referenzen auf die HochbauSchrankSchacht-Objekte, durch die der Anzeigequerschnitt realisiert wird..
			<p>
			
			</p>
			
			@return der Wert von ZuHochbauSchrankSchacht.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.HochbauSchrankSchacht
				> getZuHochbauSchrankSchacht() {
				return _zuHochbauSchrankSchacht;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soAnzeigeQuerschnittTyp = getAnzeigeQuerschnittTyp();
						final SystemObject tmpAnzeigeQuerschnittTyp;
							if (soAnzeigeQuerschnittTyp instanceof SystemObject) {
								tmpAnzeigeQuerschnittTyp = (SystemObject)soAnzeigeQuerschnittTyp;
							} else if(soAnzeigeQuerschnittTyp instanceof SystemObjekt){
								tmpAnzeigeQuerschnittTyp = ((SystemObjekt)soAnzeigeQuerschnittTyp).getSystemObject();
							} else{
								tmpAnzeigeQuerschnittTyp = null;
							}
						datum.getReferenceValue("AnzeigeQuerschnittTyp").setSystemObject(tmpAnzeigeQuerschnittTyp);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayZuHochbauSchrankSchacht = datum.getReferenceArray("ZuHochbauSchrankSchacht");
						arrayZuHochbauSchrankSchacht.setLength(getZuHochbauSchrankSchacht().size());
						for (int i = 0; i < arrayZuHochbauSchrankSchacht.getLength(); ++i) {
							final Object soZuHochbauSchrankSchacht = getZuHochbauSchrankSchacht().get(i);
							final SystemObject tmpZuHochbauSchrankSchacht;
							if (soZuHochbauSchrankSchacht instanceof SystemObject) {
								tmpZuHochbauSchrankSchacht = (SystemObject)soZuHochbauSchrankSchacht;
							} else if(soZuHochbauSchrankSchacht instanceof SystemObjekt){
								tmpZuHochbauSchrankSchacht = ((SystemObjekt)soZuHochbauSchrankSchacht).getSystemObject();
							} else{
								tmpZuHochbauSchrankSchacht = null;
							}
							arrayZuHochbauSchrankSchacht.getReferenceValue(i).setSystemObject(tmpZuHochbauSchrankSchacht);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idAnzeigeQuerschnittTyp = daten.getReferenceValue("AnzeigeQuerschnittTyp").getId();
						final SystemObjekt tmpAnzeigeQuerschnittTyp;
						if (idAnzeigeQuerschnittTyp == 0) {
							tmpAnzeigeQuerschnittTyp = null;
						} else {
							final SystemObject soAnzeigeQuerschnittTyp = factory.getDav().getDataModel().getObject(idAnzeigeQuerschnittTyp);
							if (soAnzeigeQuerschnittTyp == null) {
									tmpAnzeigeQuerschnittTyp = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeQuerschnittTypUngueltig(idAnzeigeQuerschnittTyp);
							} else {
								tmpAnzeigeQuerschnittTyp = factory.getModellobjekt(soAnzeigeQuerschnittTyp);
							}
						}
						setAnzeigeQuerschnittTyp((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnittTyp
						) tmpAnzeigeQuerschnittTyp);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayZuHochbauSchrankSchacht = daten.getReferenceArray("ZuHochbauSchrankSchacht");
						for (int i = 0; i < arrayZuHochbauSchrankSchacht.getLength(); ++i) {
							final long idZuHochbauSchrankSchacht = daten.getReferenceArray("ZuHochbauSchrankSchacht").getReferenceValue(i).getId();
							final SystemObjekt tmpZuHochbauSchrankSchacht;
							if (idZuHochbauSchrankSchacht == 0) {
								tmpZuHochbauSchrankSchacht = null;
							} else {
								final SystemObject soZuHochbauSchrankSchacht = factory.getDav().getDataModel().getObject(idZuHochbauSchrankSchacht);
								if (soZuHochbauSchrankSchacht == null) {
										tmpZuHochbauSchrankSchacht = new de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.impl.HochbauSchrankSchachtUngueltig(idZuHochbauSchrankSchacht);
								} else {
									tmpZuHochbauSchrankSchacht = factory.getModellobjekt(soZuHochbauSchrankSchacht);
								}
							}
								getZuHochbauSchrankSchacht().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmgeraeteeinbauorte.objekte.HochbauSchrankSchacht
								) tmpZuHochbauSchrankSchacht);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAnzeigeQuerschnittTyp(getAnzeigeQuerschnittTyp());
						klon._zuHochbauSchrankSchacht = getZuHochbauSchrankSchacht().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.anzeigeQuerschnitt";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdAnzeigeQuerschnitt(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
