/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdFont extends AbstractKonfigurationsDatensatz<KdFont.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _font
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttSchrifthoehePixel
				 _schrifthoehePixel
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttSchrifthoeheMillimeter
				 _schrifthoeheMillimeter
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttZeichenAbstandBreite
				 _zeichenAbstandStandard
				;
		
			/**
			Name des Fonts.
			<p>
			
			</p>
			
			@return der Wert von Font.
			*/
				public String
				 getFont() {
				return _font;
			}
		
			/**
			Name des Fonts.
			<p>
			
			</p>
			
			@param _font der neue Wert von Font.
			*/
			public void setFont(String
			 _font) {
				if (_font.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._font = _font;
			}
		
			/**
			Schrifthöhe des Font in Pixel.
			<p>
			
			</p>
			
			@return der Wert von SchrifthoehePixel.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttSchrifthoehePixel
				 getSchrifthoehePixel() {
				return _schrifthoehePixel;
			}
		
			/**
			Schrifthöhe des Font in Pixel.
			<p>
			
			</p>
			
			@param _schrifthoehePixel der neue Wert von SchrifthoehePixel.
			*/
			public void setSchrifthoehePixel(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttSchrifthoehePixel
			 _schrifthoehePixel) {
				this._schrifthoehePixel = _schrifthoehePixel;
			}
		
			/**
			Schrifthöhe des Font in Millimeter.
			<p>
			
			</p>
			
			@return der Wert von SchrifthoeheMillimeter.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttSchrifthoeheMillimeter
				 getSchrifthoeheMillimeter() {
				return _schrifthoeheMillimeter;
			}
		
			/**
			Schrifthöhe des Font in Millimeter.
			<p>
			
			</p>
			
			@param _schrifthoeheMillimeter der neue Wert von SchrifthoeheMillimeter.
			*/
			public void setSchrifthoeheMillimeter(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttSchrifthoeheMillimeter
			 _schrifthoeheMillimeter) {
				this._schrifthoeheMillimeter = _schrifthoeheMillimeter;
			}
		
			/**
			Normaler Zeichenabstand des Fonts in Anteilen der Schrifthöhe. In der Regel eine positive Zahl.
			<p>
			
			</p>
			
			@return der Wert von ZeichenAbstandStandard.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttZeichenAbstandBreite
				 getZeichenAbstandStandard() {
				return _zeichenAbstandStandard;
			}
		
			/**
			Normaler Zeichenabstand des Fonts in Anteilen der Schrifthöhe. In der Regel eine positive Zahl.
			<p>
			
			</p>
			
			@param _zeichenAbstandStandard der neue Wert von ZeichenAbstandStandard.
			*/
			public void setZeichenAbstandStandard(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttZeichenAbstandBreite
			 _zeichenAbstandStandard) {
				this._zeichenAbstandStandard = _zeichenAbstandStandard;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getFont() != null) {
						datum.getTextValue("Font").setText(getFont());
					}
					// GanzzahlAttributTyp
					if (getSchrifthoehePixel() != null) {
		                if (getSchrifthoehePixel().isZustand()) {
		                    datum.getUnscaledValue("SchrifthöhePixel").setText(getSchrifthoehePixel().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SchrifthöhePixel").set(getSchrifthoehePixel().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSchrifthoeheMillimeter() != null) {
		                if (getSchrifthoeheMillimeter().isZustand()) {
		                    datum.getUnscaledValue("SchrifthöheMillimeter").setText(getSchrifthoeheMillimeter().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SchrifthöheMillimeter").set(getSchrifthoeheMillimeter().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getZeichenAbstandStandard() != null) {
		                if (getZeichenAbstandStandard().isZustand()) {
		                    datum.getUnscaledValue("ZeichenAbstandStandard").setText(getZeichenAbstandStandard().toString());
		                } else {
							datum.
							getScaledValue
		                	("ZeichenAbstandStandard").set(getZeichenAbstandStandard().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setFont(daten.getTextValue("Font").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SchrifthöhePixel").isState()) {
								setSchrifthoehePixel(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttSchrifthoehePixel
								.getZustand(daten.getScaledValue("SchrifthöhePixel").getText()));
							} else {
							setSchrifthoehePixel(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttSchrifthoehePixel
							(daten.
								getUnscaledValue
							("SchrifthöhePixel").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SchrifthöheMillimeter").isState()) {
								setSchrifthoeheMillimeter(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttSchrifthoeheMillimeter
								.getZustand(daten.getScaledValue("SchrifthöheMillimeter").getText()));
							} else {
							setSchrifthoeheMillimeter(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttSchrifthoeheMillimeter
							(daten.
								getUnscaledValue
							("SchrifthöheMillimeter").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ZeichenAbstandStandard").isState()) {
								setZeichenAbstandStandard(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttZeichenAbstandBreite
								.getZustand(daten.getScaledValue("ZeichenAbstandStandard").getText()));
							} else {
							setZeichenAbstandStandard(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttZeichenAbstandBreite
							(daten.
								getScaledValue
							("ZeichenAbstandStandard").
								doubleValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setFont(getFont());
							klon.setSchrifthoehePixel(getSchrifthoehePixel());
							klon.setSchrifthoeheMillimeter(getSchrifthoeheMillimeter());
							klon.setZeichenAbstandStandard(getZeichenAbstandStandard());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.font";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdFont(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
