/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdWechseltext extends AbstractKonfigurationsDatensatz<KdWechseltext.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Font
				 _font
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTextAusrichtung
				 _textAusrichtung
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Zeichen
				> _textdefinition = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Zeichen
				>(0, true);
		
			/**
			Typ des Fonts.
			<p>
			
			</p>
			
			@return der Wert von Font.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Font
				 getFont() {
				return _font;
			}
		
			/**
			Typ des Fonts.
			<p>
			
			</p>
			
			@param _font der neue Wert von Font.
			*/
			public void setFont(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Font
			 _font) {
				this._font = _font;
			}
		
			/**
			Text-Ausrichtung in der Anzeige.
			<p>
			
			</p>
			
			@return der Wert von TextAusrichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTextAusrichtung
				 getTextAusrichtung() {
				return _textAusrichtung;
			}
		
			/**
			Text-Ausrichtung in der Anzeige.
			<p>
			
			</p>
			
			@param _textAusrichtung der neue Wert von TextAusrichtung.
			*/
			public void setTextAusrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTextAusrichtung
			 _textAusrichtung) {
				this._textAusrichtung = _textAusrichtung;
			}
		
			/**
			Geordnete Liste mit den Referenzen auf die im Wechseltext enthaltenen Zeichen. .
			<p>
			
			</p>
			
			@return der Wert von Textdefinition.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Zeichen
				> getTextdefinition() {
				return _textdefinition;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soFont = getFont();
						final SystemObject tmpFont;
							if (soFont instanceof SystemObject) {
								tmpFont = (SystemObject)soFont;
							} else if(soFont instanceof SystemObjekt){
								tmpFont = ((SystemObjekt)soFont).getSystemObject();
							} else{
								tmpFont = null;
							}
						datum.getReferenceValue("Font").setSystemObject(tmpFont);
					// GanzzahlAttributTyp
					if (getTextAusrichtung() != null) {
		                if (getTextAusrichtung().isZustand()) {
		                    datum.getUnscaledValue("TextAusrichtung").setText(getTextAusrichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("TextAusrichtung").set(getTextAusrichtung().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayTextdefinition = datum.getReferenceArray("Textdefinition");
						arrayTextdefinition.setLength(getTextdefinition().size());
						for (int i = 0; i < arrayTextdefinition.getLength(); ++i) {
							final Object soTextdefinition = getTextdefinition().get(i);
							final SystemObject tmpTextdefinition;
							if (soTextdefinition instanceof SystemObject) {
								tmpTextdefinition = (SystemObject)soTextdefinition;
							} else if(soTextdefinition instanceof SystemObjekt){
								tmpTextdefinition = ((SystemObjekt)soTextdefinition).getSystemObject();
							} else{
								tmpTextdefinition = null;
							}
							arrayTextdefinition.getReferenceValue(i).setSystemObject(tmpTextdefinition);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idFont = daten.getReferenceValue("Font").getId();
						final SystemObjekt tmpFont;
						if (idFont == 0) {
							tmpFont = null;
						} else {
							final SystemObject soFont = factory.getDav().getDataModel().getObject(idFont);
							if (soFont == null) {
									tmpFont = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.FontUngueltig(idFont);
							} else {
								tmpFont = factory.getModellobjekt(soFont);
							}
						}
						setFont((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Font
						) tmpFont);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("TextAusrichtung").isState()) {
								setTextAusrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTextAusrichtung
								.getZustand(daten.getScaledValue("TextAusrichtung").getText()));
							} else {
							setTextAusrichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTextAusrichtung
							(daten.
								getUnscaledValue
							("TextAusrichtung").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayTextdefinition = daten.getReferenceArray("Textdefinition");
						for (int i = 0; i < arrayTextdefinition.getLength(); ++i) {
							final long idTextdefinition = daten.getReferenceArray("Textdefinition").getReferenceValue(i).getId();
							final SystemObjekt tmpTextdefinition;
							if (idTextdefinition == 0) {
								tmpTextdefinition = null;
							} else {
								final SystemObject soTextdefinition = factory.getDav().getDataModel().getObject(idTextdefinition);
								if (soTextdefinition == null) {
										tmpTextdefinition = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.ZeichenUngueltig(idTextdefinition);
								} else {
									tmpTextdefinition = factory.getModellobjekt(soTextdefinition);
								}
							}
								getTextdefinition().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Zeichen
								) tmpTextdefinition);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setFont(getFont());
							klon.setTextAusrichtung(getTextAusrichtung());
						klon._textdefinition = getTextdefinition().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.wechseltext";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdWechseltext(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
