/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdWzgInhaltGrafik extends AbstractKonfigurationsDatensatz<KdWzgInhaltGrafik.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
				 _positionX
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
				 _positionY
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikSkalierung
				 _skalierung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _blinken
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
				 _blinktakt
				;
				private String
				 _uRL
				= new String
				()
				;
		
			/**
			X-Position der Grafik.
			<p>
			
			</p>
			
			@return der Wert von PositionX.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
				 getPositionX() {
				return _positionX;
			}
		
			/**
			X-Position der Grafik.
			<p>
			
			</p>
			
			@param _positionX der neue Wert von PositionX.
			*/
			public void setPositionX(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
			 _positionX) {
				this._positionX = _positionX;
			}
		
			/**
			Y-Position der Grafik.
			<p>
			
			</p>
			
			@return der Wert von PositionY.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
				 getPositionY() {
				return _positionY;
			}
		
			/**
			Y-Position der Grafik.
			<p>
			
			</p>
			
			@param _positionY der neue Wert von PositionY.
			*/
			public void setPositionY(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
			 _positionY) {
				this._positionY = _positionY;
			}
		
			/**
			Skalierung der Grafik.
			<p>
			
			</p>
			
			@return der Wert von Skalierung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikSkalierung
				 getSkalierung() {
				return _skalierung;
			}
		
			/**
			Skalierung der Grafik.
			<p>
			
			</p>
			
			@param _skalierung der neue Wert von Skalierung.
			*/
			public void setSkalierung(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikSkalierung
			 _skalierung) {
				this._skalierung = _skalierung;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Blinken.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getBlinken() {
				return _blinken;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _blinken der neue Wert von Blinken.
			*/
			public void setBlinken(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _blinken) {
				this._blinken = _blinken;
			}
		
			/**
			Blinktakt der Grafik.
			<p>
			Zeit für einen komletten Zyklus von Beginn der sichtbaren Anzeige der Grafik
									bis zur erneuten sichtbaren Anzeige der Grafik. Es ist von einem Tastverhältnis
									von 0,5 auszugehen, dieses kann jedoch bei der tatsächlichen Realisierung vor Ort variieren
			</p>
			
			@return der Wert von Blinktakt.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
				 getBlinktakt() {
				return _blinktakt;
			}
		
			/**
			Blinktakt der Grafik.
			<p>
			Zeit für einen komletten Zyklus von Beginn der sichtbaren Anzeige der Grafik
									bis zur erneuten sichtbaren Anzeige der Grafik. Es ist von einem Tastverhältnis
									von 0,5 auszugehen, dieses kann jedoch bei der tatsächlichen Realisierung vor Ort variieren
			</p>
			
			@param _blinktakt der neue Wert von Blinktakt.
			*/
			public void setBlinktakt(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
			 _blinktakt) {
				this._blinktakt = _blinktakt;
			}
		
			/**
			URL der Grafik.
			<p>
			
			</p>
			
			@return der Wert von URL.
			*/
				public String
				 getURL() {
				return _uRL;
			}
		
			/**
			URL der Grafik.
			<p>
			
			</p>
			
			@param _uRL der neue Wert von URL.
			*/
			public void setURL(String
			 _uRL) {
				if (_uRL.length() > 10000) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 10000 + " Zeichen sein.");
				}
				this._uRL = _uRL;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getPositionX() != null) {
		                if (getPositionX().isZustand()) {
		                    datum.getUnscaledValue("PositionX").setText(getPositionX().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PositionX").set(getPositionX().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPositionY() != null) {
		                if (getPositionY().isZustand()) {
		                    datum.getUnscaledValue("PositionY").setText(getPositionY().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PositionY").set(getPositionY().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSkalierung() != null) {
		                if (getSkalierung().isZustand()) {
		                    datum.getUnscaledValue("Skalierung").setText(getSkalierung().toString());
		                } else {
							datum.
							getScaledValue
		                	("Skalierung").set(getSkalierung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBlinken() != null) {
		                if (getBlinken().isZustand()) {
		                    datum.getUnscaledValue("Blinken").setText(getBlinken().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Blinken").set(getBlinken().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBlinktakt() != null) {
		                if (getBlinktakt().isZustand()) {
		                    datum.getUnscaledValue("Blinktakt").setText(getBlinktakt().toString());
		                } else {
							datum.
							getScaledValue
		                	("Blinktakt").set(getBlinktakt().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getURL() != null) {
						datum.getTextValue("URL").setText(getURL());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setPositionX(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
							(daten.
								getUnscaledValue
							("PositionX").
									intValue
							()));
					// GanzzahlAttributTyp
							setPositionY(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
							(daten.
								getUnscaledValue
							("PositionY").
									intValue
							()));
					// GanzzahlAttributTyp
							setSkalierung(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikSkalierung
							(daten.
								getScaledValue
							("Skalierung").
								doubleValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Blinken").isState()) {
								setBlinken(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Blinken").getText()));
							} else {
							setBlinken(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Blinken").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Blinktakt").isState()) {
								setBlinktakt(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
								.getZustand(daten.getScaledValue("Blinktakt").getText()));
							} else {
							setBlinktakt(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttTimeout
							(daten.
								getScaledValue
							("Blinktakt").
								doubleValue
							()));
							}
					// ZeichenkettenAttributTyp
						setURL(daten.getTextValue("URL").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setPositionX(getPositionX());
							klon.setPositionY(getPositionY());
							klon.setSkalierung(getSkalierung());
							klon.setBlinken(getBlinken());
							klon.setBlinktakt(getBlinktakt());
							klon.setURL(getURL());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.wzgInhaltGrafik";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdWzgInhaltGrafik(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
