/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Anzeigequerschnitt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AnzeigeQuerschnittImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public AnzeigeQuerschnittImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public AnzeigeQuerschnittImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein AnzeigeQuerschnitt.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige> anzeigen;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige> getAnzeigen() {
		if (anzeigen == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("Anzeigen") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("Anzeigen").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige) getObjektFactory().getModellobjekt(so));
			}
			anzeigen = Collections.unmodifiableCollection(menge);
		}
		return anzeigen;
	}

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdAnzeigeQuerschnittEigenschaftSoll getOdAnzeigeQuerschnittEigenschaftSoll() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdAnzeigeQuerschnittEigenschaftSoll.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdAnzeigeQuerschnittEigenschaftIst getOdAnzeigeQuerschnittEigenschaftIst() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdAnzeigeQuerschnittEigenschaftIst.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten.KdAnzeigeQuerschnittNba getKdAnzeigeQuerschnittNba() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten.KdAnzeigeQuerschnittNba.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdNichtAnzeigeAutarkIst getOdNichtAnzeigeAutarkIst() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdNichtAnzeigeAutarkIst.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten.KdAnzeigeQuerschnittQuellenVlt getKdAnzeigeQuerschnittQuellenVlt() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten.KdAnzeigeQuerschnittQuellenVlt.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdAnzeigeQuerschnittSchaltbarkeitNba getOdAnzeigeQuerschnittSchaltbarkeitNba() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdAnzeigeQuerschnittSchaltbarkeitNba.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt getKdPunktLiegtAufLinienObjekt() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdNichtAnzeigeAutarkSoll getOdNichtAnzeigeAutarkSoll() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdNichtAnzeigeAutarkSoll.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten.KdAnzeigeQuerschnitt getKdAnzeigeQuerschnitt() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten.KdAnzeigeQuerschnitt.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
