/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ist Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 12
 */
public class OdDirigentEigenschaftIst extends AbstractOnlineDatensatz<OdDirigentEigenschaftIst.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.AqZustand,
				};
			}
	
			/**
			 * Zustand durch Rückmeldung von Extern.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AqZustand = new Aspekte("AQZustand", "asp.aqZustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlDirigentEigenschaft
				 _eigenschaft
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlDirigentEigenschaft
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttDirigentFehlerZustand
				 _status
				;
				@Defaultwert(wert = "nicht ermittelbar")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttJaNeinNichtErmittelbar
				 _fehlerAufgetreten
				;
				@Defaultwert(wert = "nicht ermittelbar")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttJaNeinNichtErmittelbar
				 _programmAbgeschlossen
				;
		
			/**
			Gemeinsame Eigenschaften für Soll und Ist.
			<p>
			
			</p>
			
			@return der Wert von Eigenschaft.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlDirigentEigenschaft
				 getEigenschaft() {
				return _eigenschaft;
			}
		
			/**
			Gemeinsame Eigenschaften für Soll und Ist.
			<p>
			
			</p>
			
			@param _eigenschaft der neue Wert von Eigenschaft.
			*/
			public void setEigenschaft(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AtlDirigentEigenschaft
			 _eigenschaft) {
				this._eigenschaft = _eigenschaft;
			}
		
			/**
			Aktueller Status des Dirigenten. OK, gestört, teilgestört, usw..
			<p>
			
			</p>
			
			@return der Wert von Status.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttDirigentFehlerZustand
				 getStatus() {
				return _status;
			}
		
			/**
			Aktueller Status des Dirigenten. OK, gestört, teilgestört, usw..
			<p>
			
			</p>
			
			@param _status der neue Wert von Status.
			*/
			public void setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttDirigentFehlerZustand
			 _status) {
				this._status = _status;
			}
		
			/**
			Information, ob bei der Bearbeitung ein Fehler aufgetreten ist (siehe TLS).
			<p>
			
			</p>
			
			@return der Wert von FehlerAufgetreten.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttJaNeinNichtErmittelbar
				 getFehlerAufgetreten() {
				return _fehlerAufgetreten;
			}
		
			/**
			Information, ob bei der Bearbeitung ein Fehler aufgetreten ist (siehe TLS).
			<p>
			
			</p>
			
			@param _fehlerAufgetreten der neue Wert von FehlerAufgetreten.
			*/
			public void setFehlerAufgetreten(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttJaNeinNichtErmittelbar
			 _fehlerAufgetreten) {
				this._fehlerAufgetreten = _fehlerAufgetreten;
			}
		
			/**
			Information, ob die Programmbearbeitung abgeschlossen ist (siehe TLS).
			<p>
			
			</p>
			
			@return der Wert von ProgrammAbgeschlossen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttJaNeinNichtErmittelbar
				 getProgrammAbgeschlossen() {
				return _programmAbgeschlossen;
			}
		
			/**
			Information, ob die Programmbearbeitung abgeschlossen ist (siehe TLS).
			<p>
			
			</p>
			
			@param _programmAbgeschlossen der neue Wert von ProgrammAbgeschlossen.
			*/
			public void setProgrammAbgeschlossen(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttJaNeinNichtErmittelbar
			 _programmAbgeschlossen) {
				this._programmAbgeschlossen = _programmAbgeschlossen;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getEigenschaft().bean2Atl(datum.getItem("Eigenschaft"), factory);
					// GanzzahlAttributTyp
					if (getStatus() != null) {
		                if (getStatus().isZustand()) {
		                    datum.getUnscaledValue("Status").setText(getStatus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Status").set(getStatus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFehlerAufgetreten() != null) {
		                if (getFehlerAufgetreten().isZustand()) {
		                    datum.getUnscaledValue("FehlerAufgetreten").setText(getFehlerAufgetreten().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FehlerAufgetreten").set(getFehlerAufgetreten().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getProgrammAbgeschlossen() != null) {
		                if (getProgrammAbgeschlossen().isZustand()) {
		                    datum.getUnscaledValue("ProgrammAbgeschlossen").setText(getProgrammAbgeschlossen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ProgrammAbgeschlossen").set(getProgrammAbgeschlossen().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getEigenschaft().atl2Bean(daten.getItem("Eigenschaft"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Status").isState()) {
								setStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttDirigentFehlerZustand
								.getZustand(daten.getScaledValue("Status").getText()));
							} else {
							setStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttDirigentFehlerZustand
							(daten.
								getUnscaledValue
							("Status").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FehlerAufgetreten").isState()) {
								setFehlerAufgetreten(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttJaNeinNichtErmittelbar
								.getZustand(daten.getScaledValue("FehlerAufgetreten").getText()));
							} else {
							setFehlerAufgetreten(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttJaNeinNichtErmittelbar
							(daten.
								getUnscaledValue
							("FehlerAufgetreten").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ProgrammAbgeschlossen").isState()) {
								setProgrammAbgeschlossen(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttJaNeinNichtErmittelbar
								.getZustand(daten.getScaledValue("ProgrammAbgeschlossen").getText()));
							} else {
							setProgrammAbgeschlossen(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttJaNeinNichtErmittelbar
							(daten.
								getUnscaledValue
							("ProgrammAbgeschlossen").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._eigenschaft = getEigenschaft().clone();
							klon.setStatus(getStatus());
							klon.setFehlerAufgetreten(getFehlerAufgetreten());
							klon.setProgrammAbgeschlossen(getProgrammAbgeschlossen());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.dirigentEigenschaftIst";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdDirigentEigenschaftIst(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
