/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdAnzeigeQuerschnittAktor extends AbstractKonfigurationsDatensatz<KdAnzeigeQuerschnittAktor.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
				 _anzeigeQuerschnittReferenz
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.AnzeigeQuerschnittTypUmsetzung
				 _anzeigeQuerschnittTypUmsetzungReferenz
				;
		
			/**
			Referenz auf ein Objekt vom Typ AnzeigeQuerschnitt zur Umsetzung der Befehle und Rückmeldungen zu und von der externen Kommunikation.
			<p>
			
			</p>
			
			@return der Wert von AnzeigeQuerschnittReferenz.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
				 getAnzeigeQuerschnittReferenz() {
				return _anzeigeQuerschnittReferenz;
			}
		
			/**
			Referenz auf ein Objekt vom Typ AnzeigeQuerschnitt zur Umsetzung der Befehle und Rückmeldungen zu und von der externen Kommunikation.
			<p>
			
			</p>
			
			@param _anzeigeQuerschnittReferenz der neue Wert von AnzeigeQuerschnittReferenz.
			*/
			public void setAnzeigeQuerschnittReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
			 _anzeigeQuerschnittReferenz) {
				this._anzeigeQuerschnittReferenz = _anzeigeQuerschnittReferenz;
			}
		
			/**
			Referenz auf ein Objekt vom Typ AnzeigeQuerschnittTypUmsetzung zur Umsetzung der Befehle und Rückmeldungen zu und von der externen Kommunikation.
			<p>
			
			</p>
			
			@return der Wert von AnzeigeQuerschnittTypUmsetzungReferenz.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.AnzeigeQuerschnittTypUmsetzung
				 getAnzeigeQuerschnittTypUmsetzungReferenz() {
				return _anzeigeQuerschnittTypUmsetzungReferenz;
			}
		
			/**
			Referenz auf ein Objekt vom Typ AnzeigeQuerschnittTypUmsetzung zur Umsetzung der Befehle und Rückmeldungen zu und von der externen Kommunikation.
			<p>
			
			</p>
			
			@param _anzeigeQuerschnittTypUmsetzungReferenz der neue Wert von AnzeigeQuerschnittTypUmsetzungReferenz.
			*/
			public void setAnzeigeQuerschnittTypUmsetzungReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.AnzeigeQuerschnittTypUmsetzung
			 _anzeigeQuerschnittTypUmsetzungReferenz) {
				this._anzeigeQuerschnittTypUmsetzungReferenz = _anzeigeQuerschnittTypUmsetzungReferenz;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soAnzeigeQuerschnittReferenz = getAnzeigeQuerschnittReferenz();
						final SystemObject tmpAnzeigeQuerschnittReferenz;
							if (soAnzeigeQuerschnittReferenz instanceof SystemObject) {
								tmpAnzeigeQuerschnittReferenz = (SystemObject)soAnzeigeQuerschnittReferenz;
							} else if(soAnzeigeQuerschnittReferenz instanceof SystemObjekt){
								tmpAnzeigeQuerschnittReferenz = ((SystemObjekt)soAnzeigeQuerschnittReferenz).getSystemObject();
							} else{
								tmpAnzeigeQuerschnittReferenz = null;
							}
						datum.getReferenceValue("AnzeigeQuerschnittReferenz").setSystemObject(tmpAnzeigeQuerschnittReferenz);
					// ObjektReferenzAttributTyp
						final Object soAnzeigeQuerschnittTypUmsetzungReferenz = getAnzeigeQuerschnittTypUmsetzungReferenz();
						final SystemObject tmpAnzeigeQuerschnittTypUmsetzungReferenz;
							if (soAnzeigeQuerschnittTypUmsetzungReferenz instanceof SystemObject) {
								tmpAnzeigeQuerschnittTypUmsetzungReferenz = (SystemObject)soAnzeigeQuerschnittTypUmsetzungReferenz;
							} else if(soAnzeigeQuerschnittTypUmsetzungReferenz instanceof SystemObjekt){
								tmpAnzeigeQuerschnittTypUmsetzungReferenz = ((SystemObjekt)soAnzeigeQuerschnittTypUmsetzungReferenz).getSystemObject();
							} else{
								tmpAnzeigeQuerschnittTypUmsetzungReferenz = null;
							}
						datum.getReferenceValue("AnzeigeQuerschnittTypUmsetzungReferenz").setSystemObject(tmpAnzeigeQuerschnittTypUmsetzungReferenz);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idAnzeigeQuerschnittReferenz = daten.getReferenceValue("AnzeigeQuerschnittReferenz").getId();
						final SystemObjekt tmpAnzeigeQuerschnittReferenz;
						if (idAnzeigeQuerschnittReferenz == 0) {
							tmpAnzeigeQuerschnittReferenz = null;
						} else {
							final SystemObject soAnzeigeQuerschnittReferenz = factory.getDav().getDataModel().getObject(idAnzeigeQuerschnittReferenz);
							if (soAnzeigeQuerschnittReferenz == null) {
									tmpAnzeigeQuerschnittReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeQuerschnittUngueltig(idAnzeigeQuerschnittReferenz);
							} else {
								tmpAnzeigeQuerschnittReferenz = factory.getModellobjekt(soAnzeigeQuerschnittReferenz);
							}
						}
						setAnzeigeQuerschnittReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
						) tmpAnzeigeQuerschnittReferenz);
					// ObjektReferenzAttributTyp
						final long idAnzeigeQuerschnittTypUmsetzungReferenz = daten.getReferenceValue("AnzeigeQuerschnittTypUmsetzungReferenz").getId();
						final SystemObjekt tmpAnzeigeQuerschnittTypUmsetzungReferenz;
						if (idAnzeigeQuerschnittTypUmsetzungReferenz == 0) {
							tmpAnzeigeQuerschnittTypUmsetzungReferenz = null;
						} else {
							final SystemObject soAnzeigeQuerschnittTypUmsetzungReferenz = factory.getDav().getDataModel().getObject(idAnzeigeQuerschnittTypUmsetzungReferenz);
							if (soAnzeigeQuerschnittTypUmsetzungReferenz == null) {
									tmpAnzeigeQuerschnittTypUmsetzungReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.impl.AnzeigeQuerschnittTypUmsetzungUngueltig(idAnzeigeQuerschnittTypUmsetzungReferenz);
							} else {
								tmpAnzeigeQuerschnittTypUmsetzungReferenz = factory.getModellobjekt(soAnzeigeQuerschnittTypUmsetzungReferenz);
							}
						}
						setAnzeigeQuerschnittTypUmsetzungReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.AnzeigeQuerschnittTypUmsetzung
						) tmpAnzeigeQuerschnittTypUmsetzungReferenz);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAnzeigeQuerschnittReferenz(getAnzeigeQuerschnittReferenz());
							klon.setAnzeigeQuerschnittTypUmsetzungReferenz(getAnzeigeQuerschnittTypUmsetzungReferenz());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.anzeigeQuerschnittAktor";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdAnzeigeQuerschnittAktor(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
