/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdAnzeigeTypUmsetzung extends AbstractKonfigurationsDatensatz<KdAnzeigeTypUmsetzung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.FontUmsetzung
				> _fontUmsetzungReferenz = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.FontUmsetzung
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.TextAusrichtungUmsetzung
				> _textAusrichtungUmsetzungReferenz = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.TextAusrichtungUmsetzung
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.ZeichenUmsetzung
				> _zeichenUmsetzungReferenz = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.ZeichenUmsetzung
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.WvzInhaltUmsetzung
				> _wvzInhaltUmsetzungReferenz = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.WvzInhaltUmsetzung
				>(0, true);
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.fontUmsetzung.
			<p>
			
			</p>
			
			@return der Wert von FontUmsetzungReferenz.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.FontUmsetzung
				> getFontUmsetzungReferenz() {
				return _fontUmsetzungReferenz;
			}
		
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.textAusrichtungUmsetzung.
			<p>
			
			</p>
			
			@return der Wert von TextAusrichtungUmsetzungReferenz.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.TextAusrichtungUmsetzung
				> getTextAusrichtungUmsetzungReferenz() {
				return _textAusrichtungUmsetzungReferenz;
			}
		
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.zeichenUmsetzung.
			<p>
			
			</p>
			
			@return der Wert von ZeichenUmsetzungReferenz.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.ZeichenUmsetzung
				> getZeichenUmsetzungReferenz() {
				return _zeichenUmsetzungReferenz;
			}
		
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.wvzInhaltUmsetzung.
			<p>
			
			</p>
			
			@return der Wert von WvzInhaltUmsetzungReferenz.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.WvzInhaltUmsetzung
				> getWvzInhaltUmsetzungReferenz() {
				return _wvzInhaltUmsetzungReferenz;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayFontUmsetzungReferenz = datum.getReferenceArray("FontUmsetzungReferenz");
						arrayFontUmsetzungReferenz.setLength(getFontUmsetzungReferenz().size());
						for (int i = 0; i < arrayFontUmsetzungReferenz.getLength(); ++i) {
							final Object soFontUmsetzungReferenz = getFontUmsetzungReferenz().get(i);
							final SystemObject tmpFontUmsetzungReferenz;
							if (soFontUmsetzungReferenz instanceof SystemObject) {
								tmpFontUmsetzungReferenz = (SystemObject)soFontUmsetzungReferenz;
							} else if(soFontUmsetzungReferenz instanceof SystemObjekt){
								tmpFontUmsetzungReferenz = ((SystemObjekt)soFontUmsetzungReferenz).getSystemObject();
							} else{
								tmpFontUmsetzungReferenz = null;
							}
							arrayFontUmsetzungReferenz.getReferenceValue(i).setSystemObject(tmpFontUmsetzungReferenz);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayTextAusrichtungUmsetzungReferenz = datum.getReferenceArray("TextAusrichtungUmsetzungReferenz");
						arrayTextAusrichtungUmsetzungReferenz.setLength(getTextAusrichtungUmsetzungReferenz().size());
						for (int i = 0; i < arrayTextAusrichtungUmsetzungReferenz.getLength(); ++i) {
							final Object soTextAusrichtungUmsetzungReferenz = getTextAusrichtungUmsetzungReferenz().get(i);
							final SystemObject tmpTextAusrichtungUmsetzungReferenz;
							if (soTextAusrichtungUmsetzungReferenz instanceof SystemObject) {
								tmpTextAusrichtungUmsetzungReferenz = (SystemObject)soTextAusrichtungUmsetzungReferenz;
							} else if(soTextAusrichtungUmsetzungReferenz instanceof SystemObjekt){
								tmpTextAusrichtungUmsetzungReferenz = ((SystemObjekt)soTextAusrichtungUmsetzungReferenz).getSystemObject();
							} else{
								tmpTextAusrichtungUmsetzungReferenz = null;
							}
							arrayTextAusrichtungUmsetzungReferenz.getReferenceValue(i).setSystemObject(tmpTextAusrichtungUmsetzungReferenz);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayZeichenUmsetzungReferenz = datum.getReferenceArray("ZeichenUmsetzungReferenz");
						arrayZeichenUmsetzungReferenz.setLength(getZeichenUmsetzungReferenz().size());
						for (int i = 0; i < arrayZeichenUmsetzungReferenz.getLength(); ++i) {
							final Object soZeichenUmsetzungReferenz = getZeichenUmsetzungReferenz().get(i);
							final SystemObject tmpZeichenUmsetzungReferenz;
							if (soZeichenUmsetzungReferenz instanceof SystemObject) {
								tmpZeichenUmsetzungReferenz = (SystemObject)soZeichenUmsetzungReferenz;
							} else if(soZeichenUmsetzungReferenz instanceof SystemObjekt){
								tmpZeichenUmsetzungReferenz = ((SystemObjekt)soZeichenUmsetzungReferenz).getSystemObject();
							} else{
								tmpZeichenUmsetzungReferenz = null;
							}
							arrayZeichenUmsetzungReferenz.getReferenceValue(i).setSystemObject(tmpZeichenUmsetzungReferenz);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayWvzInhaltUmsetzungReferenz = datum.getReferenceArray("WvzInhaltUmsetzungReferenz");
						arrayWvzInhaltUmsetzungReferenz.setLength(getWvzInhaltUmsetzungReferenz().size());
						for (int i = 0; i < arrayWvzInhaltUmsetzungReferenz.getLength(); ++i) {
							final Object soWvzInhaltUmsetzungReferenz = getWvzInhaltUmsetzungReferenz().get(i);
							final SystemObject tmpWvzInhaltUmsetzungReferenz;
							if (soWvzInhaltUmsetzungReferenz instanceof SystemObject) {
								tmpWvzInhaltUmsetzungReferenz = (SystemObject)soWvzInhaltUmsetzungReferenz;
							} else if(soWvzInhaltUmsetzungReferenz instanceof SystemObjekt){
								tmpWvzInhaltUmsetzungReferenz = ((SystemObjekt)soWvzInhaltUmsetzungReferenz).getSystemObject();
							} else{
								tmpWvzInhaltUmsetzungReferenz = null;
							}
							arrayWvzInhaltUmsetzungReferenz.getReferenceValue(i).setSystemObject(tmpWvzInhaltUmsetzungReferenz);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayFontUmsetzungReferenz = daten.getReferenceArray("FontUmsetzungReferenz");
						for (int i = 0; i < arrayFontUmsetzungReferenz.getLength(); ++i) {
							final long idFontUmsetzungReferenz = daten.getReferenceArray("FontUmsetzungReferenz").getReferenceValue(i).getId();
							final SystemObjekt tmpFontUmsetzungReferenz;
							if (idFontUmsetzungReferenz == 0) {
								tmpFontUmsetzungReferenz = null;
							} else {
								final SystemObject soFontUmsetzungReferenz = factory.getDav().getDataModel().getObject(idFontUmsetzungReferenz);
								if (soFontUmsetzungReferenz == null) {
										tmpFontUmsetzungReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.impl.FontUmsetzungUngueltig(idFontUmsetzungReferenz);
								} else {
									tmpFontUmsetzungReferenz = factory.getModellobjekt(soFontUmsetzungReferenz);
								}
							}
								getFontUmsetzungReferenz().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.FontUmsetzung
								) tmpFontUmsetzungReferenz);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayTextAusrichtungUmsetzungReferenz = daten.getReferenceArray("TextAusrichtungUmsetzungReferenz");
						for (int i = 0; i < arrayTextAusrichtungUmsetzungReferenz.getLength(); ++i) {
							final long idTextAusrichtungUmsetzungReferenz = daten.getReferenceArray("TextAusrichtungUmsetzungReferenz").getReferenceValue(i).getId();
							final SystemObjekt tmpTextAusrichtungUmsetzungReferenz;
							if (idTextAusrichtungUmsetzungReferenz == 0) {
								tmpTextAusrichtungUmsetzungReferenz = null;
							} else {
								final SystemObject soTextAusrichtungUmsetzungReferenz = factory.getDav().getDataModel().getObject(idTextAusrichtungUmsetzungReferenz);
								if (soTextAusrichtungUmsetzungReferenz == null) {
										tmpTextAusrichtungUmsetzungReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.impl.TextAusrichtungUmsetzungUngueltig(idTextAusrichtungUmsetzungReferenz);
								} else {
									tmpTextAusrichtungUmsetzungReferenz = factory.getModellobjekt(soTextAusrichtungUmsetzungReferenz);
								}
							}
								getTextAusrichtungUmsetzungReferenz().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.TextAusrichtungUmsetzung
								) tmpTextAusrichtungUmsetzungReferenz);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayZeichenUmsetzungReferenz = daten.getReferenceArray("ZeichenUmsetzungReferenz");
						for (int i = 0; i < arrayZeichenUmsetzungReferenz.getLength(); ++i) {
							final long idZeichenUmsetzungReferenz = daten.getReferenceArray("ZeichenUmsetzungReferenz").getReferenceValue(i).getId();
							final SystemObjekt tmpZeichenUmsetzungReferenz;
							if (idZeichenUmsetzungReferenz == 0) {
								tmpZeichenUmsetzungReferenz = null;
							} else {
								final SystemObject soZeichenUmsetzungReferenz = factory.getDav().getDataModel().getObject(idZeichenUmsetzungReferenz);
								if (soZeichenUmsetzungReferenz == null) {
										tmpZeichenUmsetzungReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.impl.ZeichenUmsetzungUngueltig(idZeichenUmsetzungReferenz);
								} else {
									tmpZeichenUmsetzungReferenz = factory.getModellobjekt(soZeichenUmsetzungReferenz);
								}
							}
								getZeichenUmsetzungReferenz().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.ZeichenUmsetzung
								) tmpZeichenUmsetzungReferenz);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayWvzInhaltUmsetzungReferenz = daten.getReferenceArray("WvzInhaltUmsetzungReferenz");
						for (int i = 0; i < arrayWvzInhaltUmsetzungReferenz.getLength(); ++i) {
							final long idWvzInhaltUmsetzungReferenz = daten.getReferenceArray("WvzInhaltUmsetzungReferenz").getReferenceValue(i).getId();
							final SystemObjekt tmpWvzInhaltUmsetzungReferenz;
							if (idWvzInhaltUmsetzungReferenz == 0) {
								tmpWvzInhaltUmsetzungReferenz = null;
							} else {
								final SystemObject soWvzInhaltUmsetzungReferenz = factory.getDav().getDataModel().getObject(idWvzInhaltUmsetzungReferenz);
								if (soWvzInhaltUmsetzungReferenz == null) {
										tmpWvzInhaltUmsetzungReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.impl.WvzInhaltUmsetzungUngueltig(idWvzInhaltUmsetzungReferenz);
								} else {
									tmpWvzInhaltUmsetzungReferenz = factory.getModellobjekt(soWvzInhaltUmsetzungReferenz);
								}
							}
								getWvzInhaltUmsetzungReferenz().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.WvzInhaltUmsetzung
								) tmpWvzInhaltUmsetzungReferenz);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._fontUmsetzungReferenz = getFontUmsetzungReferenz().clone();
						klon._textAusrichtungUmsetzungReferenz = getTextAusrichtungUmsetzungReferenz().clone();
						klon._zeichenUmsetzungReferenz = getZeichenUmsetzungReferenz().clone();
						klon._wvzInhaltUmsetzungReferenz = getWvzInhaltUmsetzungReferenz().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.anzeigeTypUmsetzung";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdAnzeigeTypUmsetzung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
