/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class KdDirigentAktor extends AbstractKonfigurationsDatensatz<KdDirigentAktor.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Dirigent
				 _dirigentReferenz
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.DirigentUmsetzung
				 _dirigentUmsetzungReferenz
				;
		
			/**
			Referenz auf ein Objekt vom Typ Dirigent zur Umsetzung der Befehle und Rückmeldungen zu und von der externen Kommunikation.
			<p>
			
			</p>
			
			@return der Wert von DirigentReferenz.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Dirigent
				 getDirigentReferenz() {
				return _dirigentReferenz;
			}
		
			/**
			Referenz auf ein Objekt vom Typ Dirigent zur Umsetzung der Befehle und Rückmeldungen zu und von der externen Kommunikation.
			<p>
			
			</p>
			
			@param _dirigentReferenz der neue Wert von DirigentReferenz.
			*/
			public void setDirigentReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Dirigent
			 _dirigentReferenz) {
				this._dirigentReferenz = _dirigentReferenz;
			}
		
			/**
			Referenz auf ein Objekt vom Typ DirigentUmsetzung zur Umsetzung der Befehle und Rückmeldungen zu und von der externen Kommunikation.
			<p>
			
			</p>
			
			@return der Wert von DirigentUmsetzungReferenz.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.DirigentUmsetzung
				 getDirigentUmsetzungReferenz() {
				return _dirigentUmsetzungReferenz;
			}
		
			/**
			Referenz auf ein Objekt vom Typ DirigentUmsetzung zur Umsetzung der Befehle und Rückmeldungen zu und von der externen Kommunikation.
			<p>
			
			</p>
			
			@param _dirigentUmsetzungReferenz der neue Wert von DirigentUmsetzungReferenz.
			*/
			public void setDirigentUmsetzungReferenz(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.DirigentUmsetzung
			 _dirigentUmsetzungReferenz) {
				this._dirigentUmsetzungReferenz = _dirigentUmsetzungReferenz;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soDirigentReferenz = getDirigentReferenz();
						final SystemObject tmpDirigentReferenz;
							if (soDirigentReferenz instanceof SystemObject) {
								tmpDirigentReferenz = (SystemObject)soDirigentReferenz;
							} else if(soDirigentReferenz instanceof SystemObjekt){
								tmpDirigentReferenz = ((SystemObjekt)soDirigentReferenz).getSystemObject();
							} else{
								tmpDirigentReferenz = null;
							}
						datum.getReferenceValue("DirigentReferenz").setSystemObject(tmpDirigentReferenz);
					// ObjektReferenzAttributTyp
						final Object soDirigentUmsetzungReferenz = getDirigentUmsetzungReferenz();
						final SystemObject tmpDirigentUmsetzungReferenz;
							if (soDirigentUmsetzungReferenz instanceof SystemObject) {
								tmpDirigentUmsetzungReferenz = (SystemObject)soDirigentUmsetzungReferenz;
							} else if(soDirigentUmsetzungReferenz instanceof SystemObjekt){
								tmpDirigentUmsetzungReferenz = ((SystemObjekt)soDirigentUmsetzungReferenz).getSystemObject();
							} else{
								tmpDirigentUmsetzungReferenz = null;
							}
						datum.getReferenceValue("DirigentUmsetzungReferenz").setSystemObject(tmpDirigentUmsetzungReferenz);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idDirigentReferenz = daten.getReferenceValue("DirigentReferenz").getId();
						final SystemObjekt tmpDirigentReferenz;
						if (idDirigentReferenz == 0) {
							tmpDirigentReferenz = null;
						} else {
							final SystemObject soDirigentReferenz = factory.getDav().getDataModel().getObject(idDirigentReferenz);
							if (soDirigentReferenz == null) {
									tmpDirigentReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.DirigentUngueltig(idDirigentReferenz);
							} else {
								tmpDirigentReferenz = factory.getModellobjekt(soDirigentReferenz);
							}
						}
						setDirigentReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Dirigent
						) tmpDirigentReferenz);
					// ObjektReferenzAttributTyp
						final long idDirigentUmsetzungReferenz = daten.getReferenceValue("DirigentUmsetzungReferenz").getId();
						final SystemObjekt tmpDirigentUmsetzungReferenz;
						if (idDirigentUmsetzungReferenz == 0) {
							tmpDirigentUmsetzungReferenz = null;
						} else {
							final SystemObject soDirigentUmsetzungReferenz = factory.getDav().getDataModel().getObject(idDirigentUmsetzungReferenz);
							if (soDirigentUmsetzungReferenz == null) {
									tmpDirigentUmsetzungReferenz = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.impl.DirigentUmsetzungUngueltig(idDirigentUmsetzungReferenz);
							} else {
								tmpDirigentUmsetzungReferenz = factory.getModellobjekt(soDirigentUmsetzungReferenz);
							}
						}
						setDirigentUmsetzungReferenz((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschicht.objekte.DirigentUmsetzung
						) tmpDirigentUmsetzungReferenz);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setDirigentReferenz(getDirigentReferenz());
							klon.setDirigentUmsetzungReferenz(getDirigentUmsetzungReferenz());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.dirigentAktor";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdDirigentAktor(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
