/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class KdAnzeigeQuerschnittTypUmsetzungTls extends AbstractKonfigurationsDatensatz<KdAnzeigeQuerschnittTypUmsetzungTls.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
				> _umsetzungHelligkeit = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
				> _umsetzungBetriebsart = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
				> _umsetzungPassivierung = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
				>(0, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
				> _umsetzungSchaltung = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
				>(0, true);
		
			/**
			Eigenschaften der Objekte des Typs.
			<p>
			
			</p>
			
			@return der Wert von UmsetzungHelligkeit.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
				> getUmsetzungHelligkeit() {
				return _umsetzungHelligkeit;
			}
		
		
			/**
			Eigenschaften der Objekte des Typs.
			<p>
			
			</p>
			
			@return der Wert von UmsetzungBetriebsart.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
				> getUmsetzungBetriebsart() {
				return _umsetzungBetriebsart;
			}
		
		
			/**
			Eigenschaften der Objekte des Typs.
			<p>
			
			</p>
			
			@return der Wert von UmsetzungPassivierung.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
				> getUmsetzungPassivierung() {
				return _umsetzungPassivierung;
			}
		
		
			/**
			Eigenschaften der Objekte des Typs.
			<p>
			
			</p>
			
			@return der Wert von UmsetzungSchaltung.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
				> getUmsetzungSchaltung() {
				return _umsetzungSchaltung;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						final Data.Array arrayUmsetzungHelligkeit = datum.getArray("UmsetzungHelligkeit");
						arrayUmsetzungHelligkeit.setLength(getUmsetzungHelligkeit().size());
						for (int i = 0; i < arrayUmsetzungHelligkeit.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
							 atl = getUmsetzungHelligkeit().get(i);
							atl.bean2Atl(arrayUmsetzungHelligkeit.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayUmsetzungBetriebsart = datum.getArray("UmsetzungBetriebsart");
						arrayUmsetzungBetriebsart.setLength(getUmsetzungBetriebsart().size());
						for (int i = 0; i < arrayUmsetzungBetriebsart.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
							 atl = getUmsetzungBetriebsart().get(i);
							atl.bean2Atl(arrayUmsetzungBetriebsart.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayUmsetzungPassivierung = datum.getArray("UmsetzungPassivierung");
						arrayUmsetzungPassivierung.setLength(getUmsetzungPassivierung().size());
						for (int i = 0; i < arrayUmsetzungPassivierung.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
							 atl = getUmsetzungPassivierung().get(i);
							atl.bean2Atl(arrayUmsetzungPassivierung.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayUmsetzungSchaltung = datum.getArray("UmsetzungSchaltung");
						arrayUmsetzungSchaltung.setLength(getUmsetzungSchaltung().size());
						for (int i = 0; i < arrayUmsetzungSchaltung.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
							 atl = getUmsetzungSchaltung().get(i);
							atl.bean2Atl(arrayUmsetzungSchaltung.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						final Data.Array arrayUmsetzungHelligkeit = daten.getArray("UmsetzungHelligkeit");
						for (int i = 0; i < arrayUmsetzungHelligkeit.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
							 ();
							atl.atl2Bean(arrayUmsetzungHelligkeit.getItem(i), factory);
							getUmsetzungHelligkeit().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayUmsetzungBetriebsart = daten.getArray("UmsetzungBetriebsart");
						for (int i = 0; i < arrayUmsetzungBetriebsart.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
							 ();
							atl.atl2Bean(arrayUmsetzungBetriebsart.getItem(i), factory);
							getUmsetzungBetriebsart().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayUmsetzungPassivierung = daten.getArray("UmsetzungPassivierung");
						for (int i = 0; i < arrayUmsetzungPassivierung.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
							 ();
							atl.atl2Bean(arrayUmsetzungPassivierung.getItem(i), factory);
							getUmsetzungPassivierung().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayUmsetzungSchaltung = daten.getArray("UmsetzungSchaltung");
						for (int i = 0; i < arrayUmsetzungSchaltung.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobalzwischenschichttls.attribute.AtlAnzeigenGlobalUmsetzung
							 ();
							atl.atl2Bean(arrayUmsetzungSchaltung.getItem(i), factory);
							getUmsetzungSchaltung().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._umsetzungHelligkeit = getUmsetzungHelligkeit().clone();
						klon._umsetzungBetriebsart = getUmsetzungBetriebsart().clone();
						klon._umsetzungPassivierung = getUmsetzungPassivierung().clone();
						klon._umsetzungSchaltung = getUmsetzungSchaltung().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.anzeigeQuerschnittTypUmsetzungTls";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdAnzeigeQuerschnittTypUmsetzungTls(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
