/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
LED-Anzeige SWARCO (H-BS-SZ) mit Fehler-Bitmap.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface AnzeigeSwarco extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.anzeigeSwarco"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
/**
Menge der Fahrstreifen, die einen Messquerschnitt bilden.
<p>

</p>

@return die Menge FahrStreifen oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.FahrStreifen> getFahrStreifen();


	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Diese Attributgruppe enhält die Fehler-Bitmap der SWARCO-LED-Anzeige.
	<p>
	&lt;absatz&gt;Das LED-Test Ergebnis wird im 24bit per Pixel Windows Bitmapformat (Version 3) zur Verfügung gestellt. 
						Dies gilt sowohl für monochrome Anzeigen als auch für RGB Anzeigen.&lt;&#47;absatz&gt;
						  
						&lt;absatz&gt;Die Abmessungen des Bitmaps entsprechen genau der Größe der Anzeigefläche. Der Inhalt des
						Bitmaps repräsentiert die Anzeige von vorne. Jeder Pixel entspricht dem korrespondierenden
					    Lichtpunkt der Anzeige.&lt;&#47;absatz&gt;
						  
						&lt;absatz&gt;Liegt keine Störung des Lichtpunkts vor wird diese durch einen weißen Pixel (R=255, G=255,
						B=255) repräsentiert.&lt;&#47;absatz&gt;
						&lt;absatz&gt;Bei monochromen Anzeigen wird ein defekter Lichtpunkt durch einen schwarzen Pixel (R=0,
						G=0, B=0) signalisiert.&lt;&#47;absatz&gt;
						&lt;absatz&gt;Bei RGB Anzeigen wird jede Leuchtdiode eines Lichtpunkts getrennt überwacht. Bei einer Störung 
						einer LED wird die entsprechende Farbe im Pixel geschwärzt. Die folgende Tabelle gibt
						hierzu einen Überblick.&lt;&#47;absatz&gt;
						  
						&lt;tabelle ausrichtung="m" rahmen="1" transponiert="n"&gt;
							&lt;kopf&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;Typ Anzeige&lt;&#47;zelle&gt;
									&lt;zelle&gt;Defekte LED&lt;&#47;zelle&gt;
									&lt;zelle&gt;R&lt;&#47;zelle&gt;
									&lt;zelle&gt;G&lt;&#47;zelle&gt;
									&lt;zelle&gt;B&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
							&lt;&#47;kopf&gt;
							&lt;rumpf&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;Monochrom&lt;&#47;zelle&gt;
									&lt;zelle&gt;Weiß&lt;&#47;zelle&gt;
									&lt;zelle&gt;0&lt;&#47;zelle&gt;
									&lt;zelle&gt;0&lt;&#47;zelle&gt;
									&lt;zelle&gt;0&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;RGB&lt;&#47;zelle&gt;
									&lt;zelle&gt;Rot&lt;&#47;zelle&gt;
									&lt;zelle&gt;0&lt;&#47;zelle&gt;
									&lt;zelle&gt;255&lt;&#47;zelle&gt;
									&lt;zelle&gt;255&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;RGB&lt;&#47;zelle&gt;
									&lt;zelle&gt;Grün&lt;&#47;zelle&gt;
									&lt;zelle&gt;255&lt;&#47;zelle&gt;
									&lt;zelle&gt;0&lt;&#47;zelle&gt;
									&lt;zelle&gt;255&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								&lt;zeile&gt;
									&lt;zelle&gt;RGB&lt;&#47;zelle&gt;
									&lt;zelle&gt;Blau&lt;&#47;zelle&gt;
									&lt;zelle&gt;255&lt;&#47;zelle&gt;
									&lt;zelle&gt;255&lt;&#47;zelle&gt;
									&lt;zelle&gt;0&lt;&#47;zelle&gt;
								&lt;&#47;zeile&gt;
								
							&lt;&#47;rumpf&gt;
						&lt;&#47;tabelle&gt;					  
		
						&lt;absatz&gt;Bei mehreren defekten LEDs eines Lichtpunkts ist die Kombination der oben angeführten Werte
						möglich.&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz LedFehlerBitmapSwarco.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.onlinedaten.OdLedFehlerBitmapSwarco getOdLedFehlerBitmapSwarco();
	
	/**
	Rückmeldungsseitiger Autark Anzeige-Inhalt einer Anzeige.
	<p>
	
	</p>
	@return der Datensatz AnzeigeAutarkIst.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdAnzeigeAutarkIst getOdAnzeigeAutarkIst();
	
	/**
	Befehlsseitiger Autark Anzeige-Inhalt einer Anzeige.
	<p>
	
	</p>
	@return der Datensatz AnzeigeAutarkSoll.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdAnzeigeAutarkSoll getOdAnzeigeAutarkSoll();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Ist Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz AnzeigeEigenschaftIst.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdAnzeigeEigenschaftIst getOdAnzeigeEigenschaftIst();
	
	/**
	Soll Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz AnzeigeEigenschaftSoll.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.onlinedaten.OdAnzeigeEigenschaftSoll getOdAnzeigeEigenschaftSoll();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Bedeutung der Anzeige für Copy und Paste.
	<p>
	Die angegebene Bezeichnung wird für die Copy-Paste-Funktionalität verwendet.
						  D. h. bei Copy wird der Inhalt der Anzeige unter der BedeutungCopyPaste zwischengespeichert,
	            beim Paste werden die zwischengespeicherten Inhalte über die BedeutungCopyPaste den Anzeigen, die die gespeicherten Inhalte erhalten sollen, zugeordnet.
	            Durch sinnvolle Versorgung kann damit eine sinnvolle Zuordnung der verkehrlichen Bedeutungen erfolgen.
	</p>
	@return der Datensatz AnzeigeBedeutungCopyPaste.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten.KdAnzeigeBedeutungCopyPaste getKdAnzeigeBedeutungCopyPaste();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz Anzeige.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.konfigurationsdaten.KdAnzeige getKdAnzeige();
	
	/**
	Diese Attributgruppe enhält die Anzahl der defekten LED.
	<p>
	&lt;absatz&gt;Dei Daten werden gemeldet über das herstellerspezifische TLS-Telegramm FG4, Typ 143.&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz AnzahlDefekteLED.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.onlinedaten.OdAnzahlDefekteLED getOdAnzahlDefekteLED();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
