/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
WzgSymbol-DE - SWARCO (H-BS-SZ).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface DeWzgSymbolSwarco extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.DeWzg
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.deWzgSymbolSwarco"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Defekte LED-Ketten (FG 4 &#47; Typ 5).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ 5 "Defekte LED-Ketten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 1 (Fehler) in Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Nachricht meldet den Status von LED-Ketten
								in Wechselzeichengebern bzw. Wechselwegweisern
								und Wechseltextanzeigen nach Anzeigeprinzip b).
								Sie informiert die Unterzentrale über den Defekt
								und nach der Behebung über die Funktionsfähigkeit
								einzelner LED-Ketten. Die interne Zählweise der
								Ketten ist nicht genormt, sie ist den Herstellern
								überlassen. Um Übertragungskapazität zu sparen
								werden nicht immer alle Ketten übertragen sondern
								immer nur alle Ketten von der ersten Kette bis zur
								letzten defekten Kette. Wenn keine defekte Kette
								vorliegt werden auch keine Ketten übertragen.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Zusätzlich wird noch eine Information zur Schwere
								des Ausfalls geliefert, um die Notwendigkeit und
								den Zeitrahmen für einen Serviceeinsatz abschätzen
								zu können.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese Fehlermeldung informiert über den Ausfall bzw.
								die Wiedereinsatzfähigkeit einzelner Ketten und die
								Schwere des Ausfalls, sie trifft dabei keine direkte
								Aussage über "Nicht darstellbare WVZ" (ID 1, Typ 2).
								Diese werden, falls möglich und projektiert, bei
								Änderung zusätzlich spontan übertragen. Ein sich
								evtl. aus dem Ausfall ergebender geänderter
								Stellzustand &#47; Wechseltext wird ebenfalls getrennt
								als eine eigene Nachricht (mit ID 5, Typ 55) übertragen.
								Die Meldung wird nicht gepuffert und wird daher mit
								Zeitstempel Typ 30 verwendet.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								In der Unterzentrale kann über die Nummer der LED-Kette
								die Zuordnung zum gestörten Anzeigeelement (Ronde, Dreieck,
								Ziffer, Symbol etc.) erfolgen.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgDefekteLEDKetten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsWzgDefekteLEDKetten getOdTlsWzgDefekteLEDKetten();
	
	/**
	Legt fest, ob entsprechend implementierte Umsetzungsscripte Betriebsmeldungen erzeugen und
						versenden.
	<p>
	
	</p>
	@return der Datensatz TlsBetriebsMeldungErzeugen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsBetriebsMeldungErzeugen getPdTlsBetriebsMeldungErzeugen();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Nicht darstellbare WVZ (FG 4 &#47; Typ 2).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ 2"Nicht
								darstellbare WVZ"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 1 (Fehler) oder mit ID
								33 (Fehlermeldung aus Puffer) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Nachricht meldet den Status von nicht
								darstellbaren WVZ-Codes eines
								Wechselzeichengebers nach Anzeigeprinzip b).
								Die Nachricht enthält eine Liste der
								WVZ-Codes, welche nun nicht mehr darstellbar
								sind.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Im Gegensatz zur Meldung"Defekte Lampen" (ID
								1, Typ 3), welche für den Einsatz von
								Servicepersonal notwendig ist, informiert
								diese Fehlermeldung den steuernden Prozess
								in der Zentrale, damit dieser den
								augenblicklichen Funktionsumfang seiner
								Betriebsmittel kennt.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Ein sich evt. aus dem Ausfall ergebender
								geänderter Stellzustand wird getrennt als
								eine eigene Nachricht übertragen (mit ID 5,
								Typ 55 (bei Altanlagen evtl. Typ 48)). Bei
								allen Änderungen (Behebung, Ausfall weiterer
								Zeichen) erfolgt eine erneute Meldung. Nach
								Behebung aller Störungen erfolgt eine
								Gutmeldung mit Anzahl Code-Bytes = 0. Die
								spontane Meldung wird gepuffert und erfolgt
								zusammen mit dem Zeitstempel mit Folgenummer
								(Typ 31).
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgNichtDarstellbareWVZ.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsWzgNichtDarstellbareWVZ getOdTlsWzgNichtDarstellbareWVZ();
	
	/**
	Defekte Lampen (FG 4 &#47; Typ 3).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ 3"Defekte
								Lampen"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 1 (Fehler) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Nachricht meldet den Status von Lampen
								in Wechselzeichengebern bzw.
								Wechselwegweisern und Wechseltextanzeigen
								nach Anzeigeprinzip b) oder d). Sie
								informiert die Zentrale über den Defekt und
								nach Behebung über die Funktionsfähigkeit
								von einzelnen Lampen. Die interne Zählweise
								der Lampen ist nicht genormt, sie ist den
								Herstellern überlassen. Die Anzahl der
								Lampenstatusbytes ergibt sich aus der
								aufgerundeten Anzahl der Lampenpaare
								dividiert durch 4.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Im Gegensatz zur Meldung"Nicht darstellbare
								WVZ" (ID 1, Typ 2) informiert diese
								Fehlermeldung getrennt über den Ausfall bzw.
								Wiedereinsatzfähigkeit einzelner Lampen, sie
								trifft keine Aussage über darstellbare WVZ
								oder ungestörte Textpositionen. Ein sich
								evtl. aus dem Ausfall ergebender geänderter
								Stellzustand&#47;Wechseltext wird getrennt als
								eine eigene Nachricht übertragen (mit ID 5,
								Typ 55 (bei Altanlagen evtl. Typ 48&#47;50)).
								Die Meldung wird nicht gepuffert.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgDefekteLampen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsWzgDefekteLampen getOdTlsWzgDefekteLampen();
	
	/**
	Gestörte Textpositionen (FG 4 &#47; Typ 4).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ 4"Gestörte
								Textpositionen"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 1 (Fehler) oder mit ID
								33 (Fehlermeldung aus Puffer) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Nachricht meldet den Status von
								einzelnen Textpositionen einer
								Wechseltextanzeige bei Wechselzeichengebern
								bzw. Wechselwegweisern nach Anzeigeprinzip c
								oder d. Sie informiert die Zentrale über die
								Störung und Behebung von allen Positionen.
								Die interne Zählweise der Positionen erfolgt
								in Leserichtung zeilenweise von oben links
								nach unten rechts. Bei allen Änderungen
								(Behebung, Ausfall weiterer Positionen)
								erfolgt eine erneute Meldung aller gestörten
								Positionen. Nach Behebung aller Störungen
								erfolgt eine Gutmeldung mit Anzahl
								ausgefallener Textpositionen = 0. Ein sich
								evtl. aus dem Ausfall ergebender geänderter
								Wechseltext-Zustand wird getrennt als eigene
								Nachricht übertragen (mit ID 5, Typ 55 (bei
								Altanlagen evtl. Typ 50)) Die spontane
								Meldung wird gepuffert und erfolgt zusammen
								mit dem Zeitstempel mit Folgenummer (Typ
								31).
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgGestoerteTextPositionen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsWzgGestoerteTextPositionen getOdTlsWzgGestoerteTextPositionen();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz De.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDe getKdDe();
	
	/**
	Ergänzende DE-Fehlermeldung (FG 4 &#47; Typ 14).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ 14"Ergänzende
								DE-Fehlermeldung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 1 (Fehler) oder mit ID
								33 (Fehlermeldungen aus Puffer) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Dieser DE-Block dient zur Meldung von
								Teilstörungen und näheren Erläuterung von
								Störungen, die mit dem DEBlock Typ 1
								gemeldet werden. Bei reinen Teilstörungen
								wird nur der DE-Block 14 gesendet; bei
								Erläuterungen von spontanen
								Störungsmeldungen wird er in einem Telegramm
								mit dem DE-Block Typ 1 gesendet. Er kann
								aber mit der ID 17 in Abrufrichtung einzeln
								abgerufen werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Mit dem DE-Block können unterschiedliche
								Störungen&#47;Teilstörungen gleichzeitig
								gemeldet werden. Ändert sich der Status
								(weitere Störungen&#47;Teilstörung bzw. Behebung
								von Störungen&#47;Teilstörungen) wird ebenfalls
								DE-Block-Typ 14 gesendet. Die spontane
								Meldung wird gepuffert und erfolgt zusammen
								mit dem Zeitstempel (Typ 31).
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgErgaenzendeDeFehlerMeldung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsWzgErgaenzendeDeFehlerMeldung getOdTlsWzgErgaenzendeDeFehlerMeldung();
	
	/**
	Kanalsteuerung (FG alle &#47; Typ 29).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ
								29"Kanalsteuerung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 2 (Statusnachrichten)
								in Abruf- und Antwortrichtung oder mit ID 34
								(Statusnachricht aus Puffer) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Der DE-Block"Kanalsteuerung" beeinflusst die
								Betriebsweise eines DEs. Bisher sind nur die
								beiden Betriebsweisen"Normalbetrieb"
								und"Passiv" vorgesehen. Über die
								Betriebsweise"Passiv" ist das Passivieren
								eines Kanals möglich.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Funktion ist grundsätzlich für alle DEs
								vorgesehen, mit Ausnahme der Systemkanäle
								(FG 254). Sie dient insbesondere zum
								Abschalten von Kanälen, die Flattermeldungen
								produzieren oder aufgrund von Baustellen
								etc. nicht verwendet werden. Der
								Zustand"Passiv" muss spannungsausfallsicher
								abgelegt sein. Reaktionen eines passivierten
								Kanals (
								&lt;verweis pid="KanalsteuerungFG4" txt="Spezielles Verhalten in der FG4"&gt;&lt;&#47;verweis&gt;
	
								):
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- spontan entstehende DE-Fehlermeldung (Typ
								1): keine Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- DE-Fehlermeldung (Typ 1) im
								Initialisierungsablauf normale Meldung
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Abfrage DE-Fehlermeldungen (Typ 1):
								normale Antwort
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Fehlermeldung im Initialisierungsablauf
								(außer Typ 1) keine Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- spontan entstehende Fehlermeldung keine
								Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Abfrage Fehlermeldungen (außer Typ 1)
								keine Reaktion1
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- spontan entstehende Anwenderdaten keine
								Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Anwenderdaten im Initialisierungsablauf 2
								keine Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Abfrage Anwenderdaten keine Reaktion1
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Befehle Anwenderdaten2 keine Antwort,
								keine Ausführung3
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Statusnachricht Kanalsteuerung normale
								Antwort und Ausführung
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Zuweisung und Abfrage Parameterdaten
								normale Antwort und Ausführung
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Einstellung des Kanalsteuerbytes erfolgt
								mit einem Kanalsteuerbefehl (ID 2, Typ 29),
								der mit Rückmeldung (ID 2, Typ 29)
								beantwortet wird. Die Meldung kann auch mit
								ID 18, Typ 29 abgefragt werden. Um die
								relevanten Kanalinformationen an einer
								Stelle zur Verfügung zu haben, wird das
								Passivierungsbit zusätzlich in der
								DE-Fehlermeldung übertragen.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								&lt;wichtig&gt;
									&lt;anker pid="KanalsteuerungFG4"&gt;&lt;&#47;anker&gt;
	
									Spezielles Verhalten in der FG4
								&lt;&#47;wichtig&gt;
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Verhalten beim Passivieren von DEs in der FG
								4:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Der Wzg&#47;WWW wird ausgeschaltet oder das
								Rollo geschlossen. Bei Wzgs&#47;WWWs mit
								Prismentechnik wird, falls vorhanden, die
								Neutralstellung eingestellt. Die
								Stellzustandsänderung wird spontan zur UZ
								gesendet.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Verhalten von passivierten DEs in der FG 4:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								1. An passivierte DEs wird im Autarkbetrieb
								keine Grundeinstellung ausgegeben, d.h. sie
								bleiben im Zustand"Aus" oder"Rollo
								geschlossen".
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								2. Befehle an passivierte Kanäle werden
								ausgeführt. Dadurch sind passive DEs
								schaltbar.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								3. Passivierte DEs senden immer ihre
								spontanen Meldungen, unabhängig vom
								Identifier und auch während der
								Initialisierung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Somit ist das Verhalten passiver und aktiver
								Kanäle - außer im Autarkbetrieb - gleich.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Verhalten beim Aktivieren von passivierten
								DEs in der FG 4:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Beim Aktivieren wird der Stellzustand des
								zugehörigen Wzgs&#47;WWWs vom EAK nicht
								verändert. Im Falle"Kommunikationsstatus
								lebt" werden DE-Fehlermeldung (Typ 1, ID 1)
								und bei"DE ok" abhängig von der Technologie
								der Zeichen nicht darstellbare WVZ (ID 1,
								Typ 2), defekte Lampen (ID 1, Typ 3) oder
								gestörte Textpositionen (ID 1, Typ 4) und
								der Stellzustand (ID 5, Typ 55, bei
								Altanlagen auch 48,50,58) gesendet. Im
								Falle"Kommunikationsstatus tot" wird die
								Grundeinstellung ausgegeben.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Ansonsten gilt entsprechend die Definition
								in Anhang 6, Teil 2, Kapitel 3.2.5.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsGloKanalSteuerung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsGloKanalSteuerung getPdTlsGloKanalSteuerung();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz DeWzg.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDeWzg getKdDeWzg();
	
	/**
	Abruf Pufferinhalt (FG 4 &#47; Typ 20).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ 20"Abruf
								Pufferinhalt"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Die Nachricht wird verwendet mit ID 2
								(Statusnachrichten) in Abrufrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Nachricht ist nur für den Fehlerfall
								notwendig, dass spontane Nachrichten oder
								Rückmeldungen der WVZSteuerung nicht in der
								archivierenden Zentrale angekommen sind.
								Anhand der Folgenummer im Zeitstempel (Typ
								31) kann die Zentrale eine Lücke in der
								Übertragung erkennen. Mit dieser
								Nachricht"Abruf Pufferinhalt" kann die
								Zentrale die fehlenden Nachrichten aus dem
								Puffer des Quell-EAKs nachfordern,
								vorausgesetzt sie sind noch nicht durch
								neuere Nachrichten überschrieben worden. Das
								Abrufen des Pufferinhaltes bewirkt kein
								Löschen des Puffers und kann wahlfrei (evtl.
								auch mehrmals) anhand der Folgenummer
								geschehen.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Wenn mindestens eine der angeforderten
								Nachrichten gesendet werden kann, geschieht
								dies. Erst wenn keine der angeforderten
								Nachrichten im Puffer vorhanden ist, muss
								eine negative Quittung (Typ 16) gesendet
								werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Antworten auf diesen Abruf sind
								Nachrichten aus dem Puffer mit FG 4, ID
								33..37 und tragen die Jobnummer des Abrufs.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgAbrufPufferInhalt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsWzgAbrufPufferInhalt getOdTlsWzgAbrufPufferInhalt();
	
	/**
	Abruf Codedefinitionen (FG 4 &#47; Typ 21).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ 21"Abruf
								Codedefinition"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abrufrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Mit dieser Nachricht kann die Zentrale die
								Definitionen der vor Ort abgelegten
								Stellcodes für die Gruppen- Stellzustände
								(Anzeigeprinzip e), Wechseltextanzeigen
								(Anzeigeprinzip c und d) oder Programme
								(Cluster) anfordern. Für Wzg nach
								Anzeigeprinzip b) kann optional die Liste
								der an der Darstellung eines WVZ-Codes
								beteiligten Lampen abgefragt werden. Ist
								diese Eigenschaft nicht implementiert,
								antwortet das DE mit der negativen Quittung
								Code 2 ?unbekannter oder nicht auswertbarer
								Typ?.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Arbeitet ein DE oder ein Cluster nach
								Steuerprinzip 1), so beantwortet er die
								Anfrage mit einer negativen Quittung, Code
								4. Das gleiche gilt bei Steuerungsprinzip 2
								und 3, wenn die Definition eines nicht
								definierten Stellcodes abgefragt wird.
								Ansonsten antwortet das DE mit einem
								DE-Block Typ 44.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgAbrufCodeDefinitionen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsWzgAbrufCodeDefinitionen getOdTlsWzgAbrufCodeDefinitionen();
	
	/**
	Abfragetelegramm für einen DE-Block.
	<p>
	
	</p>
	@return der Datensatz TlsGloDeBlockAbruf.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockAbruf getOdTlsGloDeBlockAbruf();
	
	/**
	Betriebsart (FG 4 &#47; Typ 17).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ
								17"Betriebsart"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 2 (Statusnachrichten)
								in Abruf- und Antwortrichtung oder mit ID 34
								(Statusnachricht aus Puffer) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Nachricht überträgt die Betriebsart der
								Wzg&#47;WWW-Steuerung. Die Betriebsart wird nur
								für alle Wzgs&#47;WWWs eines EAK verändert. Die
								Nachricht wird daher an&#47;von einem
								Clusterkanal gesendet und von diesem
								spannungsausfallsicher abgelegt. Nach
								erfolgter Zuweisung oder spontan wird die
								Meldung der Betriebsart in Antwortrichtung
								zusammen mit dem DE-Block"Zeitstempel mit
								Folgenummer" (Typ 31) gesendet, um in der
								Zentrale die Betriebsart mit genauen
								Wechselzeitpunkten dokumentieren zu können.
								Die Betriebsarten sind wie folgt definiert:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;1) Normalbetrieb&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Standardfall, wenn keine Störung oder
								Servicefall vorliegt. Die Steuerung erfolgt
								durch die Zentrale (i.d.R. UZ).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;2) Blindbetrieb&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								In der Blindbetriebsart wird durch eine
								Blende, einen Rollo, etc., verhindert, dass
								der Verkehrsteilnehmer die WVZs erkennen
								kann. Die Steuerung verhält sich ansonsten
								wie im Normalbetrieb, das Schalten der WVZs
								ist weiterhin möglich. Vom Blindbetrieb
								erfolgt kein automatischer Übergang in den
								autarken Betrieb bei Kommunikationsstörung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Ist es z.B. bei WWWs mit Prismentechnik
								nicht möglich, die Schilder für den
								Verkehrsteilnehmer nicht erkennbar zu
								machen, so ist die anzuzeigende Prismenseite
								dieser Komponenten in der Betriebsart
								Blindbetrieb vom Auftraggeber explizit
								festzulegen (Festlegung in Anhang 9).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;3) Handbetrieb&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Der Handbetrieb ist dadurch gekennzeichnet,
								dass der Zugriff nicht von der Zentrale,
								sondern nur von einem lokalen Bedienfeld
								möglich ist. Die Zentrale erhält weiterhin
								alle Meldungen und kann diese auch abfragen.
								Alle aktiv ändernden Telegramme werden
								jedoch zurückgewiesen (Stellzustand bzw.
								Programm, Helligkeit, Betriebsart und
								Wechseltext). Parametrierung und
								Kanalsteuerung können während des
								Handbetriebs weiterhin durch die Zentrale
								vorgenommen werden. Der Handbetrieb kann nur
								durch manuelle Eingabe vor Ort aktiviert und
								wieder beendet werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Passivierte DE können im Handbetrieb manuell
								geschaltet werden. Erst nach Beenden des
								Handbetriebs wird vom EAK die Passivierung
								an den entsprechenden Wzg&#47;WWW ausgeführt,
								d.h. sie werden ausgeschaltet oder das Rollo
								geschlossen oder ggf. bei Prismen die
								Neutralstellung eingestellt.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Nach Beenden des Handbetriebs bleibt die
								Anzeige so lange bestehen, bis ein neuer
								Stellzustand vom EAK empfangen wird oder in
								den autarken Betrieb geschaltet wird.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;4) Autarker Betrieb&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Autarker Betrieb bedeutet, dass die
								WVZ-Steuerung die Kontrolle über die
								Wzgs&#47;WWWs selbst übernimmt, sie kann z.B.
								selbsttätig ein für diesen Fall
								projektiertes WVZ bzw. Programm darstellen.
								Wenn sich die Steuerung im Normalbetrieb
								befindet und sie die Kommunikation mit der
								übergeordneten Steuerung als gestört erkennt
								(siehe Anhang 6, Teil 2, Kap. 2.2.6), dann
								wird der autarke Betrieb eingeschaltet. Die
								gesamte WVZ-Steuerung wechselt zurück in den
								Normalbetrieb, wenn ein Befehl (Typ 55, bei
								Altanlagen auch 48..50,58) empfangen wird.
								Die Betriebsart wechselt natürlich auch
								aufgrund eines anderslautenden
								Betriebsarten-Befehls.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Für Wechseltext-DEs muss mit dem
								Auftraggeber abgestimmt werden, ob in der
								Betriebsart ?Autarker Betrieb? die Anzeige
								ausgeschaltet werden soll oder der aktuelle
								Inhalt bestehen bleiben soll.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Der Autarkbetrieb kann auch explizit von
								oben eingestellt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;5) Testbetrieb&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Funktion der WVZ-Steuerung im
								Testbetrieb ist rein herstellerspezifisch
								definiert. Durch einen entsprechenden
								anderen Betriebsartenbefehl ist der
								Testbetrieb wieder zu verlassen. Die
								Betriebsart"Testbetrieb" ist optional.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								6) Notbetrieb (nur bei speziellen Anlagen
								erforderlich)
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Er kann, falls erforderlich, in Anlagen wie
								z.B. Knotenpunktsbeeinflussungsanlagen und
								Zuflusssteuerungen realisiert werden, bei
								denen auch bei Störungen aus
								Sicherheitsgründen eine Verkehrsregelung
								angezeigt werden muss. Er ist jedoch nicht
								für eine WWW oder
								Steckenbeeinflussungsanlage vorgesehen. Der
								Notbetrieb ist der sichere immer erfüllbare
								Zustand wie er z.B. durch Klapptafeln oder
								Rollos erreicht werden kann. I.d.R. wird der
								Notbetrieb nur eingeschaltet, wenn eine
								Hardwarestörung vorliegt, bei der auf einen
								zusätzlichen, vom autarken Betrieb
								unabhängigen Anlagenzustand zurückgegriffen
								werden können muss. Der Zustand im
								Notbetrieb ist im Gegensatz zu dem des
								autarken Betriebs nicht von der Zentrale aus
								parametrierbar. Die Betriebsart Notbetrieb
								ist nicht von der Zentrale oder von den
								Handbedienteilen einschaltbar, sondern wird
								durch Betätigung eines Notausschalters
								aktiviert.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgBetriebsArt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsWzgBetriebsArt getPdTlsWzgBetriebsArt();
	
	/**
	Ermöglich das Senden eines (beliegigen) DE-Blocks.
	<p>
	
	</p>
	@return der Datensatz TlsGloDeBlockSenden.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockSenden getOdTlsGloDeBlockSenden();
	
	/**
	Codeliste (FG 4 &#47; Typ 43).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ 43
								?Codeliste?
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Mit dieser Nachricht teilen DEs und
								Clusterkanäle nach Steuerprinzip 2 und 3 der
								Zentrale ihren derzeit aktuellen Vorrat an
								definierten Stellcodes mit. Für DEs nach
								Steuerungsprinzip 1 ist diese Nachricht
								nicht definiert und wird bei Abfrage mit ID
								19 dementsprechend mit Code 2 negativ
								quittiert. Die Bedeutung der Codes ab Byte 6
								hängt davon ab, ob es sich bei dem DE um
								einen Clusterkanal handelt, andernfalls vom
								Anzeigeprinzip des DEs. Jedes DE liefert
								dafür eine entsprechende Kennung im Feld
								?Anzeigeprinzip?.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgCodeListe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsWzgCodeListe getOdTlsWzgCodeListe();
	
	/**
	DE-Fehler (FG alle &#47; Typ 1).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG alle (ausser FG 254): DE-Block-Struktur
								im Typ 1"DE-Fehlermeldung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 1 (Fehler) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die DE-Fehlermeldung informiert die Zentrale
								über den Betriebszustand eines DE. Die
								Nachricht wird vom E&#47;AKonzentrator oder vom
								SM erzeugt. Es sind folgende zwei Fälle
								unterscheidbar:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								1.) Es sind ein oder mehrere Kanäle des
								E&#47;A-Konzentrators defekt, die Kommunikation
								des E&#47;A-Konzentrators ist jedoch noch
								funktionsfähig.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Folge: Bei Eintritt der Störung sendet der
								E&#47;A-Konzentrator eine Nachricht mit je einem
								DE-Block pro gestörtem Kanal und Fehlercode
								Bit 0 = 1. Auf Abfrage antworten
								betriebsbereite Kanäle mit Fehlercode Bit 0
								= 0, defekte Kanäle antworten mit Fehlercode
								Bit 0 = 1.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								2.) Der E&#47;A-Konzentrator ist so defekt, dass
								die Kommunikation zum SM nicht mehr
								funktioniert.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Folge: Der SM generiert bei Eintritt der
								Störung anhand seiner Konfigurationsliste je
								eine Nachricht pro FG des E&#47;AKonzentrators
								mit je einem DE-Block pro vorhandenem DE und
								Fehlercode Bit 1 = 1. Auf Abfrage antworten
								betriebsbereite Kanäle mit Fehlercode Bit
								0..2 = 0, defekte Kanäle antworten mit
								Fehlercode Bit 1 = 1.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Ist ein Fehler aufgetreten, der weiterhin
								einen eingeschränkten Betrieb der DE
								zulässt, so ist dieser Teilausfall nicht
								durch ein gesetztes Fehlercode-Bit 0 oder 1
								auszudrücken.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Vielmehr ist dieser Ausfall durch die
								ergänzende DE-Fehlermeldung Typ 14 der
								Zentrale mitzuteilen. Abrufe der
								Fehlermeldung reicht der SM an den
								E&#47;A-Konzentrator weiter, wenn dieser mit dem
								SM kommunizieren kann, andernfalls
								beantwortet sie der SM selbst.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Eine Kopie des Passiv-Bits, welches für
								jeden Kanal mit dem Kanalsteuerbefehl
								eingestellt werden kann, wird in der
								DE-Fehlermeldung mit übertragen. Dies
								erspart eine zusätzliche Abfrage bzw.
								Antwortnachricht des Kanalsteuerbytes, um
								den vollständigen Kanalzustand zu erfahren
								(Siehe auch Kapitel 3.2.5 Kanalsteuerung).
								Dieses Bit ist jedoch nur gültig, wenn die
								Fehlernachricht vom E&#47;A-Konzentrator erzeugt
								wird, jedoch nicht, wenn das Stö&#47;SM = 1 ist.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
						&lt;sektion&gt;
							&lt;titel&gt;
								FG 254: DE-Block-Struktur im Typ
								1"DE-Fehlermeldung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 1 (Fehler) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die DE-Fehlermeldung informiert die Zentrale
								über den Betriebszustand eines DE. Sie wird
								sowohl für die anwendungsbezogenen DEs als
								auch für die hardwarezugeordneten DEs (DE
								entspricht E&#47;A-Konzentrator unter FG 254)
								verwendet. Das Störungsereignis wird der
								Zentrale primär über die anwendungsbezogenen
								DE-Fehlermeldungen (FG 1..253) mitgeteilt.
								Die Nachricht wird vom E&#47;A-Konzentrator oder
								vom SM erzeugt. Es sind folgende zwei Fälle
								unterscheidbar:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								1.) Es sind Teile des E&#47;A-Konzentrators
								defekt, die Kommunikation zum SM ist jedoch
								noch funktionsfähig. Folge: Die
								Systemsteuerung des E&#47;A-Konzentrators sendet
								eine Nachricht mit ihrer DE-Nummer und
								Fehlercode Bit 0 = 1.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								2.) Der E&#47;A-Konzentrator ist so defekt, dass
								die Kommunikation zum SM nicht mehr
								funktioniert.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Folge: Der SM generiert eine Nachricht mit
								der DE des E&#47;A-Konzentrators und Fehlercode
								Bit 1 = 1. Abrufe der Fehlermeldung reicht
								der SM an den E&#47;A-Konzentrator weiter, wenn
								dieser mit dem SM kommunizieren kann,
								andernfalls beantwortet sie der SM selbst.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Weitergehende Informationen siehe [TLS2002].
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsGloDeFehler.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeFehler getOdTlsGloDeFehler();
	
	/**
	Legt fest, ob entsprechend implementierte Umsetzungsscripte der KExTLS ausgeführt werden
						oder nicht. Wird i.d.R. dazu verwendet, dass die Umsetzungscripte auf das logische Modell (FS,
						Umfelddaten) zu Testzwecken ausgeschaltet werden können.
	<p>
	
	</p>
	@return der Datensatz TlsPassivierungUebernahmeLogischesModell.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsPassivierungUebernahmeLogischesModell getPdTlsPassivierungUebernahmeLogischesModell();
	
	/**
	WVZ-Stellzustand (FG 4 &#47; Typ 48).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ
								48"WVZ-Stellzustand"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Die Nachricht wird für neue Anlagen nicht
								mehr verwendet. Sie wird ersetzt durch die
								allgemeine Nachricht ?Stellzustand? Typ 55.
								In Altanlagen kann die Nachricht jedoch von
								Wzgs, die nach Anzeigeprinzip a) oder b) im
								Steuerungsprinzip 2 arbeiten, aus
								Kompatibilitätsgründen weiterhin verwendet
								werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 5 (Befehl) in Abruf-
								und Antwortrichtung oder mit ID 37
								(Befehlsrückmeldung aus Puffer) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Bei einem Dirigenten ist ein Stellbefehl mit
								ID 5 in Abrufrichtung nicht möglich.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Bei spontaner Meldung des Stellzustands
								(z.B. bei Ausfall oder Abschaltung wegen
								Verstümmelung des WVZs) wird ebenfalls die
								ID 5 in Antwortrichtung verwendet.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Nachricht überträgt den WVZ-Code,
								welcher auf dem Wzg dargestellt wird, bzw.
								werden soll. Enthält das Funktionsbyte die
								Anweisung"ausschalten", so ist der WVZ-Code
								ohne Bedeutung. Nach erfolgter Zuweisung
								oder spontan wird die Meldung des
								Stellzustandes in Antwortrichtung mit dem
								DE-Block"Zeitstempel mit Folgenummer" (Typ
								31) zusammen gesendet, um in der Zentrale
								die dargestellten Zeichen mit genauen
								Wechselzeitpunkten dokumentieren zu können.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgWvzStellZustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsWzgWvzStellZustand getOdTlsWzgWvzStellZustand();
	
	/**
	Geographische Kenndaten (FG alle &#47; Typ 36).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 254: DE-Block-Struktur im Typ
								36"Geographische Kenndaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Meldung der geographischen Kenndaten
								dient dazu, die Lage der Streckenstation
								bzw. von Funktionsgruppen im Straßennetz
								durch Fernabruf überprüfbar zu machen. Dies
								kann insbesondere nach baulicher Änderung
								der Netzstruktur oder bei Inbetriebnahme von
								Zentralen hilfreich sein.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Dieses Datenfeld kann ein- oder mehrfach pro
								Streckenstation vorhanden sein. Es wird
								ausfallsicher gespeichert. Ist es nur einmal
								vorhanden, wird es über FG 254, DE 0 als
								Teil der Systemsteuerung im SM abgefragt.
								Dies ist der Standardfall. Optional kann das
								Datenfeld bei räumlich auseinanderliegenden
								Funktionsgruppen auch im EAK angelegt
								werden. Die Abfrage kann dann über einen
								beliebigen DE erfolgen. Eine weitere Option
								im EAK besteht darin, jedem DE ein
								unterschiedliches Datenfeld zuzuordnen, wenn
								dies für räumlich abgesetzte DEs
								erforderlich sein sollte.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die geographischen Kenndaten werden i.d.R.
								vor Ort eingegeben und von der Zentrale nur
								gelesen.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsGloGeographischeKenndaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloGeographischeKenndaten getOdTlsGloGeographischeKenndaten();
	
	/**
	SWARCO: Anzahl defekte LED (FG 4 &#47; Typ 143).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ
								143 "Anzahl defekte LED"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 2 (Statusnachrichten) in Abruf- und Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Nachricht meldet die Anzahl der gestörten LED pro Anzeige. Sie informiert die Zentrale über die Störung oder Behebung von LED-Fehlern.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Bei jeder Änderung der Anzahl erfolgt eine neue Meldung. Nach Behebung aller LED-Fehler erfolgt eine Gutmeldung mit der "Anzahl defekte LED = 0".
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Spontan wird das Telegramm mit einem Zeitstempel Typ 30 verschickt.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgAnzahlDefekteLED.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.onlinedaten.OdTlsWzgAnzahlDefekteLED getOdTlsWzgAnzahlDefekteLED();
	
	/**
	Helligkeit (FG 4 &#47; Typ 49).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ
								49"Helligkeit"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 5 (Befehl) in Abruf-
								und Antwortrichtung oder mit ID 37
								(Befehlsrückmeldung aus Puffer) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Nachricht überträgt einen
								Helligkeitswert für alle Wzg&#47;WWW eines EAKs.
								Die Nachricht wird daher an&#47;von einem
								Clusterkanal gesendet. Nach erfolgter
								Zuweisung oder spontan wird die Meldung des
								Helligkeitswertes in Antwortrichtung mit dem
								DE-Block"Zeitstempel mit Folgenummer" (Typ
								31) zusammen gesendet, um in der Zentrale
								die eingestellte Helligkeit mit genauen
								Änderungszeitpunkten dokumentieren zu
								können.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Eigenschaft"automatische
								Helligkeitssteuerung" ist optional. Wenn im
								autarken Betrieb lichttechnische
								Verkehrszeichen gezeigt werden, ist sie
								erforderlich.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgHelligkeit.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsWzgHelligkeit getOdTlsWzgHelligkeit();
	
	/**
	Wechseltext (FG 4 &#47; Typ 50).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ
								50"Wechseltext"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Die Nachricht wird für neue Anlagen nicht
								mehr verwendet. Sie wird ersetzt durch die
								verallgemeinerte Version der Nachricht
								?Stellzustand? Typ 55. In Altanlagen können
								Wzg nach Anzeigeprinzip c) oder d) im
								Steuerungsprinzip 1 und 3 die Nachricht aus
								Kompatibilitätsgründen noch verwenden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 5 (Befehl) in Abruf-
								und Antwortrichtung oder mit ID 37
								(Befehlsrückmeldung aus Puffer) in
								Antwortrichtung. Die Nachricht wird für
								Wzg&#47;WWW verwendet, die frei steuerbare
								Wechseltexte anzeigen können
								(Wechseltextanzeigen). Die Nachricht
								überträgt einen Text in ASCII-Code, welcher
								auf dem Wzg&#47;WWW dargestellt wird, bzw.
								werden soll. Enthält das Funktionsbyte die
								Anweisung"ausschalten", so ist der
								Textbereich ohne Bedeutung. In diesem Fall
								wird sinnvoller Weise die Anzahl Textzeichen
								= 0 übertragen.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Nach erfolgter Zuweisung oder spontan wird
								die Meldung des Wechseltextzustandes in
								Antwortrichtung mit dem DEBlock"Zeitstempel
								mit Folgenummer" (Typ 31) zusammen gesendet,
								um in der Zentrale die dargestellten Zeichen
								mit genauen Wechselzeitpunkten dokumentieren
								zu können.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Angabe der Textlänge ist unabhängig von
								der Anzahl der tatsächlich vorhandenen
								Textzeichen. Wenn eine geringere Anzahl
								Zeichen übergeben wird, wird der Rest
								ausgeschaltet. Wird eine größere Anzahl
								übergeben, wird der Befehl negativ
								quittiert.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Textzeichen 1..n werden in Leserichtung
								(von links nach rechts und zeilenweise und
								von oben nach unten) im DEBlock übertragen.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgWechselText.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsWzgWechselText getOdTlsWzgWechselText();
	
	/**
	Stellzustand (FG 4 &#47; Typ 55).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ
								55"Stellzustand"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 5 (Befehl) in Abruf-
								und Antwortrichtung oder mit ID 37
								(Befehlsrückmeldung aus Puffer) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Bei spontaner Meldung des Stellzustands
								(z.B. bei Ausfall oder Abschaltung wegen
								Verstümmelung des WVZs) wird ebenfalls die
								ID 5 in Antwortrichtung verwendet.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Nachricht überträgt in der Kurzversion
								den Stellcode, welcher auf dem Wzg
								dargestellt wird, bzw. werden soll.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								In der Langversion werden für Wzg nach
								Anzeigeprinzip c) ? e) die Einstellungen
								aller Komponenten (Textzeichen oder
								Anzeigen&#47;Prismen) individuell übertragen.
								Nach erfolgter Zuweisung oder spontan wird
								die Meldung des Stellzustandes in
								Antwortrichtung zusammen mit dem
								DE-Block"Zeitstempel mit Folgenummer" (Typ
								31) gesendet, um in der Zentrale die
								dargestellten Zeichen&#47;Programme mit genauen
								Wechselzeitpunkten dokumentieren zu können.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Das verallgemeinerte Telegramm existiert in
								zwei Versionen, einer Kurzversion der Länge
								5 und einer Langversion mit einer Länge
								größer 6, abhängig vom Anzeigeprinzip des
								adressierten DEs. Die Kurzversion wird
								verwendet, wenn das adressierte DE im
								Programmmodus gesteuert wird, ansonsten wird
								die Langversion verwendet. Felder der
								Langversion sind kursiv beschriftet.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgStellZustand.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsWzgStellZustand getOdTlsWzgStellZustand();
	
	/**
	Stellprogramm (FG 4 &#47; Typ 58).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block im Typ 58 ?Stellprogramm?
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Die Nachricht wird für neue Anlagen nicht
								mehr verwendet. Sie wird ersetzt durch die
								Kurzversion der verallgemeinerten Nachricht
								?Stellzustand? Typ 55. In Altanlagen können
								Wzg nach Anzeigeprinzip e) im
								Steuerungsprinzip 2 und 3 die Nachricht aus
								Kompatibilitätsgründen noch verwenden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 5 (Befehl) in Abruf-
								und Antwortrichtung mit ID 37
								(Befehlsrückmeldung aus Puffer) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Nachricht überträgt die Nummer des im
								EAK&#47;Dirigenten projektierten Programms,
								welches der EAK&#47;Dirigent eingestellt hat,
								bzw. einstellen soll. Das Stellprogramm kann
								je nach Anwendungsfall mit Clusterkanal
								(z.B. Dirigent KBA) oder mit normalem DE
								(z.B. WWW) adressiert werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Nach erfolgter Zuweisung oder spontan wird
								die Meldung des Programms in Antwortrichtung
								mit dem DE-Block"Zeitstempel mit
								Folgenummer" (Typ 31) zusammen gesendet, um
								in der Zentrale die dargestellten Programme
								mit genauen Wechselzeitpunkten dokumentieren
								zu können.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgStellProgramm.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsWzgStellProgramm getOdTlsWzgStellProgramm();
	
	/**
	Grundeinstellung (FG 4 &#47; Typ 33).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ
								33"Grundeinstellung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung. Die Nachricht
								wird abweichend von anderen
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Parameternachrichten zusammen mit dem
								Zeitstempel Typ 31 gesendet.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Nachricht überträgt die
								Grundeinstellung, welche auf dem Wzg bzw.
								dem AQ dargestellt werden soll, wenn die
								WVZ-Steuerung im autarken Betrieb ist.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Das verallgemeinerte Telegramm existiert in
								2 Versionen, einer Kurzversion der Länge 5
								und einer Langversion mit einer Länge größer
								6, abhängig vom Anzeigeprinzip des
								adressierten DEs. Die Kurzversion wird
								verwendet, wenn das adressierte DE im
								Programmmodus gesteuert wird, ansonsten wird
								die Langversion verwendet. Felder der
								Langversion sind kursiv beschriftet.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgGrundEinstellung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsWzgGrundEinstellung getPdTlsWzgGrundEinstellung();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Grundprogramm (FG 4 &#47; Typ 42).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block im Typ 42 ?Grundprogramm?
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Die Nachricht wird für neue Anlagen nicht
								mehr verwendet. Sie wird ersetzt durch den
								verallgemeinerten DE-Block Typ 33. In
								Altanlagen kann die Nachricht von
								Clusterkanälen und Anzeigen nach
								Anzeigeprinzip e), die nach
								Steuerungsprinzip 2 arbeiten, aus
								Kompatibilitätsgründen weiterhin verwendet
								werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung, .
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die optionale Nachricht überträgt die Nummer
								des Programms, das der EAK&#47;Dirigent im
								Autarkbetrieb einstellt. Das Grundprogramm
								kann je nach Anwendungsfall mit Clusterkanal
								(z.B. Dirigent einer KBA) oder mit normalem
								DE (z.B. WWW) adressiert werden.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgGrundProgramm.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsWzgGrundProgramm getPdTlsWzgGrundProgramm();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Enthält die Ermittlung der Fehlerursache in der TLS
						Kommunikation, die aufgrund von Messwertausfällen
						ermittelt wurden.
	<p>
	
	</p>
	@return der Datensatz TlsFehlerAnalyse.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsFehlerAnalyse getOdTlsFehlerAnalyse();
	
	/**
	Codedefinition (FG 4 &#47; Typ 44) (FG 4 &#47; Typ 44).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ 44
								?Codedefinition?
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Die Nachricht wird verwendet mit ID 3
								(Parameter) in Abruf- und Antwortrichtung.
								Die Nachricht wird abweichend von anderen
								Parameternachrichten zusammen mit dem
								Zeitstempel Typ 31 gesendet. Als
								Abruftelegramm mit ID 19 ist das Telegramm
								nicht zulässig und wird mit Code 1
								?unbekannte oder nicht auswertbare ID?
								negativ quittiert, da der zu erfragende
								Stellcode nicht übermittelt werden kann. Die
								Abfragefunktionalität wird durch den
								DE-Block Typ 21 zur Verfügung gestellt.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Nachricht überträgt für Wzgs und
								Clusterkanäle die vor Ort ausfallsicher
								abgelegten Definitionen der Stellcodes. Wenn
								ein EAK oder ein DE einen noch nicht in
								seiner Liste vorhandenen Stellcode empfängt
								und noch freier Speicher vorhanden ist, wird
								dieser Stellcode und seine Definition
								gespeichert. Ein Block, der keine
								Komponentendefinitionen enthält, sondern nur
								einen Stellcode, dient zum Löschen der
								Definition des entsprechenden Stellcodes aus
								dem Speicher. Diese Eigenschaften sind
								optional und führen bei Nichtimplementierung
								zu einer negativen Quittung mit Code 41
								?Stellcodevorrat nicht änderbar?. Ist der
								Stellcode bereits definiert, überschreibt
								die empfangene Nachricht die alte
								Definition. Auch diese Eigenschaft ist
								optional. Bei Nichtimplementierung wird in
								der negativen Quittung der Code 42
								?Stellcodedefinition nicht änderbar?
								verwendet.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Wird durch Neudefinition oder Löschen der
								Stellcodevorrat eines DEs oder EAKs
								verändert, so sendet dieser zusätzlich zur
								Rückmeldung der Definition spontan (d.h.
								insbesondere in einem separaten
								Einzeltelegramm) eine Nachricht vom Typ 43
								?Codeliste? mit dem neuen Stellcodevorrat.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgCodeDefinition.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsWzgCodeDefinition getPdTlsWzgCodeDefinition();
	
	/**
	Negative Quittung (FG 4 &#47; Typ 16).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ 16"Negative
								Quittung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 2 (Statusnachrichten)
								in Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Mit der"Negativen Quittung" antwortet ein DE
								auf eine Nachricht, die an sie korrekt
								adressiert ist, aber deren Inhalt von ihr
								nicht eindeutig ausgewertet werden kann.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Negative Quittung wird mit ID 2 und Typ
								16 gesendet, enthält also keinen Hinweis auf
								die ID und den Typ der verursachenden
								Nachricht. Diese Zuordnung wird über die
								Jobnummer hergestellt, welche identisch mit
								der der fehlerhaften Nachricht in
								Abrufrichtung ist.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgNegativeQuittung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsWzgNegativeQuittung getOdTlsWzgNegativeQuittung();
	
	/**
	WVZ-Grundeinstellung (FG 4 &#47; Typ 32).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ 32"WVZ -
								Grundeinstellung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Die Nachricht wird für neue Anlagen nicht
								mehr verwendet. Sie wird ersetzt durch den
								verallgemeinerten DE-Block Typ 33. In
								Altlagen kann die Nachricht bei Anzeigen
								nach Anzeigeprinzip b) aus
								Kompatibilitätsgründen weiterhin verwendet
								werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die optionale Nachricht überträgt den
								WVZ-Code, welcher auf dem Wzg dargestellt
								werden soll, wenn die WVZSteuerung im
								autarken Betrieb ist. Enthält das
								Funktionsbyte die Anweisung"ausschalten", so
								ist der WVZ-Code ohne Bedeutung.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgWvzGrundEinstellung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsWzgWvzGrundEinstellung getPdTlsWzgWvzGrundEinstellung();
	
	/**
	Stellzustand mit Fletcher-Checksumme (FG 4 &#47; Typ 183).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ
								183 "Stellzustand mit Fletcher Checksumme"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 5 (Befehl) in Abruf-
								und Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Mit diesem DE-Block kann ein Stellbefehl 
								in Kurzversion (analog zum TLS DE-Typ 55) 
								um eine Fletcher-Checksumme ergänzt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Der DE-Typ 183 ist ein modifizierter DE-Typ 
								55 "Stellzustand" und ist abweichend von der
								TLS-Vorgabe nur in der Kurzversion zu 
								verwenden und um eine 2-Byte Fletcher
								Checksumme ergänzt. Die Fletcher Checksumme 
								dient dazu, dass eine in der SST hinterlegte, 
								variable Anzeige im Zuge des Schaltbefehls 
								hinsichtlich ihres Inhaltes durch die 
								Unterzentrale (UZ) überprüft werden kann.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Schaltung durch die SST wird nur ausgeführt, 
								wenn die übermittelte Fletcher Checksumme mit der
								für den Stellbefehl hinterlegten Fletcher Checksumme
								des Anzeigeinhaltes übereinstimmt. Für den Fall, dass die 
								Fletcher Checksumme nicht übereinstimmt, bleibt die
								Anzeige unverändert und der Stellbefehl wird mit
								einer negativen Quittung (Ursache 43 - 
								"unzulässiger Stellcode") beantwortet. 
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgStellZustandMitFletcherChecksumme.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.onlinedaten.OdTlsWzgStellZustandMitFletcherChecksumme getOdTlsWzgStellZustandMitFletcherChecksumme();
	
	/**
	Koordinaten eines Punktes in Grad entsprechend WGS84.
	<p>
	
	</p>
	@return der Datensatz PunktKoordinaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten();
	
	/**
	Bilddefinition (FG 4 &#47; Typ 45).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ 45 "Bilddefinition&#47;Grafiktextkonserve"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional und wird verwendet
								mit ID 3 (Parameter) in Abruf- und Antwortrichtung oder
								mit ID 35 (Parameter aus Puffer) in Antwortrichtung.
								Die Nachricht wird abweichend von anderen Parameternachrichten
								zusammen mit dem Zeitstempel Typ 31 gesendet. Als
								Abruftelegramm mit ID 19 ist das Telegramm nicht zulässig
								und wird mit Code 1 "unbekannte oder nicht auswertbare ID"
								negativ quittiert, da der zu erfragende Stellcode bzw.
								Grafiktextkonservennummer nicht übermittelt werden kann.
								Die Abfragefunktionalität wird durch den DE-Block Typ 22
								zur Verfügung gestellt.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Bilddefinitionen bzw. Grafiktextkonserven werden in Form
								von BMP-Grafikdateien (s&#47;w bzw. c-24 Format) unter
								Zuhilfenahme der FG254, DE-Block Typ 40&#47;41 an den FG4-EAK
								gesendet und dort als Datei oder dateiähnliches gekapseltes
								Objekt zur Verfügung gestellt. Für farbige Anzeigen muss
								die BMP-Grafikdatei im c-24 Format (24 Bit Farbtiefe &#47; Pixel)
								hinterlegt sein. Für einfarbige Anzeigen muss die
								BMP-Grafikdatei im s&#47;w Format hinterlegt sein. Andere
								Unterformate sind nicht zulässig.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Der Dateiname der BMP-Grafikdatei muss im 8.3 Format angegeben
								werden (8 Zeichen für den Dateinamen und 3 Zeichen für die Extension "BMP").
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Mithilfe der DE-Block-Struktur im Typ 45 wird eine Verbindung
								zwischen Bilddefinition und Stellcode (Anzeigeprinzip b,
								upload-fähige LED-PixelrasterAnzeigen) bzw. Grafiktextkonserve
								und Grafik­text­konserven­nummer (Anzeigeprinzip d,
								Wechseltextanzeigen mit Grafiktextkonserven) hergestellt.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Sollte die in der Zuweisung aufgeführte Bilddefinition bzw.
								Grafiktextkonserve (BMP- Grafikdatei) nicht vorhanden sein,
								wird eine negative Quittung Code 23
								"unbekannte Bilddefinition&#47;Grafiktextkonserve" gesendet.
								Anderenfalls wird die Bilddefinition bzw. Grafiktextkonserve
								in das interne Format de DEs gewandelt, inhaltlich geprüft
								und bei Korrektheit mit der DE-Block-Struktur im Typ 45 positiv
								quittiert. Es ist hierbei zulässig, dass vom Gerät definierter
								neuer Bezeichner zurückgemeldet wird. Sollte ein Fehler bei der
								Prüfung bzw. Umwandlung der Bilddefinition bzw. Grafiktextkonserve
								auftreten, wird eine negative Quittung Code 24
								"fehlerhafte Bilddefinition&#47;Grafiktextkonserve" gesendet.
							&lt;&#47;absatz&gt;
	
							&lt;absatz&gt;
								Nach erfolgreicher Prüfung bzw. Umwandlung der Bilddefinition bzw.
								Grafiktextkonserve in das interne Format, muss die Original BMP-Grafikdatei
								gelöscht werden. Eine Zuweisung dieser Bilddefinition bzw.
								Grafiktextkonserve auf andere DEs (des gleichen Typs ?)
								im gleichen FG4-EAK muss aber weiterhin möglich sein, ohne erneutes
								Senden der BMP-Grafikdatei an die FG254 des FG4-EAKs. Auch ein evtl.
								Abruf mit DE-Block Typ 22, muss mit dem korrekten Namen der
								Original BMP- Grafikdatei beantwortet werden. Sollte im späteren Verlauf
								eine bereits verwendete BMP-Grafikdatei (gleicher Name), erneut an den
								FG4-EAK gesendet werden und anschließend eine Zuweisung erfolgen,
								ist diese nur zu akzeptieren, wenn im DE, bzw. in den anderen DEs
								des FG4-EAKs, kein anderer Stellcode bzw. Grafiktextkonservennummer
								die "alte" Bilddefinition bzw. Grafiktextkonserve noch verwendet.
								Sollte dies doch der Fall sein, so ist die erneute Zuweisung mit einer
								negativen Quittung Code 25
								"bereits verwendete Bilddefinition&#47;Grafiktextkonserve" zu beantworten.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Das Überschreiben bzw. Löschen einer vorhandenen Bilddefinition bzw.
								Grafiktextkonserve ist erlaubt, hierbei ist jedoch darauf zu achten,
								das die betroffene Bilddefinition bzw. Grafiktextkonserve nicht aktuell
								in Verwendung ist, sollte dies der Fall sein, wird eine negative
								Quittung Code 42 "Stellcode-Definition nicht änderbar" gesendet.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Anzeigeprinzip b:
								Bei der Verwendung von upload-fähigen "frei programmierbaren"
								LED-Pixelrasteranzeigen (Mono&#47;Color), werden die Zeicheninhalte in ein
								eigenes Format, zur internen Weiterverarbeitung, umgewandelt
								(z.B. Anpassung der Farbtiefe, ?). Jede Bilddefinition entspricht
								einem Stellcode, welcher wiederum einer BMP-Grafikdatei zugeordnet
								ist. Es ist bei gleicher Auflösung und Farbtiefe zulässig, das eine
								Bilddefinition mehreren DEs (WVZs) zugewiesen werden. Die
								BMP-Grafikdatei muss in ihrer Auflösung (x, y), der Auflösung des
								physikalischen Displays entsprechen.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Anzeigeprinzip d:
								Bei der Verwendung von LED-Pixel-Wechseltextanzeigen mit
								Grafiktextkonserven (Mono), werden die Grafiktextkonserven
								(z. B. Autobahnnummer, Stadium, Fußball, Flugzeug, ?) in ein eigenes
								Format, zur internen Weiterverarbeitung, umgewandelt. Jede
								Grafiktextkonserve bekommt eine Grafiktextkonservennummer von 1..254
								und kann beliebig in einen Text eingebaut werden
								(siehe Anhang 7, Kapitel 3). Eine Grafiktextkonservennummer entspricht
								damit nicht einem Stellcode und kann auch nicht im Steuerungsprinzip 2
								als Stellcode verwendet werden. Es ist bei gleicher Auflösung zulässig,
								dass eine Grafiktextkonserve mehreren DEs (Wechseltextanzeigen) zugewiesen
								werden. Die BMP-Grafikdatei muss in ihrer Auflösung (x, y), kleiner bzw.
								gleich der Auflösung der physikalischen Wechseltextanzeige entsprechen.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgBildDefinition.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsWzgBildDefinition getOdTlsWzgBildDefinition();
	
	/**
	Abruf Bilddefinition (FG 4 &#47; Typ 22).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 4: DE-Block-Struktur im Typ 22 "Abruf Bilddefinition&#47;Grafiktextkonserve"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional und wird verwendet
								mit ID 3 (Parameter) in Abrufrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Mit dieser Nachricht kann die Zentrale die BMP-Grafikdateien
								(s&#47;w bzw. c-24 Format) der vor Ort abgelegten Bilddefinitionen
								(Anzeigeprinzip b, frei Programmierbare LED-Pixel-Anzeigen),
								Upload-fähige LED-Pixelrasteranzeigen) bzw. die
								Grafiktextkonserven (Anzeigeprinzip d, Wechseltextanzeigen
								mit Grafiktextkonserven) abfragen. DEs, welche diesen Typ
								nicht unterstützten, antworten mit einer negativen Quittung
								Code 2 "unbekannter oder nicht auswertbarer Typ".
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Wenn ein nicht definierter Stellcode bzw. Grafiktextkonservennummer
								abgefragt wird, antwortet das DE mit einer negativen Quittung Code 22
								"unbekannter Stellcode&#47;Grafiktextkonservennummer". Ansonsten
								antwortet das DE mit einem DE-Block Typ 45.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Weitere Einzelheiten bzgl. Bilddefinition&#47;Grafiktextkonserve
								&lt;verweis pid="atg.tlsWzgBildDefinition"&gt;&lt;&#47;verweis&gt;.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsWzgAbrufBildDefinition.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsWzgAbrufBildDefinition getOdTlsWzgAbrufBildDefinition();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
