/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Diese Attributgruppe enhält die Anzahl der defekten LED.
<p>
&lt;absatz&gt;Dei Daten werden gemeldet über das herstellerspezifische TLS-Telegramm FG4, Typ 143.&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class OdAnzahlDefekteLED extends AbstractOnlineDatensatz<OdAnzahlDefekteLED.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Zustand,
				};
			}
	
			/**
			 * Zustand.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Zustand = new Aspekte("Zustand", "asp.zustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				@Defaultwert(wert = "Undefiniert")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.attribute.AttTlsSwarcoAnzahlDefekteLED
				 _anzahlDefekteLED
				;
				@Defaultwert(wert = "Undefiniert")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.attribute.AttTlsSwarcoFehlerBMP
				 _fehlerBMP
				;
		
			/**
			SWARCO: Anzahl defekte LED.
			<p>
			
			</p>
			
			@return der Wert von AnzahlDefekteLED.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.attribute.AttTlsSwarcoAnzahlDefekteLED
				 getAnzahlDefekteLED() {
				return _anzahlDefekteLED;
			}
		
			/**
			SWARCO: Anzahl defekte LED.
			<p>
			
			</p>
			
			@param _anzahlDefekteLED der neue Wert von AnzahlDefekteLED.
			*/
			public void setAnzahlDefekteLED(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.attribute.AttTlsSwarcoAnzahlDefekteLED
			 _anzahlDefekteLED) {
				this._anzahlDefekteLED = _anzahlDefekteLED;
			}
		
			/**
			SWARCO: Inhalt Byte Fehler-BMP
								(0=kein neues Fehler-BMP, 1=neues Fehler-BMP).
			<p>
			
			</p>
			
			@return der Wert von FehlerBMP.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.attribute.AttTlsSwarcoFehlerBMP
				 getFehlerBMP() {
				return _fehlerBMP;
			}
		
			/**
			SWARCO: Inhalt Byte Fehler-BMP
								(0=kein neues Fehler-BMP, 1=neues Fehler-BMP).
			<p>
			
			</p>
			
			@param _fehlerBMP der neue Wert von FehlerBMP.
			*/
			public void setFehlerBMP(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.attribute.AttTlsSwarcoFehlerBMP
			 _fehlerBMP) {
				this._fehlerBMP = _fehlerBMP;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getAnzahlDefekteLED() != null) {
		                if (getAnzahlDefekteLED().isZustand()) {
		                    datum.getUnscaledValue("AnzahlDefekteLED").setText(getAnzahlDefekteLED().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzahlDefekteLED").set(getAnzahlDefekteLED().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFehlerBMP() != null) {
		                if (getFehlerBMP().isZustand()) {
		                    datum.getUnscaledValue("FehlerBMP").setText(getFehlerBMP().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("FehlerBMP").set(getFehlerBMP().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AnzahlDefekteLED").isState()) {
								setAnzahlDefekteLED(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.attribute.AttTlsSwarcoAnzahlDefekteLED
								.getZustand(daten.getScaledValue("AnzahlDefekteLED").getText()));
							} else {
							setAnzahlDefekteLED(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.attribute.AttTlsSwarcoAnzahlDefekteLED
							(daten.
								getUnscaledValue
							("AnzahlDefekteLED").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("FehlerBMP").isState()) {
								setFehlerBMP(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.attribute.AttTlsSwarcoFehlerBMP
								.getZustand(daten.getScaledValue("FehlerBMP").getText()));
							} else {
							setFehlerBMP(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.attribute.AttTlsSwarcoFehlerBMP
							(daten.
								getUnscaledValue
							("FehlerBMP").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAnzahlDefekteLED(getAnzahlDefekteLED());
							klon.setFehlerBMP(getFehlerBMP());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.anzahlDefekteLED";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdAnzahlDefekteLED(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
