/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Stellzustand mit CRC32-Checksumme (FG 4 &#47; Typ 183).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 4: DE-Block-Struktur im Typ
							183 "Stellzustand mit CRC32 Checksumme"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 5 (Befehl) in Abruf-
							und Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Mit diesem DE-Block kann ein Stellbefehl 
							in Kurzversion (analog zum TLS DE-Typ 55) 
							um eine CRC32-Checksumme ergänzt werden.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Der DE-Typ 183 ist ein modifizierter DE-Typ 
							55 "Stellzustand" und ist abweichend von der
							TLS-Vorgabe nur in der Kurzversion zu 
							verwenden und um eine 4-Byte CRC32
							Checksumme ergänzt. Die CRC32 Checksumme 
							dient dazu, dass eine in der SST hinterlegte, 
							variable Anzeige im Zuge des Schaltbefehls 
							hinsichtlich ihres Inhaltes durch die 
							Unterzentrale (UZ) überprüft werden kann.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Schaltung durch die SST wird nur ausgeführt, 
							wenn die übermittelte CRC32 Checksumme mit der
							für den Stellbefehl hinterlegten CRC32 Checksumme
							des Anzeigeinhaltes übereinstimmt. Für den Fall, dass die 
							CRC32 Checksumme nicht übereinstimmt, bleibt die
							Anzeige unverändert und der Stellbefehl wird mit
							einer negativen Quittung (Ursache 43 - 
							"unzulässiger Stellcode") beantwortet. 
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class OdTlsWzgStellZustandMitCRC32Checksumme extends AbstractOnlineDatensatz<OdTlsWzgStellZustandMitCRC32Checksumme.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsVorgabe,
					Aspekte.TlsZustand,
				};
			}
	
			/**
			 * Aspekt für Vorgaben (Daten zum Senden an eine SS),
						die nicht wie die Parametersätze automatisch
						verschickt werden (z.B. goegrafische Kenndaten,
						Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsVorgabe = new Aspekte("TlsVorgabe", "asp.tlsVorgabe");
			
			/**
			 * Aspekt für den aktuellen Zustand , die i.d.R.
						ausfallsicher im SM oder EAK abgelegt werden (z.B.
						goegrafische Kenndaten, Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsZustand = new Aspekte("TlsZustand", "asp.tlsZustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
				 _anzeigePrinzip
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
				 _wVZAnzeige
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
				()
				;
				@Defaultwert(wert = "0")
				private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.attribute.AttCrc32Checksumme
				 _pruefsumme
				;
		
			/**
			Anzeigeprinzip des WZG entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von AnzeigePrinzip.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
				 getAnzeigePrinzip() {
				return _anzeigePrinzip;
			}
		
			/**
			Anzeigeprinzip des WZG entsprechend TLS.
			<p>
			
			</p>
			
			@param _anzeigePrinzip der neue Wert von AnzeigePrinzip.
			*/
			public void setAnzeigePrinzip(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
			 _anzeigePrinzip) {
				this._anzeigePrinzip = _anzeigePrinzip;
			}
		
			/**
			Einzelinformationen bei der Anzeige eines WVZ.
			<p>
			
			</p>
			
			@return der Wert von WVZAnzeige.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
				 getWVZAnzeige() {
				return _wVZAnzeige;
			}
		
			/**
			Einzelinformationen bei der Anzeige eines WVZ.
			<p>
			
			</p>
			
			@param _wVZAnzeige der neue Wert von WVZAnzeige.
			*/
			public void setWVZAnzeige(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
			 _wVZAnzeige) {
				this._wVZAnzeige = _wVZAnzeige;
			}
		
			/**
			Pruefsumme.
			<p>
			
			</p>
			
			@return der Wert von Pruefsumme.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.attribute.AttCrc32Checksumme
				 getPruefsumme() {
				return _pruefsumme;
			}
		
			/**
			Pruefsumme.
			<p>
			
			</p>
			
			@param _pruefsumme der neue Wert von Pruefsumme.
			*/
			public void setPruefsumme(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.attribute.AttCrc32Checksumme
			 _pruefsumme) {
				this._pruefsumme = _pruefsumme;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getAnzeigePrinzip() != null) {
		                if (getAnzeigePrinzip().isZustand()) {
		                    datum.getUnscaledValue("AnzeigePrinzip").setText(getAnzeigePrinzip().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzeigePrinzip").set(getAnzeigePrinzip().getValue());
		                }
					}
					// AttributListenDefinition
						getWVZAnzeige().bean2Atl(datum.getItem("WVZAnzeige"), factory);
					// GanzzahlAttributTyp
					if (getPruefsumme() != null) {
		                if (getPruefsumme().isZustand()) {
		                    datum.getUnscaledValue("Pruefsumme").setText(getPruefsumme().toString());
		                } else {
							datum.
							getScaledValue
		                	("Pruefsumme").set(getPruefsumme().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AnzeigePrinzip").isState()) {
								setAnzeigePrinzip(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
								.getZustand(daten.getScaledValue("AnzeigePrinzip").getText()));
							} else {
							setAnzeigePrinzip(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
							(daten.
								getUnscaledValue
							("AnzeigePrinzip").
									byteValue
							()));
							}
					// AttributListenDefinition
						getWVZAnzeige().atl2Bean(daten.getItem("WVZAnzeige"), factory);
					// GanzzahlAttributTyp
							setPruefsumme(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenswarco.attribute.AttCrc32Checksumme
							(daten.
								getScaledValue
							("Pruefsumme").
								doubleValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAnzeigePrinzip(getAnzeigePrinzip());
							klon._wVZAnzeige = getWVZAnzeige().clone();
							klon.setPruefsumme(getPruefsumme());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsWzgStellZustandMitCRC32Checksumme";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsWzgStellZustandMitCRC32Checksumme(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
