/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Info.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlAblaufBeschreibung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _pause
			;
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			> _programme = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlAblaufMitTemplate
			> _template = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlAblaufMitTemplate
			>(1, true);
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@return der Wert von Pause.
		*/
			public 	Zeitstempel
			 getPause() {
			return _pause;
		}
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@param _pause der neue Wert von Pause.
		*/
		public void setPause(	Zeitstempel
		 _pause) {
			this._pause = _pause;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von Programme.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			> getProgramme() {
			return _programme;
		}
	
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von Template.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlAblaufMitTemplate
			> getTemplate() {
			return _template;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Pause").setMillis(getPause().getTime());
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayProgramme = datum.getReferenceArray("Programme");
					arrayProgramme.setLength(getProgramme().size());
					for (int i = 0; i < arrayProgramme.getLength(); ++i) {
						final Object soProgramme = getProgramme().get(i);
						final SystemObject tmpProgramme;
						if (soProgramme instanceof SystemObject) {
							tmpProgramme = (SystemObject)soProgramme;
						} else if(soProgramme instanceof SystemObjekt){
							tmpProgramme = ((SystemObjekt)soProgramme).getSystemObject();
						} else{
							tmpProgramme = null;
						}
						arrayProgramme.getReferenceValue(i).setSystemObject(tmpProgramme);
					}
				// AttributListenDefinition
					final Data.Array arrayTemplate = datum.getArray("Template");
					arrayTemplate.setLength(getTemplate().size());
					for (int i = 0; i < arrayTemplate.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlAblaufMitTemplate
						 atl = getTemplate().get(i);
						atl.bean2Atl(arrayTemplate.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setPause(new
						Zeitstempel
						(daten.getTimeValue("Pause").getMillis()));
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayProgramme = daten.getReferenceArray("Programme");
					for (int i = 0; i < arrayProgramme.getLength(); ++i) {
						final long idProgramme = daten.getReferenceArray("Programme").getReferenceValue(i).getId();
						final SystemObjekt tmpProgramme;
						if (idProgramme == 0) {
							tmpProgramme = null;
						} else {
							final SystemObject soProgramme = factory.getDav().getDataModel().getObject(idProgramme);
							if (soProgramme == null) {
									tmpProgramme = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idProgramme);
							} else {
								tmpProgramme = factory.getModellobjekt(soProgramme);
							}
						}
							getProgramme().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
							) tmpProgramme);
					}
				// AttributListenDefinition
					final Data.Array arrayTemplate = daten.getArray("Template");
					for (int i = 0; i < arrayTemplate.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlAblaufMitTemplate
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlAblaufMitTemplate
						 ();
						atl.atl2Bean(arrayTemplate.getItem(i), factory);
						getTemplate().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAblaufBeschreibung clone() {
		AtlAblaufBeschreibung klon = new AtlAblaufBeschreibung();
		
						klon.setPause(getPause());
					klon._programme = getProgramme().clone();
					klon._template = getTemplate().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
