/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Nicht-blockierende Meldung des
					Ablaufservers an den Bediener.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlAblaufMeldung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _text
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
			 _meldungstyp
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttAblaufMeldungsPrioritaet
			 _prioritaet
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttPopUpFensterParameter
			 _popUp
			;
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Text.
		*/
			public String
			 getText() {
			return _text;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _text der neue Wert von Text.
		*/
		public void setText(String
		 _text) {
			if (_text.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._text = _text;
		}
	
		/**
		Klassifizierung einer Meldung.
		<p>
		Hiermit ist die Klassifizierung einer Meldung in "Fatal", "Fehler", "Warnung" und "Information" möglich.
		</p>
		
		@return der Wert von Meldungstyp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
			 getMeldungstyp() {
			return _meldungstyp;
		}
	
		/**
		Klassifizierung einer Meldung.
		<p>
		Hiermit ist die Klassifizierung einer Meldung in "Fatal", "Fehler", "Warnung" und "Information" möglich.
		</p>
		
		@param _meldungstyp der neue Wert von Meldungstyp.
		*/
		public void setMeldungstyp(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
		 _meldungstyp) {
			this._meldungstyp = _meldungstyp;
		}
	
		/**
		Die Priorität einer Meldung, die von einem
							Server
							erzeugt und abgesetzt wird.
		<p>
		
		</p>
		
		@return der Wert von Prioritaet.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttAblaufMeldungsPrioritaet
			 getPrioritaet() {
			return _prioritaet;
		}
	
		/**
		Die Priorität einer Meldung, die von einem
							Server
							erzeugt und abgesetzt wird.
		<p>
		
		</p>
		
		@param _prioritaet der neue Wert von Prioritaet.
		*/
		public void setPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttAblaufMeldungsPrioritaet
		 _prioritaet) {
			this._prioritaet = _prioritaet;
		}
	
		/**
		Beschreibt, ob eine Meldung, die von einem
							Server erzeugt
							und abgesetzt wird, auf einem Bedienrechner als
							eigenes Fenster
							aufpoppt
							oder nicht.
		<p>
		
		</p>
		
		@return der Wert von PopUp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttPopUpFensterParameter
			 getPopUp() {
			return _popUp;
		}
	
		/**
		Beschreibt, ob eine Meldung, die von einem
							Server erzeugt
							und abgesetzt wird, auf einem Bedienrechner als
							eigenes Fenster
							aufpoppt
							oder nicht.
		<p>
		
		</p>
		
		@param _popUp der neue Wert von PopUp.
		*/
		public void setPopUp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttPopUpFensterParameter
		 _popUp) {
			this._popUp = _popUp;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getText() != null) {
					datum.getTextValue("Text").setText(getText());
				}
				// GanzzahlAttributTyp
				if (getMeldungstyp() != null) {
	                if (getMeldungstyp().isZustand()) {
	                    datum.getUnscaledValue("Meldungstyp").setText(getMeldungstyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Meldungstyp").set(getMeldungstyp().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getPrioritaet() != null) {
	                if (getPrioritaet().isZustand()) {
	                    datum.getUnscaledValue("Prioritaet").setText(getPrioritaet().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Prioritaet").set(getPrioritaet().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getPopUp() != null) {
	                if (getPopUp().isZustand()) {
	                    datum.getUnscaledValue("PopUp").setText(getPopUp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("PopUp").set(getPopUp().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setText(daten.getTextValue("Text").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Meldungstyp").isState()) {
							setMeldungstyp(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
							.getZustand(daten.getScaledValue("Meldungstyp").getText()));
						} else {
						setMeldungstyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
						(daten.
							getUnscaledValue
						("Meldungstyp").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Prioritaet").isState()) {
							setPrioritaet(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttAblaufMeldungsPrioritaet
							.getZustand(daten.getScaledValue("Prioritaet").getText()));
						} else {
						setPrioritaet(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttAblaufMeldungsPrioritaet
						(daten.
							getUnscaledValue
						("Prioritaet").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("PopUp").isState()) {
							setPopUp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttPopUpFensterParameter
							.getZustand(daten.getScaledValue("PopUp").getText()));
						} else {
						setPopUp(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AttPopUpFensterParameter
						(daten.
							getUnscaledValue
						("PopUp").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAblaufMeldung clone() {
		AtlAblaufMeldung klon = new AtlAblaufMeldung();
		
						klon.setText(getText());
						klon.setMeldungstyp(getMeldungstyp());
						klon.setPrioritaet(getPrioritaet());
						klon.setPopUp(getPopUp());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
