/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ein Relativprogramm definiert einen Anzeigeinhalt für
					EIN
					bestimmtes Anzeigeelement. Dieses Anzeigeelement
					kann relativ zu
					einer Liste mit Anzeigequerschnitten
					und einer Liste mit Fahrspuren
					addressiert werden.
					Der Anzeigeinhalt wird hier als Objektreferenz
					übergeben.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlRelativProgramm implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _aQRelativReferenz
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _fahrSpurRelativReferenz
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AttAnzeigeRichtung
			 _schildZeigeRichtung
			;
			private 	Object
			 _inhalt
			;
	
		/**
		1 - erster Anzeigequerschnitt in Liste,
								2 - zweiter
								Anzeigequerschnitt in Liste,
								...
		<p>
		
		</p>
		
		@return der Wert von AQRelativReferenz.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getAQRelativReferenz() {
			return _aQRelativReferenz;
		}
	
		/**
		1 - erster Anzeigequerschnitt in Liste,
								2 - zweiter
								Anzeigequerschnitt in Liste,
								...
		<p>
		
		</p>
		
		@param _aQRelativReferenz der neue Wert von AQRelativReferenz.
		*/
		public void setAQRelativReferenz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _aQRelativReferenz) {
			this._aQRelativReferenz = _aQRelativReferenz;
		}
	
		/**
		1 - erste Fahrspur in Liste,
								2 - zweite Fahrspur in Liste,
								...
		<p>
		
		</p>
		
		@return der Wert von FahrSpurRelativReferenz.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getFahrSpurRelativReferenz() {
			return _fahrSpurRelativReferenz;
		}
	
		/**
		1 - erste Fahrspur in Liste,
								2 - zweite Fahrspur in Liste,
								...
		<p>
		
		</p>
		
		@param _fahrSpurRelativReferenz der neue Wert von FahrSpurRelativReferenz.
		*/
		public void setFahrSpurRelativReferenz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _fahrSpurRelativReferenz) {
			this._fahrSpurRelativReferenz = _fahrSpurRelativReferenz;
		}
	
		/**
		Gibt an, ob ein Schild in oder gegen die Fahrrichtung
								zeigt.
								Dabei geht auch '?' für 'unbekannt'.
		<p>
		
		</p>
		
		@return der Wert von SchildZeigeRichtung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AttAnzeigeRichtung
			 getSchildZeigeRichtung() {
			return _schildZeigeRichtung;
		}
	
		/**
		Gibt an, ob ein Schild in oder gegen die Fahrrichtung
								zeigt.
								Dabei geht auch '?' für 'unbekannt'.
		<p>
		
		</p>
		
		@param _schildZeigeRichtung der neue Wert von SchildZeigeRichtung.
		*/
		public void setSchildZeigeRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AttAnzeigeRichtung
		 _schildZeigeRichtung) {
			this._schildZeigeRichtung = _schildZeigeRichtung;
		}
	
		/**
		Attribut zur Referenzierung von beliebigen Objekten.
		<p>
		
		</p>
		
		@return der Wert von Inhalt.
		*/
			public 	Object
			 getInhalt() {
			return _inhalt;
		}
	
		/**
		Attribut zur Referenzierung von beliebigen Objekten.
		<p>
		
		</p>
		
		@param _inhalt der neue Wert von Inhalt.
		*/
		public void setInhalt(	Object
		 _inhalt) {
			this._inhalt = _inhalt;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getAQRelativReferenz() != null) {
	                if (getAQRelativReferenz().isZustand()) {
	                    datum.getUnscaledValue("AQRelativReferenz").setText(getAQRelativReferenz().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AQRelativReferenz").set(getAQRelativReferenz().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getFahrSpurRelativReferenz() != null) {
	                if (getFahrSpurRelativReferenz().isZustand()) {
	                    datum.getUnscaledValue("FahrSpurRelativReferenz").setText(getFahrSpurRelativReferenz().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("FahrSpurRelativReferenz").set(getFahrSpurRelativReferenz().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getSchildZeigeRichtung() != null) {
	                if (getSchildZeigeRichtung().isZustand()) {
	                    datum.getUnscaledValue("SchildZeigeRichtung").setText(getSchildZeigeRichtung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SchildZeigeRichtung").set(getSchildZeigeRichtung().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soInhalt = getInhalt();
					final SystemObject tmpInhalt;
						if (soInhalt instanceof SystemObject) {
							tmpInhalt = (SystemObject)soInhalt;
						} else if(soInhalt instanceof SystemObjekt){
							tmpInhalt = ((SystemObjekt)soInhalt).getSystemObject();
						} else{
							tmpInhalt = null;
						}
					datum.getReferenceValue("Inhalt").setSystemObject(tmpInhalt);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setAQRelativReferenz(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("AQRelativReferenz").
								longValue
						()));
				// GanzzahlAttributTyp
						setFahrSpurRelativReferenz(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("FahrSpurRelativReferenz").
								longValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("SchildZeigeRichtung").isState()) {
							setSchildZeigeRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AttAnzeigeRichtung
							.getZustand(daten.getScaledValue("SchildZeigeRichtung").getText()));
						} else {
						setSchildZeigeRichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlverriegelung.attribute.AttAnzeigeRichtung
						(daten.
							getUnscaledValue
						("SchildZeigeRichtung").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final long idInhalt = daten.getReferenceValue("Inhalt").getId();
					final SystemObjekt tmpInhalt;
					if (idInhalt == 0) {
						tmpInhalt = null;
					} else {
						final SystemObject soInhalt = factory.getDav().getDataModel().getObject(idInhalt);
						if (soInhalt == null) {
								tmpInhalt = new BaseUngueltigesSystemObjekt(idInhalt);
						} else {
							tmpInhalt = factory.getModellobjekt(soInhalt);
						}
					}
					setInhalt((	Object
					) tmpInhalt);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlRelativProgramm clone() {
		AtlRelativProgramm klon = new AtlRelativProgramm();
		
						klon.setAQRelativReferenz(getAQRelativReferenz());
						klon.setFahrSpurRelativReferenz(getFahrSpurRelativReferenz());
						klon.setSchildZeigeRichtung(getSchildZeigeRichtung());
						klon.setInhalt(getInhalt());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
