/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt, ob eine Meldung, die von einem
					Server erzeugt
					und abgesetzt wird, auf einem Bedienrechner als
					eigenes Fenster
					aufpoppt
					oder nicht.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 3L,
	einheit = ""
)
@Defaultwert(wert = "Lokale Vorgabe")
public class AttPopUpFensterParameter extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MIN_VALUE =
				Byte
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Byte
	 MAX_VALUE =
				Byte
		.valueOf("3");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	Die Entscheidung basiert auf einer auf dem lokalen
								Terminal
								hinterlegten Variablen.
	<p>
	
	</p>
	*/
	public static final AttPopUpFensterParameter ZUSTAND_0_LOKALE_VORGABE = new AttPopUpFensterParameter("Lokale Vorgabe", 		Byte
	.valueOf("0"));

	/**
	Die Entscheidung basiert auf einer im Datenverteiler
								hinterlegten Variablen.
	<p>
	
	</p>
	*/
	public static final AttPopUpFensterParameter ZUSTAND_1_GLOBALE_VORGABE = new AttPopUpFensterParameter("Globale Vorgabe", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttPopUpFensterParameter ZUSTAND_2_IMMER = new AttPopUpFensterParameter("Immer", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttPopUpFensterParameter ZUSTAND_3_NIE = new AttPopUpFensterParameter("Nie", 		Byte
	.valueOf("3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttPopUpFensterParameter getZustand(final 		Byte
	 value) {
		for (AttPopUpFensterParameter e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttPopUpFensterParameter getZustand(final String value) {
		for (AttPopUpFensterParameter e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttPopUpFensterParameter> getZustaende() {
		List<AttPopUpFensterParameter> list = new ArrayList<AttPopUpFensterParameter>();
		list.add(ZUSTAND_0_LOKALE_VORGABE);
		list.add(ZUSTAND_1_GLOBALE_VORGABE);
		list.add(ZUSTAND_2_IMMER);
		list.add(ZUSTAND_3_NIE);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut PopUpFensterParameter.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttPopUpFensterParameter(final 		Byte
	 value) {
		super(value);
	}
	
	private AttPopUpFensterParameter(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
