/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Hier ist eine Menge von Schritten beschrieben, die
					hintereinander ausgeführt werden sollen. Jeder einzelne
					Schritt kann
					wieder eine Menge von Programmen sein. Zwischen
					den einzelnen
					Schritten wird eine Pause gemacht.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdAblaufSchaltProgramm extends AbstractKonfigurationsDatensatz<KdAblaufSchaltProgramm.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _kommentar
				= new String
				()
				;
				private 	Zeitstempel
				 _pause
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlAblaufBeschreibung
				> _schritte = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlAblaufBeschreibung
				>(0, true);
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Kommentar.
			*/
				public String
				 getKommentar() {
				return _kommentar;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _kommentar der neue Wert von Kommentar.
			*/
			public void setKommentar(String
			 _kommentar) {
				if (_kommentar.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._kommentar = _kommentar;
			}
		
			/**
			Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
			<p>
			
			</p>
			
			@return der Wert von Pause.
			*/
				public 	Zeitstempel
				 getPause() {
				return _pause;
			}
		
			/**
			Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
			<p>
			
			</p>
			
			@param _pause der neue Wert von Pause.
			*/
			public void setPause(	Zeitstempel
			 _pause) {
				this._pause = _pause;
			}
		
			/**
			Info.
			<p>
			
			</p>
			
			@return der Wert von Schritte.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlAblaufBeschreibung
				> getSchritte() {
				return _schritte;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getKommentar() != null) {
						datum.getTextValue("Kommentar").setText(getKommentar());
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("Pause").setMillis(getPause().getTime());
					// AttributListenDefinition
						final Data.Array arraySchritte = datum.getArray("Schritte");
						arraySchritte.setLength(getSchritte().size());
						for (int i = 0; i < arraySchritte.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlAblaufBeschreibung
							 atl = getSchritte().get(i);
							atl.bean2Atl(arraySchritte.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setKommentar(daten.getTextValue("Kommentar").getText());
					// ZeitstempelAttributTyp
						setPause(new
							Zeitstempel
							(daten.getTimeValue("Pause").getMillis()));
					// AttributListenDefinition
						final Data.Array arraySchritte = daten.getArray("Schritte");
						for (int i = 0; i < arraySchritte.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlAblaufBeschreibung
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.attribute.AtlAblaufBeschreibung
							 ();
							atl.atl2Bean(arraySchritte.getItem(i), factory);
							getSchritte().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setKommentar(getKommentar());
							klon.setPause(getPause());
						klon._schritte = getSchritte().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ablaufSchaltProgramm";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdAblaufSchaltProgramm(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
