/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Fest konfigurierte Liste von Schaltprogrammgruppen
					bzw. Programmen, bei denen der Ablaufserver das
					Ergebnis Timeout
					ignoriert und mit dem Ablauf fortfährt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdProgrammeTimeoutIgnoreInit extends AbstractKonfigurationsDatensatz<KdProgrammeTimeoutIgnoreInit.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
				> _schaltprogrammgruppen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				> _schaltprogramme = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				>(0, true);
		
			/**
			Verweis auf ein Objekt vom Typ SchaltProgrammGruppe.
			<p>
			
			</p>
			
			@return der Wert von Schaltprogrammgruppen.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
				> getSchaltprogrammgruppen() {
				return _schaltprogrammgruppen;
			}
		
		
			/**
			Info.
			<p>
			
			</p>
			
			@return der Wert von Schaltprogramme.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				> getSchaltprogramme() {
				return _schaltprogramme;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arraySchaltprogrammgruppen = datum.getReferenceArray("Schaltprogrammgruppen");
						arraySchaltprogrammgruppen.setLength(getSchaltprogrammgruppen().size());
						for (int i = 0; i < arraySchaltprogrammgruppen.getLength(); ++i) {
							final Object soSchaltprogrammgruppen = getSchaltprogrammgruppen().get(i);
							final SystemObject tmpSchaltprogrammgruppen;
							if (soSchaltprogrammgruppen instanceof SystemObject) {
								tmpSchaltprogrammgruppen = (SystemObject)soSchaltprogrammgruppen;
							} else if(soSchaltprogrammgruppen instanceof SystemObjekt){
								tmpSchaltprogrammgruppen = ((SystemObjekt)soSchaltprogrammgruppen).getSystemObject();
							} else{
								tmpSchaltprogrammgruppen = null;
							}
							arraySchaltprogrammgruppen.getReferenceValue(i).setSystemObject(tmpSchaltprogrammgruppen);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arraySchaltprogramme = datum.getReferenceArray("Schaltprogramme");
						arraySchaltprogramme.setLength(getSchaltprogramme().size());
						for (int i = 0; i < arraySchaltprogramme.getLength(); ++i) {
							final Object soSchaltprogramme = getSchaltprogramme().get(i);
							final SystemObject tmpSchaltprogramme;
							if (soSchaltprogramme instanceof SystemObject) {
								tmpSchaltprogramme = (SystemObject)soSchaltprogramme;
							} else if(soSchaltprogramme instanceof SystemObjekt){
								tmpSchaltprogramme = ((SystemObjekt)soSchaltprogramme).getSystemObject();
							} else{
								tmpSchaltprogramme = null;
							}
							arraySchaltprogramme.getReferenceValue(i).setSystemObject(tmpSchaltprogramme);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arraySchaltprogrammgruppen = daten.getReferenceArray("Schaltprogrammgruppen");
						for (int i = 0; i < arraySchaltprogrammgruppen.getLength(); ++i) {
							final long idSchaltprogrammgruppen = daten.getReferenceArray("Schaltprogrammgruppen").getReferenceValue(i).getId();
							final SystemObjekt tmpSchaltprogrammgruppen;
							if (idSchaltprogrammgruppen == 0) {
								tmpSchaltprogrammgruppen = null;
							} else {
								final SystemObject soSchaltprogrammgruppen = factory.getDav().getDataModel().getObject(idSchaltprogrammgruppen);
								if (soSchaltprogrammgruppen == null) {
										tmpSchaltprogrammgruppen = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammGruppeUngueltig(idSchaltprogrammgruppen);
								} else {
									tmpSchaltprogrammgruppen = factory.getModellobjekt(soSchaltprogrammgruppen);
								}
							}
								getSchaltprogrammgruppen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgrammGruppe
								) tmpSchaltprogrammgruppen);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arraySchaltprogramme = daten.getReferenceArray("Schaltprogramme");
						for (int i = 0; i < arraySchaltprogramme.getLength(); ++i) {
							final long idSchaltprogramme = daten.getReferenceArray("Schaltprogramme").getReferenceValue(i).getId();
							final SystemObjekt tmpSchaltprogramme;
							if (idSchaltprogramme == 0) {
								tmpSchaltprogramme = null;
							} else {
								final SystemObject soSchaltprogramme = factory.getDav().getDataModel().getObject(idSchaltprogramme);
								if (soSchaltprogramme == null) {
										tmpSchaltprogramme = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idSchaltprogramme);
								} else {
									tmpSchaltprogramme = factory.getModellobjekt(soSchaltprogramme);
								}
							}
								getSchaltprogramme().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
								) tmpSchaltprogramme);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._schaltprogrammgruppen = getSchaltprogrammgruppen().clone();
						klon._schaltprogramme = getSchaltprogramme().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.programmeTimeoutIgnore.Init";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdProgrammeTimeoutIgnoreInit(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
