/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Info.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface BcAblaufServer extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.objekte.BcManagedApplication
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.bcAblaufServer"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Beschreibt eine Liste von Anzeigen, die vom
						Soll-Ist-Vergleich
						ignoriert werden, d.h. die nicht automatisch
						nachgeschaltet werden,
						wenn ihr Sollzustand nicht mit dem
						Ist-Zustand übereinstimmt.
	<p>
	
	</p>
	@return der Datensatz NichtNachgeschalteteAnzeigen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.parameter.PdNichtNachgeschalteteAnzeigen getPdNichtNachgeschalteteAnzeigen();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Parametrierbare Liste von
						Schaltprogrammgruppen bzw. Programmen, bei denen der Ablaufserver
						das
						Ergebnis Timeout ignoriert und mit dem Ablauf fortfährt.
	<p>
	
	</p>
	@return der Datensatz ProgrammeTimeoutIgnore.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.parameter.PdProgrammeTimeoutIgnore getPdProgrammeTimeoutIgnore();
	
	/**
	Fest konfigurierte Liste von Schaltprogrammgruppen
						bzw. Programmen, bei denen der Ablaufserver das
						Ergebnis Timeout
						ignoriert und mit dem Ablauf fortfährt.
	<p>
	
	</p>
	@return der Datensatz ProgrammeTimeoutIgnoreInit.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.konfigurationsdaten.KdProgrammeTimeoutIgnoreInit getKdProgrammeTimeoutIgnoreInit();
	
	/**
	Beschreibt eine Liste von Anzeigen, die vom
						Soll-Ist-Vergleich
						ignoriert werden, d.h. die nicht automatisch
						nachgeschaltet werden,
						wenn ihr Sollzustand nicht mit dem
						Ist-Zustand übereinstimmt.
	<p>
	
	</p>
	@return der Datensatz NichtNachgeschalteteAnzeigenInit.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.konfigurationsdaten.KdNichtNachgeschalteteAnzeigenInit getKdNichtNachgeschalteteAnzeigenInit();
	
	/**
	Info.
	<p>
	
	</p>
	@return der Datensatz BcAblaufServerKommando.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.onlinedaten.OdBcAblaufServerKommando getOdBcAblaufServerKommando();
	
	/**
	Die Liste von Nutzern, die bei einer Bedienerabfrage
						befragt werden
						können. Die Reihenfolge ist durch die
						Array-Indizierung festgelegt. Bei
						einer
						Bedienerabfrage wird der
						erste Nutzer aus dieserListe, der online ist,
						befragt.
	<p>
	
	</p>
	@return der Datensatz NutzerListe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.parameter.PdNutzerListe getPdNutzerListe();
	
	/**
	Entspricht der Schedule-Liste des alten
						WVZ-Servers.
	<p>
	
	</p>
	@return der Datensatz AktuelleAblaufKommandos.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.onlinedaten.OdAktuelleAblaufKommandos getOdAktuelleAblaufKommandos();
	
	/**
	Info.
	<p>
	
	</p>
	@return der Datensatz UebergangsMatrix.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.parameter.PdUebergangsMatrix getPdUebergangsMatrix();
	
	/**
	Beschreibt den gerade ausgeführten Ablauf.
	<p>
	
	</p>
	@return der Datensatz AktuellerAblauf.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlablauf.onlinedaten.OdAktuellerAblauf getOdAktuellerAblauf();
	
	/**
	Datensatz zur Beschreibung einer Anfrage an eine
						Managed Application.
	<p>
	
	</p>
	@return der Datensatz BcManagedApplicationKommando.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.onlinedaten.OdBcManagedApplicationKommando getOdBcManagedApplicationKommando();
	
	/**
	Datensatz zur Beschreibung einer
						Antwort von einer
						Managed Application.
	<p>
	
	</p>
	@return der Datensatz BcManagedApplicationAntwort.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.onlinedaten.OdBcManagedApplicationAntwort getOdBcManagedApplicationAntwort();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
