/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert ein Vorkommen eines Textes an einer konkreten Position auf der FTA (Textcontainer).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlGrafikTextDaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
			 _positionX
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
			 _positionY
			;
			private String
			 _schriftart
			= new String
			()
			;
			private String
			 _text
			= new String
			()
			;
	
		/**
		Attribut für Grafikeinheit (Pixel).
		<p>
		
		</p>
		
		@return der Wert von PositionX.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
			 getPositionX() {
			return _positionX;
		}
	
		/**
		Attribut für Grafikeinheit (Pixel).
		<p>
		
		</p>
		
		@param _positionX der neue Wert von PositionX.
		*/
		public void setPositionX(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
		 _positionX) {
			this._positionX = _positionX;
		}
	
		/**
		Attribut für Grafikeinheit (Pixel).
		<p>
		
		</p>
		
		@return der Wert von PositionY.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
			 getPositionY() {
			return _positionY;
		}
	
		/**
		Attribut für Grafikeinheit (Pixel).
		<p>
		
		</p>
		
		@param _positionY der neue Wert von PositionY.
		*/
		public void setPositionY(de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
		 _positionY) {
			this._positionY = _positionY;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Schriftart.
		*/
			public String
			 getSchriftart() {
			return _schriftart;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _schriftart der neue Wert von Schriftart.
		*/
		public void setSchriftart(String
		 _schriftart) {
			if (_schriftart.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._schriftart = _schriftart;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Text.
		*/
			public String
			 getText() {
			return _text;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _text der neue Wert von Text.
		*/
		public void setText(String
		 _text) {
			if (_text.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._text = _text;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getPositionX() != null) {
	                if (getPositionX().isZustand()) {
	                    datum.getUnscaledValue("PositionX").setText(getPositionX().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("PositionX").set(getPositionX().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getPositionY() != null) {
	                if (getPositionY().isZustand()) {
	                    datum.getUnscaledValue("PositionY").setText(getPositionY().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("PositionY").set(getPositionY().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getSchriftart() != null) {
					datum.getTextValue("Schriftart").setText(getSchriftart());
				}
				// ZeichenkettenAttributTyp
				if (getText() != null) {
					datum.getTextValue("Text").setText(getText());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setPositionX(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
						(daten.
							getUnscaledValue
						("PositionX").
								intValue
						()));
				// GanzzahlAttributTyp
						setPositionY(new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.attribute.AttGrafikPixel
						(daten.
							getUnscaledValue
						("PositionY").
								intValue
						()));
				// ZeichenkettenAttributTyp
					setSchriftart(daten.getTextValue("Schriftart").getText());
				// ZeichenkettenAttributTyp
					setText(daten.getTextValue("Text").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlGrafikTextDaten clone() {
		AtlGrafikTextDaten klon = new AtlGrafikTextDaten();
		
						klon.setPositionX(getPositionX());
						klon.setPositionY(getPositionY());
						klon.setSchriftart(getSchriftart());
						klon.setText(getText());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
