/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt die Struktur von Bilddaten zur Verwendung bei der Kommunikation
				zwischen Bedienoberfläche und Bildverwaltungs-Server sowie zur Verwaltung
				der auf die SSTs heruntergeladenen Bitmaps.
<p>
&lt;absatz&gt;Die Attributliste verwaltet zum einen die semantischen Daten in den
				Attributen GrafikTextDaten und GrafikSymbolDaten, diese dienen dazu, die Informationen
				in den Editor zum Bearbeiten zu laden und zur Suche im Archiv.&lt;&#47;absatz&gt;
				&lt;absatz&gt;Zum anderen wird die vom Editor aus diesen sematischen Inhalten erstellte
				Bitmap im Attribut Bild mit transportiert, inkl. Header. Die Farbtiefe der Bitmap
				muss mit der Farbtiefe unseres übergeordneten Anzeigetyps übereinstimmen.
				Der Name der Bitmap wird aus dem Attribut URL entnommen, er wird u.a.
				beim Download auf die SST benötigt.&lt;&#47;absatz&gt;
				&lt;absatz&gt;Schlussendlich wird noch eine variabel lange Liste von anzeigen transportiert.
				Auf der Strecke Bedienoberfläche --&gt; Bildverwaltungs-Server dient sie als
				Kommando, auf welche Anzeigen, sprich DEs, das Bild heruntergeladen werden soll. Auf Seite
				des Bildverwaltungs-Servers wird hier dynamisch gespeichert, auf welchen Anzeigen, sprich DEs,
				das Bild wirklich vorhanden und mit unserem Stellcode belegt, also mithin
				schaltbar ist.&lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlInhaltGrafikFreiBilddaten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _bezeichnung
			= new String
			()
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlGrafikTextDaten
			> _grafikTextDaten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlGrafikTextDaten
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlGrafikSymbolDaten
			> _grafikSymbolDaten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlGrafikSymbolDaten
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			> _bild = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			> _anzeigen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeIst
			 _stellCode
			;
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Bezeichnung.
		*/
			public String
			 getBezeichnung() {
			return _bezeichnung;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _bezeichnung der neue Wert von Bezeichnung.
		*/
		public void setBezeichnung(String
		 _bezeichnung) {
			if (_bezeichnung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._bezeichnung = _bezeichnung;
		}
	
		/**
		Definiert ein Vorkommen eines Textes an einer konkreten Position auf der FTA (Textcontainer).
		<p>
		
		</p>
		
		@return der Wert von GrafikTextDaten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlGrafikTextDaten
			> getGrafikTextDaten() {
			return _grafikTextDaten;
		}
	
	
		/**
		Definiert ein Vorkommen eines Symbols an einer konkreten Position auf der FTA (Grafikcontainer).
		<p>
		
		</p>
		
		@return der Wert von GrafikSymbolDaten.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlGrafikSymbolDaten
			> getGrafikSymbolDaten() {
			return _grafikSymbolDaten;
		}
	
	
		/**
		Dieses Bytearray sollte die gesamte BMP-Datei, inkl. BMP-Header,
							enthalten. Man kann dann die Farbtiefe der Bitmap aus dem Header bestimmen
							und gegen die Farbtiefe unseres Anzeigetyps verifizieren.
		<p>
		
		</p>
		
		@return der Wert von Bild.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
			> getBild() {
			return _bild;
		}
	
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.anzeige.
		<p>
		
		</p>
		
		@return der Wert von Anzeigen.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			> getAnzeigen() {
			return _anzeigen;
		}
	
	
		/**
		Ist-Zustand des Stellcodes.
		<p>
		
		</p>
		
		@return der Wert von StellCode.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeIst
			 getStellCode() {
			return _stellCode;
		}
	
		/**
		Ist-Zustand des Stellcodes.
		<p>
		
		</p>
		
		@param _stellCode der neue Wert von StellCode.
		*/
		public void setStellCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeIst
		 _stellCode) {
			this._stellCode = _stellCode;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getBezeichnung() != null) {
					datum.getTextValue("Bezeichnung").setText(getBezeichnung());
				}
				// AttributListenDefinition
					final Data.Array arrayGrafikTextDaten = datum.getArray("GrafikTextDaten");
					arrayGrafikTextDaten.setLength(getGrafikTextDaten().size());
					for (int i = 0; i < arrayGrafikTextDaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlGrafikTextDaten
						 atl = getGrafikTextDaten().get(i);
						atl.bean2Atl(arrayGrafikTextDaten.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayGrafikSymbolDaten = datum.getArray("GrafikSymbolDaten");
					arrayGrafikSymbolDaten.setLength(getGrafikSymbolDaten().size());
					for (int i = 0; i < arrayGrafikSymbolDaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlGrafikSymbolDaten
						 atl = getGrafikSymbolDaten().get(i);
						atl.bean2Atl(arrayGrafikSymbolDaten.getItem(i), factory);
	
					}
				// GanzzahlAttributTyp
				if (getBild() != null) {
					final Data.NumberArray arrayBild = datum.
						getUnscaledArray
						("Bild");
					arrayBild.setLength(getBild().size());
					for (int i = 0; i < arrayBild.getLength(); ++i) {
						arrayBild.getValue(i).set(getBild().get(i).getValue());
					}
				}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAnzeigen = datum.getReferenceArray("Anzeigen");
					arrayAnzeigen.setLength(getAnzeigen().size());
					for (int i = 0; i < arrayAnzeigen.getLength(); ++i) {
						final Object soAnzeigen = getAnzeigen().get(i);
						final SystemObject tmpAnzeigen;
						if (soAnzeigen instanceof SystemObject) {
							tmpAnzeigen = (SystemObject)soAnzeigen;
						} else if(soAnzeigen instanceof SystemObjekt){
							tmpAnzeigen = ((SystemObjekt)soAnzeigen).getSystemObject();
						} else{
							tmpAnzeigen = null;
						}
						arrayAnzeigen.getReferenceValue(i).setSystemObject(tmpAnzeigen);
					}
				// GanzzahlAttributTyp
				if (getStellCode() != null) {
	                if (getStellCode().isZustand()) {
	                    datum.getUnscaledValue("StellCode").setText(getStellCode().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("StellCode").set(getStellCode().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setBezeichnung(daten.getTextValue("Bezeichnung").getText());
				// AttributListenDefinition
					final Data.Array arrayGrafikTextDaten = daten.getArray("GrafikTextDaten");
					for (int i = 0; i < arrayGrafikTextDaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlGrafikTextDaten
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlGrafikTextDaten
						 ();
						atl.atl2Bean(arrayGrafikTextDaten.getItem(i), factory);
						getGrafikTextDaten().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayGrafikSymbolDaten = daten.getArray("GrafikSymbolDaten");
					for (int i = 0; i < arrayGrafikSymbolDaten.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlGrafikSymbolDaten
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.attribute.AtlGrafikSymbolDaten
						 ();
						atl.atl2Bean(arrayGrafikSymbolDaten.getItem(i), factory);
						getGrafikSymbolDaten().add(atl);
					}
				// GanzzahlAttributTyp
					final Data.NumberArray arrayBild = daten.
						getUnscaledArray
					("Bild");
	
					for (int i = 0; i < arrayBild.getLength(); ++i) {
	                    getBild().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
	                    (arrayBild.
	                    		byteValue
	                    (i)));
	                }
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAnzeigen = daten.getReferenceArray("Anzeigen");
					for (int i = 0; i < arrayAnzeigen.getLength(); ++i) {
						final long idAnzeigen = daten.getReferenceArray("Anzeigen").getReferenceValue(i).getId();
						final SystemObjekt tmpAnzeigen;
						if (idAnzeigen == 0) {
							tmpAnzeigen = null;
						} else {
							final SystemObject soAnzeigen = factory.getDav().getDataModel().getObject(idAnzeigen);
							if (soAnzeigen == null) {
									tmpAnzeigen = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeUngueltig(idAnzeigen);
							} else {
								tmpAnzeigen = factory.getModellobjekt(soAnzeigen);
							}
						}
							getAnzeigen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
							) tmpAnzeigen);
					}
				// GanzzahlAttributTyp
						setStellCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgStellCodeIst
						(daten.
							getUnscaledValue
						("StellCode").
								shortValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlInhaltGrafikFreiBilddaten clone() {
		AtlInhaltGrafikFreiBilddaten klon = new AtlInhaltGrafikFreiBilddaten();
		
						klon.setBezeichnung(getBezeichnung());
					klon._grafikTextDaten = getGrafikTextDaten().clone();
					klon._grafikSymbolDaten = getGrafikSymbolDaten().clone();
					klon._bild = getBild().clone();
					klon._anzeigen = getAnzeigen().clone();
						klon.setStellCode(getStellCode());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
