/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibung der Priorität der WVZInhalte an einem Anzeigetyp.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class KdAnzeigeTypPriorisierung extends AbstractKonfigurationsDatensatz<KdAnzeigeTypPriorisierung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeTyp
				 _anzeigeTyp
				;
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WvzInhalt
				> _wvzInhalteReferenzPrioritaet = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WvzInhalt
				>(0, true);
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.anzeigeTyp.
			<p>
			
			</p>
			
			@return der Wert von AnzeigeTyp.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeTyp
				 getAnzeigeTyp() {
				return _anzeigeTyp;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.anzeigeTyp.
			<p>
			
			</p>
			
			@param _anzeigeTyp der neue Wert von AnzeigeTyp.
			*/
			public void setAnzeigeTyp(	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeTyp
			 _anzeigeTyp) {
				this._anzeigeTyp = _anzeigeTyp;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.wvzInhalt.
			<p>
			
			</p>
			
			@return der Wert von WvzInhalteReferenzPrioritaet.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WvzInhalt
				> getWvzInhalteReferenzPrioritaet() {
				return _wvzInhalteReferenzPrioritaet;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soAnzeigeTyp = getAnzeigeTyp();
						final SystemObject tmpAnzeigeTyp;
							if (soAnzeigeTyp instanceof SystemObject) {
								tmpAnzeigeTyp = (SystemObject)soAnzeigeTyp;
							} else if(soAnzeigeTyp instanceof SystemObjekt){
								tmpAnzeigeTyp = ((SystemObjekt)soAnzeigeTyp).getSystemObject();
							} else{
								tmpAnzeigeTyp = null;
							}
						datum.getReferenceValue("AnzeigeTyp").setSystemObject(tmpAnzeigeTyp);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayWvzInhalteReferenzPrioritaet = datum.getReferenceArray("WvzInhalteReferenzPrioritaet");
						arrayWvzInhalteReferenzPrioritaet.setLength(getWvzInhalteReferenzPrioritaet().size());
						for (int i = 0; i < arrayWvzInhalteReferenzPrioritaet.getLength(); ++i) {
							final Object soWvzInhalteReferenzPrioritaet = getWvzInhalteReferenzPrioritaet().get(i);
							final SystemObject tmpWvzInhalteReferenzPrioritaet;
							if (soWvzInhalteReferenzPrioritaet instanceof SystemObject) {
								tmpWvzInhalteReferenzPrioritaet = (SystemObject)soWvzInhalteReferenzPrioritaet;
							} else if(soWvzInhalteReferenzPrioritaet instanceof SystemObjekt){
								tmpWvzInhalteReferenzPrioritaet = ((SystemObjekt)soWvzInhalteReferenzPrioritaet).getSystemObject();
							} else{
								tmpWvzInhalteReferenzPrioritaet = null;
							}
							arrayWvzInhalteReferenzPrioritaet.getReferenceValue(i).setSystemObject(tmpWvzInhalteReferenzPrioritaet);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idAnzeigeTyp = daten.getReferenceValue("AnzeigeTyp").getId();
						final SystemObjekt tmpAnzeigeTyp;
						if (idAnzeigeTyp == 0) {
							tmpAnzeigeTyp = null;
						} else {
							final SystemObject soAnzeigeTyp = factory.getDav().getDataModel().getObject(idAnzeigeTyp);
							if (soAnzeigeTyp == null) {
									tmpAnzeigeTyp = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeTypUngueltig(idAnzeigeTyp);
							} else {
								tmpAnzeigeTyp = factory.getModellobjekt(soAnzeigeTyp);
							}
						}
						setAnzeigeTyp((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeTyp
						) tmpAnzeigeTyp);
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayWvzInhalteReferenzPrioritaet = daten.getReferenceArray("WvzInhalteReferenzPrioritaet");
						for (int i = 0; i < arrayWvzInhalteReferenzPrioritaet.getLength(); ++i) {
							final long idWvzInhalteReferenzPrioritaet = daten.getReferenceArray("WvzInhalteReferenzPrioritaet").getReferenceValue(i).getId();
							final SystemObjekt tmpWvzInhalteReferenzPrioritaet;
							if (idWvzInhalteReferenzPrioritaet == 0) {
								tmpWvzInhalteReferenzPrioritaet = null;
							} else {
								final SystemObject soWvzInhalteReferenzPrioritaet = factory.getDav().getDataModel().getObject(idWvzInhalteReferenzPrioritaet);
								if (soWvzInhalteReferenzPrioritaet == null) {
										tmpWvzInhalteReferenzPrioritaet = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.WvzInhaltUngueltig(idWvzInhalteReferenzPrioritaet);
								} else {
									tmpWvzInhalteReferenzPrioritaet = factory.getModellobjekt(soWvzInhalteReferenzPrioritaet);
								}
							}
								getWvzInhalteReferenzPrioritaet().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.WvzInhalt
								) tmpWvzInhalteReferenzPrioritaet);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAnzeigeTyp(getAnzeigeTyp());
						klon._wvzInhalteReferenzPrioritaet = getWvzInhalteReferenzPrioritaet().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.anzeigeTypPriorisierung";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdAnzeigeTypPriorisierung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
