/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbedienerkommunikation.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergebnis einer Bedieneranfrage, kann von Server
					oder Visualisierung
					verändert werden.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttAnfrageErgebnis extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnfrageErgebnis ZUSTAND_1N_TIMEOUT = new AttAnfrageErgebnis("Timeout", 		Byte
	.valueOf("-1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnfrageErgebnis ZUSTAND_2N_FENSTER_GESCHLOSSEN = new AttAnfrageErgebnis("Fenster geschlossen", 		Byte
	.valueOf("-2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnfrageErgebnis ZUSTAND_3N_ABBRUCH = new AttAnfrageErgebnis("Abbruch", 		Byte
	.valueOf("-3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnfrageErgebnis ZUSTAND_4N_ABGELEHNT = new AttAnfrageErgebnis("Abgelehnt", 		Byte
	.valueOf("-4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnfrageErgebnis ZUSTAND_5N_NUTZER_NICHT_ANGEMELDET = new AttAnfrageErgebnis("Nutzer nicht angemeldet", 		Byte
	.valueOf("-5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnfrageErgebnis ZUSTAND_6N_NUTZER_BESCHAEFTIGT = new AttAnfrageErgebnis("Nutzer beschäftigt", 		Byte
	.valueOf("-6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnfrageErgebnis ZUSTAND_7N_WIEDERVORLAGE_GEFORDERT = new AttAnfrageErgebnis("Wiedervorlage gefordert", 		Byte
	.valueOf("-7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnfrageErgebnis ZUSTAND_0_ANTWORT_1 = new AttAnfrageErgebnis("Antwort 1", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnfrageErgebnis ZUSTAND_1_ANTWORT_2 = new AttAnfrageErgebnis("Antwort 2", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnfrageErgebnis ZUSTAND_2_ANTWORT_3 = new AttAnfrageErgebnis("Antwort 3", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttAnfrageErgebnis ZUSTAND_3_ANTWORT_4 = new AttAnfrageErgebnis("Antwort 4", 		Byte
	.valueOf("3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttAnfrageErgebnis getZustand(final 		Byte
	 value) {
		for (AttAnfrageErgebnis e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttAnfrageErgebnis getZustand(final String value) {
		for (AttAnfrageErgebnis e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttAnfrageErgebnis> getZustaende() {
		List<AttAnfrageErgebnis> list = new ArrayList<AttAnfrageErgebnis>();
		list.add(ZUSTAND_1N_TIMEOUT);
		list.add(ZUSTAND_2N_FENSTER_GESCHLOSSEN);
		list.add(ZUSTAND_3N_ABBRUCH);
		list.add(ZUSTAND_4N_ABGELEHNT);
		list.add(ZUSTAND_5N_NUTZER_NICHT_ANGEMELDET);
		list.add(ZUSTAND_6N_NUTZER_BESCHAEFTIGT);
		list.add(ZUSTAND_7N_WIEDERVORLAGE_GEFORDERT);
		list.add(ZUSTAND_0_ANTWORT_1);
		list.add(ZUSTAND_1_ANTWORT_2);
		list.add(ZUSTAND_2_ANTWORT_3);
		list.add(ZUSTAND_3_ANTWORT_4);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut .
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttAnfrageErgebnis(final 		Byte
	 value) {
		super(value);
	}
	
	private AttAnfrageErgebnis(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
