/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbedienerkommunikation.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
kurzinfo.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdBedienerAnfrage extends AbstractOnlineDatensatz<OdBedienerAnfrage.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.AnfrageWeiterleiten,
					Aspekte.AnfrageAntwort,
					Aspekte.AnfrageStellen,
					Aspekte.AnfrageErgebnis,
				};
			}
	
			/**
			 * Unter diesem Aspekt stellt der Server (Quelle) die
						Anfrage an die Visualisierung(en). Alle hören
						mit und vergleichen,
						ob der User der Anfrage der eingeloggte User ist.
						Ein Timeout wird
						ebenfalls hier
						bekannt gegeben, so dass die befragte Visualisierung
						das Fenster wieder
						schließen kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AnfrageWeiterleiten = new Aspekte("Anfrage weiterleiten", "asp.anfrageWeiterleiten");
			
			/**
			 * Unter diesem Aspekt versendet der Server (Quelle) die
						letztendliche Antwort an den
						ursprünglichen Frage-Applikation.
						Außerdem wird hier eine initiale Bestätigung
						versendet,
						eine
						Ablehnung, falls die Anfrage nicht weitergeleitet werden kann,
						sowie die automatisch
						bei Timeout generierte Antwort.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AnfrageAntwort = new Aspekte("Anfrageantwort", "asp.anfrageAntwort");
			
			/**
			 * Unter diesem Aspekt stellt eine Frage-Applikation
						(Sender) eine Anfrage an den Server (Senke).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AnfrageStellen = new Aspekte("Anfrage stellen", "asp.anfrageStellen");
			
			/**
			 * Unter diesem Aspekt versendet die befragte
						Visualisierung (Sender) die Antwort
						an den Server (Senke).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt AnfrageErgebnis = new Aspekte("Anfrageergebnis", "asp.anfrageErgebnis");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbedienerkommunikation.attribute.AtlBedienerAnfrage
				 _anfrage
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbedienerkommunikation.attribute.AtlBedienerAnfrage
				()
				;
		
			/**
			Beschreibt ein Kommando des
								Bedienerkommunikationsservers.
			<p>
			
			</p>
			
			@return der Wert von Anfrage.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbedienerkommunikation.attribute.AtlBedienerAnfrage
				 getAnfrage() {
				return _anfrage;
			}
		
			/**
			Beschreibt ein Kommando des
								Bedienerkommunikationsservers.
			<p>
			
			</p>
			
			@param _anfrage der neue Wert von Anfrage.
			*/
			public void setAnfrage(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlbedienerkommunikation.attribute.AtlBedienerAnfrage
			 _anfrage) {
				this._anfrage = _anfrage;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getAnfrage().bean2Atl(datum.getItem("Anfrage"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getAnfrage().atl2Bean(daten.getItem("Anfrage"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._anfrage = getAnfrage().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.bedienerAnfrage";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdBedienerAnfrage(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
