/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt ein einzelnes Ereignis.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlBcEreignis implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _uhrzeit
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.objekte.VbaEvent
			 _ereignis
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
			 _gefahrenpotenzial
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.FahrSpur
			 _fahrspur
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 _empfehlung
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.VideoView
			 _video
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlBcEreignisKommentar
			> _quittiert = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlBcEreignisKommentar
			>(1, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlBcEreignisKommentar
			> _kommentare = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlBcEreignisKommentar
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _betriebsmeldung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _id
			;
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@return der Wert von Uhrzeit.
		*/
			public 	Zeitstempel
			 getUhrzeit() {
			return _uhrzeit;
		}
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@param _uhrzeit der neue Wert von Uhrzeit.
		*/
		public void setUhrzeit(	Zeitstempel
		 _uhrzeit) {
			this._uhrzeit = _uhrzeit;
		}
	
		/**
		Verweis auf ein Objekt vom Typ typ.vbaEvent.
		<p>
		
		</p>
		
		@return der Wert von Ereignis.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.objekte.VbaEvent
			 getEreignis() {
			return _ereignis;
		}
	
		/**
		Verweis auf ein Objekt vom Typ typ.vbaEvent.
		<p>
		
		</p>
		
		@param _ereignis der neue Wert von Ereignis.
		*/
		public void setEreignis(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.objekte.VbaEvent
		 _ereignis) {
			this._ereignis = _ereignis;
		}
	
		/**
		Beschreibt ein Gefahrenpotential durch
							ein Ereignis vom Typ
							typ.vbaEvent wie z.B. "Stehen gebliebenes
							Fahrzeug" oder "Wind von
							NO".
		<p>
		
		</p>
		
		@return der Wert von Gefahrenpotenzial.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
			 getGefahrenpotenzial() {
			return _gefahrenpotenzial;
		}
	
		/**
		Beschreibt ein Gefahrenpotential durch
							ein Ereignis vom Typ
							typ.vbaEvent wie z.B. "Stehen gebliebenes
							Fahrzeug" oder "Wind von
							NO".
		<p>
		
		</p>
		
		@param _gefahrenpotenzial der neue Wert von Gefahrenpotenzial.
		*/
		public void setGefahrenpotenzial(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
		 _gefahrenpotenzial) {
			this._gefahrenpotenzial = _gefahrenpotenzial;
		}
	
		/**
		Abhängig vom Ereignistyp gilt:
								Bei Videoereignis: Die
								Fahrspur, wo es detektiert wurde
								Bei Umfeldereignis: null, es sei
								denn, die Sensoren messen
								fahrspurbezogen und teilen dies auch der
								UZ mit.
								Bei Verkehrsereignis: Die HFB der jeweiligen Fahrtrichtung.
		<p>
		
		</p>
		
		@return der Wert von Fahrspur.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.FahrSpur
			 getFahrspur() {
			return _fahrspur;
		}
	
		/**
		Abhängig vom Ereignistyp gilt:
								Bei Videoereignis: Die
								Fahrspur, wo es detektiert wurde
								Bei Umfeldereignis: null, es sei
								denn, die Sensoren messen
								fahrspurbezogen und teilen dies auch der
								UZ mit.
								Bei Verkehrsereignis: Die HFB der jeweiligen Fahrtrichtung.
		<p>
		
		</p>
		
		@param _fahrspur der neue Wert von Fahrspur.
		*/
		public void setFahrspur(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.FahrSpur
		 _fahrspur) {
			this._fahrspur = _fahrspur;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von Empfehlung.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 getEmpfehlung() {
			return _empfehlung;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@param _empfehlung der neue Wert von Empfehlung.
		*/
		public void setEmpfehlung(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
		 _empfehlung) {
			this._empfehlung = _empfehlung;
		}
	
		/**
		Zur Auswahl steht hier schlussendlich eine Kamera. Welche
								Kamera angezeigt wird, wird durch die Kombination aus Steuermodul
								und
								Fahrspur (d.h. eigentlich Fahrtrichtung) bestimmt.
								Abhängig vom
								Ereignistyp gilt:
								Bei Videoereignis: Kamera kann direkt über
								Ereignis bestimmt werden
								Bei Umfeldereignis: Eine zufällige Kamera
								an dem Steuermodul.
								Bei Verkehrsereignis: Bestimmung aus
								Steuermodul und Fahrtrichtung.
		<p>
		
		</p>
		
		@return der Wert von Video.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.VideoView
			 getVideo() {
			return _video;
		}
	
		/**
		Zur Auswahl steht hier schlussendlich eine Kamera. Welche
								Kamera angezeigt wird, wird durch die Kombination aus Steuermodul
								und
								Fahrspur (d.h. eigentlich Fahrtrichtung) bestimmt.
								Abhängig vom
								Ereignistyp gilt:
								Bei Videoereignis: Kamera kann direkt über
								Ereignis bestimmt werden
								Bei Umfeldereignis: Eine zufällige Kamera
								an dem Steuermodul.
								Bei Verkehrsereignis: Bestimmung aus
								Steuermodul und Fahrtrichtung.
		<p>
		
		</p>
		
		@param _video der neue Wert von Video.
		*/
		public void setVideo(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.VideoView
		 _video) {
			this._video = _video;
		}
	
		/**
		Beschreibt einnen Kommentar zu einem Ereignis.
		<p>
		
		</p>
		
		@return der Wert von Quittiert.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlBcEreignisKommentar
			> getQuittiert() {
			return _quittiert;
		}
	
	
		/**
		Beschreibt einnen Kommentar zu einem Ereignis.
		<p>
		
		</p>
		
		@return der Wert von Kommentare.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlBcEreignisKommentar
			> getKommentare() {
			return _kommentare;
		}
	
	
		/**
		Die interne ID der Betriebsmeldungsverwaltung, die die
								Meldung identifiziert,
								welche mit diesem Ereignis korrespondiert.
		<p>
		
		</p>
		
		@return der Wert von Betriebsmeldung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getBetriebsmeldung() {
			return _betriebsmeldung;
		}
	
		/**
		Die interne ID der Betriebsmeldungsverwaltung, die die
								Meldung identifiziert,
								welche mit diesem Ereignis korrespondiert.
		<p>
		
		</p>
		
		@param _betriebsmeldung der neue Wert von Betriebsmeldung.
		*/
		public void setBetriebsmeldung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _betriebsmeldung) {
			this._betriebsmeldung = _betriebsmeldung;
		}
	
		/**
		Die interne ID des Ereignisses selbst (wird vom Empfehler
								gebildet, wenn das Ereignisobjet erzeugt wird). Über diese Id
								werden die
								Ereignisse identifiziert, um sie zu quittieren, zu
								kommentieren oder
								zurückzusetzen (siehe
								att.bcEmpfehlerKommandoTyp).
		<p>
		
		</p>
		
		@return der Wert von Id.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getId() {
			return _id;
		}
	
		/**
		Die interne ID des Ereignisses selbst (wird vom Empfehler
								gebildet, wenn das Ereignisobjet erzeugt wird). Über diese Id
								werden die
								Ereignisse identifiziert, um sie zu quittieren, zu
								kommentieren oder
								zurückzusetzen (siehe
								att.bcEmpfehlerKommandoTyp).
		<p>
		
		</p>
		
		@param _id der neue Wert von Id.
		*/
		public void setId(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _id) {
			this._id = _id;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Uhrzeit").setMillis(getUhrzeit().getTime());
				// ObjektReferenzAttributTyp
					final Object soEreignis = getEreignis();
					final SystemObject tmpEreignis;
						if (soEreignis instanceof SystemObject) {
							tmpEreignis = (SystemObject)soEreignis;
						} else if(soEreignis instanceof SystemObjekt){
							tmpEreignis = ((SystemObjekt)soEreignis).getSystemObject();
						} else{
							tmpEreignis = null;
						}
					datum.getReferenceValue("Ereignis").setSystemObject(tmpEreignis);
				// GanzzahlAttributTyp
				if (getGefahrenpotenzial() != null) {
	                if (getGefahrenpotenzial().isZustand()) {
	                    datum.getUnscaledValue("Gefahrenpotenzial").setText(getGefahrenpotenzial().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Gefahrenpotenzial").set(getGefahrenpotenzial().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soFahrspur = getFahrspur();
					final SystemObject tmpFahrspur;
						if (soFahrspur instanceof SystemObject) {
							tmpFahrspur = (SystemObject)soFahrspur;
						} else if(soFahrspur instanceof SystemObjekt){
							tmpFahrspur = ((SystemObjekt)soFahrspur).getSystemObject();
						} else{
							tmpFahrspur = null;
						}
					datum.getReferenceValue("Fahrspur").setSystemObject(tmpFahrspur);
				// ObjektReferenzAttributTyp
					final Object soEmpfehlung = getEmpfehlung();
					final SystemObject tmpEmpfehlung;
						if (soEmpfehlung instanceof SystemObject) {
							tmpEmpfehlung = (SystemObject)soEmpfehlung;
						} else if(soEmpfehlung instanceof SystemObjekt){
							tmpEmpfehlung = ((SystemObjekt)soEmpfehlung).getSystemObject();
						} else{
							tmpEmpfehlung = null;
						}
					datum.getReferenceValue("Empfehlung").setSystemObject(tmpEmpfehlung);
				// ObjektReferenzAttributTyp
					final Object soVideo = getVideo();
					final SystemObject tmpVideo;
						if (soVideo instanceof SystemObject) {
							tmpVideo = (SystemObject)soVideo;
						} else if(soVideo instanceof SystemObjekt){
							tmpVideo = ((SystemObjekt)soVideo).getSystemObject();
						} else{
							tmpVideo = null;
						}
					datum.getReferenceValue("Video").setSystemObject(tmpVideo);
				// AttributListenDefinition
					final Data.Array arrayQuittiert = datum.getArray("Quittiert");
					arrayQuittiert.setLength(getQuittiert().size());
					for (int i = 0; i < arrayQuittiert.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlBcEreignisKommentar
						 atl = getQuittiert().get(i);
						atl.bean2Atl(arrayQuittiert.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayKommentare = datum.getArray("Kommentare");
					arrayKommentare.setLength(getKommentare().size());
					for (int i = 0; i < arrayKommentare.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlBcEreignisKommentar
						 atl = getKommentare().get(i);
						atl.bean2Atl(arrayKommentare.getItem(i), factory);
	
					}
				// GanzzahlAttributTyp
				if (getBetriebsmeldung() != null) {
	                if (getBetriebsmeldung().isZustand()) {
	                    datum.getUnscaledValue("Betriebsmeldung").setText(getBetriebsmeldung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Betriebsmeldung").set(getBetriebsmeldung().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getId() != null) {
	                if (getId().isZustand()) {
	                    datum.getUnscaledValue("Id").setText(getId().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Id").set(getId().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setUhrzeit(new
						Zeitstempel
						(daten.getTimeValue("Uhrzeit").getMillis()));
				// ObjektReferenzAttributTyp
					final long idEreignis = daten.getReferenceValue("Ereignis").getId();
					final SystemObjekt tmpEreignis;
					if (idEreignis == 0) {
						tmpEreignis = null;
					} else {
						final SystemObject soEreignis = factory.getDav().getDataModel().getObject(idEreignis);
						if (soEreignis == null) {
								tmpEreignis = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.objekte.impl.VbaEventUngueltig(idEreignis);
						} else {
							tmpEreignis = factory.getModellobjekt(soEreignis);
						}
					}
					setEreignis((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.objekte.VbaEvent
					) tmpEreignis);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Gefahrenpotenzial").isState()) {
							setGefahrenpotenzial(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
							.getZustand(daten.getScaledValue("Gefahrenpotenzial").getText()));
						} else {
						setGefahrenpotenzial(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
						(daten.
							getUnscaledValue
						("Gefahrenpotenzial").
								shortValue
						()));
						}
				// ObjektReferenzAttributTyp
					final long idFahrspur = daten.getReferenceValue("Fahrspur").getId();
					final SystemObjekt tmpFahrspur;
					if (idFahrspur == 0) {
						tmpFahrspur = null;
					} else {
						final SystemObject soFahrspur = factory.getDav().getDataModel().getObject(idFahrspur);
						if (soFahrspur == null) {
								tmpFahrspur = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.impl.FahrSpurUngueltig(idFahrspur);
						} else {
							tmpFahrspur = factory.getModellobjekt(soFahrspur);
						}
					}
					setFahrspur((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlanzeigen.objekte.FahrSpur
					) tmpFahrspur);
				// ObjektReferenzAttributTyp
					final long idEmpfehlung = daten.getReferenceValue("Empfehlung").getId();
					final SystemObjekt tmpEmpfehlung;
					if (idEmpfehlung == 0) {
						tmpEmpfehlung = null;
					} else {
						final SystemObject soEmpfehlung = factory.getDav().getDataModel().getObject(idEmpfehlung);
						if (soEmpfehlung == null) {
								tmpEmpfehlung = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idEmpfehlung);
						} else {
							tmpEmpfehlung = factory.getModellobjekt(soEmpfehlung);
						}
					}
					setEmpfehlung((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
					) tmpEmpfehlung);
				// ObjektReferenzAttributTyp
					final long idVideo = daten.getReferenceValue("Video").getId();
					final SystemObjekt tmpVideo;
					if (idVideo == 0) {
						tmpVideo = null;
					} else {
						final SystemObject soVideo = factory.getDav().getDataModel().getObject(idVideo);
						if (soVideo == null) {
								tmpVideo = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.impl.VideoViewUngueltig(idVideo);
						} else {
							tmpVideo = factory.getModellobjekt(soVideo);
						}
					}
					setVideo((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.VideoView
					) tmpVideo);
				// AttributListenDefinition
					final Data.Array arrayQuittiert = daten.getArray("Quittiert");
					for (int i = 0; i < arrayQuittiert.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlBcEreignisKommentar
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlBcEreignisKommentar
						 ();
						atl.atl2Bean(arrayQuittiert.getItem(i), factory);
						getQuittiert().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayKommentare = daten.getArray("Kommentare");
					for (int i = 0; i < arrayKommentare.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlBcEreignisKommentar
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlBcEreignisKommentar
						 ();
						atl.atl2Bean(arrayKommentare.getItem(i), factory);
						getKommentare().add(atl);
					}
				// GanzzahlAttributTyp
						setBetriebsmeldung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Betriebsmeldung").
								longValue
						()));
				// GanzzahlAttributTyp
						setId(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Id").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBcEreignis clone() {
		AtlBcEreignis klon = new AtlBcEreignis();
		
						klon.setUhrzeit(getUhrzeit());
						klon.setEreignis(getEreignis());
						klon.setGefahrenpotenzial(getGefahrenpotenzial());
						klon.setFahrspur(getFahrspur());
						klon.setEmpfehlung(getEmpfehlung());
						klon.setVideo(getVideo());
					klon._quittiert = getQuittiert().clone();
					klon._kommentare = getKommentare().clone();
						klon.setBetriebsmeldung(getBetriebsmeldung());
						klon.setId(getId());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
