/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt einnen Kommentar zu einem Ereignis.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlBcEreignisKommentar implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _uhrzeit
			;
			private String
			 _nutzer
			= new String
			()
			;
			private String
			 _kommentar
			= new String
			()
			;
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@return der Wert von Uhrzeit.
		*/
			public 	Zeitstempel
			 getUhrzeit() {
			return _uhrzeit;
		}
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@param _uhrzeit der neue Wert von Uhrzeit.
		*/
		public void setUhrzeit(	Zeitstempel
		 _uhrzeit) {
			this._uhrzeit = _uhrzeit;
		}
	
		/**
		Hier steht die Id (=Login-Name) des Nutzers
								drin, der die
								Meldung kommentiert hat. Wir benutzen hier keine
								UserReferenz,
								weil
								das für historische Auswertungen schlecht ist. Wenn der Text
								leer
								ist, dann gilt das Ereignis als nicht kommentiert.
		<p>
		
		</p>
		
		@return der Wert von Nutzer.
		*/
			public String
			 getNutzer() {
			return _nutzer;
		}
	
		/**
		Hier steht die Id (=Login-Name) des Nutzers
								drin, der die
								Meldung kommentiert hat. Wir benutzen hier keine
								UserReferenz,
								weil
								das für historische Auswertungen schlecht ist. Wenn der Text
								leer
								ist, dann gilt das Ereignis als nicht kommentiert.
		<p>
		
		</p>
		
		@param _nutzer der neue Wert von Nutzer.
		*/
		public void setNutzer(String
		 _nutzer) {
			if (_nutzer.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._nutzer = _nutzer;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Kommentar.
		*/
			public String
			 getKommentar() {
			return _kommentar;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _kommentar der neue Wert von Kommentar.
		*/
		public void setKommentar(String
		 _kommentar) {
			if (_kommentar.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._kommentar = _kommentar;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Uhrzeit").setMillis(getUhrzeit().getTime());
				// ZeichenkettenAttributTyp
				if (getNutzer() != null) {
					datum.getTextValue("Nutzer").setText(getNutzer());
				}
				// ZeichenkettenAttributTyp
				if (getKommentar() != null) {
					datum.getTextValue("Kommentar").setText(getKommentar());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setUhrzeit(new
						Zeitstempel
						(daten.getTimeValue("Uhrzeit").getMillis()));
				// ZeichenkettenAttributTyp
					setNutzer(daten.getTextValue("Nutzer").getText());
				// ZeichenkettenAttributTyp
					setKommentar(daten.getTextValue("Kommentar").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBcEreignisKommentar clone() {
		AtlBcEreignisKommentar klon = new AtlBcEreignisKommentar();
		
						klon.setUhrzeit(getUhrzeit());
						klon.setNutzer(getNutzer());
						klon.setKommentar(getKommentar());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
