/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt die Parameter eines einzelnen
					Umfelddatensensortyps.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlParameterUfdsTypen implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 _umfelddatenSensorTyp
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttFloat_JavaKeyword
			 _wertPotenzialKeines
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
			 _gefahrenpotenzialMax
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttFloat_JavaKeyword
			 _wertPotenzialMax
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
			 _teilschwellwert
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _beruecksichtigen
			;
	
		/**
		Attribut zur Referenzierung von Objekttypen.
		<p>
		
		</p>
		
		@return der Wert von UmfelddatenSensorTyp.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 getUmfelddatenSensorTyp() {
			return _umfelddatenSensorTyp;
		}
	
		/**
		Attribut zur Referenzierung von Objekttypen.
		<p>
		
		</p>
		
		@param _umfelddatenSensorTyp der neue Wert von UmfelddatenSensorTyp.
		*/
		public void setUmfelddatenSensorTyp(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
		 _umfelddatenSensorTyp) {
			this._umfelddatenSensorTyp = _umfelddatenSensorTyp;
		}
	
		/**
		Float-Wert mit zwei Nachkommastellen im Bereich
							-21474836.48 bis +21474836.47 (32 Bit INT MAX um zwei Kommastellen
							skaliert).
		<p>
		
		</p>
		
		@return der Wert von WertPotenzialKeines.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttFloat_JavaKeyword
			 getWertPotenzialKeines() {
			return _wertPotenzialKeines;
		}
	
		/**
		Float-Wert mit zwei Nachkommastellen im Bereich
							-21474836.48 bis +21474836.47 (32 Bit INT MAX um zwei Kommastellen
							skaliert).
		<p>
		
		</p>
		
		@param _wertPotenzialKeines der neue Wert von WertPotenzialKeines.
		*/
		public void setWertPotenzialKeines(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttFloat_JavaKeyword
		 _wertPotenzialKeines) {
			this._wertPotenzialKeines = _wertPotenzialKeines;
		}
	
		/**
		Beschreibt ein Gefahrenpotential durch
							ein Ereignis vom Typ
							typ.vbaEvent wie z.B. "Stehen gebliebenes
							Fahrzeug" oder "Wind von
							NO".
		<p>
		
		</p>
		
		@return der Wert von GefahrenpotenzialMax.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
			 getGefahrenpotenzialMax() {
			return _gefahrenpotenzialMax;
		}
	
		/**
		Beschreibt ein Gefahrenpotential durch
							ein Ereignis vom Typ
							typ.vbaEvent wie z.B. "Stehen gebliebenes
							Fahrzeug" oder "Wind von
							NO".
		<p>
		
		</p>
		
		@param _gefahrenpotenzialMax der neue Wert von GefahrenpotenzialMax.
		*/
		public void setGefahrenpotenzialMax(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
		 _gefahrenpotenzialMax) {
			this._gefahrenpotenzialMax = _gefahrenpotenzialMax;
		}
	
		/**
		Float-Wert mit zwei Nachkommastellen im Bereich
							-21474836.48 bis +21474836.47 (32 Bit INT MAX um zwei Kommastellen
							skaliert).
		<p>
		
		</p>
		
		@return der Wert von WertPotenzialMax.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttFloat_JavaKeyword
			 getWertPotenzialMax() {
			return _wertPotenzialMax;
		}
	
		/**
		Float-Wert mit zwei Nachkommastellen im Bereich
							-21474836.48 bis +21474836.47 (32 Bit INT MAX um zwei Kommastellen
							skaliert).
		<p>
		
		</p>
		
		@param _wertPotenzialMax der neue Wert von WertPotenzialMax.
		*/
		public void setWertPotenzialMax(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttFloat_JavaKeyword
		 _wertPotenzialMax) {
			this._wertPotenzialMax = _wertPotenzialMax;
		}
	
		/**
		Beschreibt ein Gefahrenpotential durch
							ein Ereignis vom Typ
							typ.vbaEvent wie z.B. "Stehen gebliebenes
							Fahrzeug" oder "Wind von
							NO".
		<p>
		
		</p>
		
		@return der Wert von Teilschwellwert.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
			 getTeilschwellwert() {
			return _teilschwellwert;
		}
	
		/**
		Beschreibt ein Gefahrenpotential durch
							ein Ereignis vom Typ
							typ.vbaEvent wie z.B. "Stehen gebliebenes
							Fahrzeug" oder "Wind von
							NO".
		<p>
		
		</p>
		
		@param _teilschwellwert der neue Wert von Teilschwellwert.
		*/
		public void setTeilschwellwert(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
		 _teilschwellwert) {
			this._teilschwellwert = _teilschwellwert;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von Beruecksichtigen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getBeruecksichtigen() {
			return _beruecksichtigen;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _beruecksichtigen der neue Wert von Beruecksichtigen.
		*/
		public void setBeruecksichtigen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _beruecksichtigen) {
			this._beruecksichtigen = _beruecksichtigen;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soUmfelddatenSensorTyp = getUmfelddatenSensorTyp();
					final SystemObject tmpUmfelddatenSensorTyp;
						if (soUmfelddatenSensorTyp instanceof SystemObject) {
							tmpUmfelddatenSensorTyp = (SystemObject)soUmfelddatenSensorTyp;
						} else if(soUmfelddatenSensorTyp instanceof SystemObjekt){
							tmpUmfelddatenSensorTyp = ((SystemObjekt)soUmfelddatenSensorTyp).getSystemObject();
						} else{
							tmpUmfelddatenSensorTyp = null;
						}
					datum.getReferenceValue("UmfelddatenSensorTyp").setSystemObject(tmpUmfelddatenSensorTyp);
				// GanzzahlAttributTyp
				if (getWertPotenzialKeines() != null) {
	                if (getWertPotenzialKeines().isZustand()) {
	                    datum.getUnscaledValue("WertPotenzialKeines").setText(getWertPotenzialKeines().toString());
	                } else {
						datum.
						getScaledValue
	                	("WertPotenzialKeines").set(getWertPotenzialKeines().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGefahrenpotenzialMax() != null) {
	                if (getGefahrenpotenzialMax().isZustand()) {
	                    datum.getUnscaledValue("GefahrenpotenzialMax").setText(getGefahrenpotenzialMax().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("GefahrenpotenzialMax").set(getGefahrenpotenzialMax().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getWertPotenzialMax() != null) {
	                if (getWertPotenzialMax().isZustand()) {
	                    datum.getUnscaledValue("WertPotenzialMax").setText(getWertPotenzialMax().toString());
	                } else {
						datum.
						getScaledValue
	                	("WertPotenzialMax").set(getWertPotenzialMax().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getTeilschwellwert() != null) {
	                if (getTeilschwellwert().isZustand()) {
	                    datum.getUnscaledValue("Teilschwellwert").setText(getTeilschwellwert().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Teilschwellwert").set(getTeilschwellwert().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getBeruecksichtigen() != null) {
	                if (getBeruecksichtigen().isZustand()) {
	                    datum.getUnscaledValue("Berücksichtigen").setText(getBeruecksichtigen().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Berücksichtigen").set(getBeruecksichtigen().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idUmfelddatenSensorTyp = daten.getReferenceValue("UmfelddatenSensorTyp").getId();
					final SystemObjekt tmpUmfelddatenSensorTyp;
					if (idUmfelddatenSensorTyp == 0) {
						tmpUmfelddatenSensorTyp = null;
					} else {
						final SystemObject soUmfelddatenSensorTyp = factory.getDav().getDataModel().getObject(idUmfelddatenSensorTyp);
						if (soUmfelddatenSensorTyp == null) {
								tmpUmfelddatenSensorTyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.TypUngueltig(idUmfelddatenSensorTyp);
						} else {
							tmpUmfelddatenSensorTyp = factory.getModellobjekt(soUmfelddatenSensorTyp);
						}
					}
					setUmfelddatenSensorTyp((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
					) tmpUmfelddatenSensorTyp);
				// GanzzahlAttributTyp
						setWertPotenzialKeines(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttFloat_JavaKeyword
						(daten.
							getScaledValue
						("WertPotenzialKeines").
							doubleValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("GefahrenpotenzialMax").isState()) {
							setGefahrenpotenzialMax(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
							.getZustand(daten.getScaledValue("GefahrenpotenzialMax").getText()));
						} else {
						setGefahrenpotenzialMax(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
						(daten.
							getUnscaledValue
						("GefahrenpotenzialMax").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						setWertPotenzialMax(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AttFloat_JavaKeyword
						(daten.
							getScaledValue
						("WertPotenzialMax").
							doubleValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Teilschwellwert").isState()) {
							setTeilschwellwert(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
							.getZustand(daten.getScaledValue("Teilschwellwert").getText()));
						} else {
						setTeilschwellwert(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
						(daten.
							getUnscaledValue
						("Teilschwellwert").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Berücksichtigen").isState()) {
							setBeruecksichtigen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Berücksichtigen").getText()));
						} else {
						setBeruecksichtigen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Berücksichtigen").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlParameterUfdsTypen clone() {
		AtlParameterUfdsTypen klon = new AtlParameterUfdsTypen();
		
						klon.setUmfelddatenSensorTyp(getUmfelddatenSensorTyp());
						klon.setWertPotenzialKeines(getWertPotenzialKeines());
						klon.setGefahrenpotenzialMax(getGefahrenpotenzialMax());
						klon.setWertPotenzialMax(getWertPotenzialMax());
						klon.setTeilschwellwert(getTeilschwellwert());
						klon.setBeruecksichtigen(getBeruecksichtigen());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
