/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt ein SBA-Automatikprogramm (ein reguläres
					Schaltprogramm der Gruppe
					Streckenbeeinflussung) und zusätzliche
					Attribute, die für eine vollautomatische Steuerung
					gebraucht werden
					(z.B. Mindeststandzeit).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlSbaAutomatikProgrammDefinition implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 _programm
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
			 _mindesstandzeit
			;
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von Programm.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 getProgramm() {
			return _programm;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@param _programm der neue Wert von Programm.
		*/
		public void setProgramm(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
		 _programm) {
			this._programm = _programm;
		}
	
		/**
		Angabe einer Zeitdauer in Minuten.
		<p>
		
		</p>
		
		@return der Wert von Mindesstandzeit.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
			 getMindesstandzeit() {
			return _mindesstandzeit;
		}
	
		/**
		Angabe einer Zeitdauer in Minuten.
		<p>
		
		</p>
		
		@param _mindesstandzeit der neue Wert von Mindesstandzeit.
		*/
		public void setMindesstandzeit(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
		 _mindesstandzeit) {
			this._mindesstandzeit = _mindesstandzeit;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soProgramm = getProgramm();
					final SystemObject tmpProgramm;
						if (soProgramm instanceof SystemObject) {
							tmpProgramm = (SystemObject)soProgramm;
						} else if(soProgramm instanceof SystemObjekt){
							tmpProgramm = ((SystemObjekt)soProgramm).getSystemObject();
						} else{
							tmpProgramm = null;
						}
					datum.getReferenceValue("Programm").setSystemObject(tmpProgramm);
				// GanzzahlAttributTyp
				if (getMindesstandzeit() != null) {
	                if (getMindesstandzeit().isZustand()) {
	                    datum.getUnscaledValue("Mindesstandzeit").setText(getMindesstandzeit().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Mindesstandzeit").set(getMindesstandzeit().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idProgramm = daten.getReferenceValue("Programm").getId();
					final SystemObjekt tmpProgramm;
					if (idProgramm == 0) {
						tmpProgramm = null;
					} else {
						final SystemObject soProgramm = factory.getDav().getDataModel().getObject(idProgramm);
						if (soProgramm == null) {
								tmpProgramm = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idProgramm);
						} else {
							tmpProgramm = factory.getModellobjekt(soProgramm);
						}
					}
					setProgramm((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
					) tmpProgramm);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Mindesstandzeit").isState()) {
							setMindesstandzeit(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
							.getZustand(daten.getScaledValue("Mindesstandzeit").getText()));
						} else {
						setMindesstandzeit(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZeitDauerMinuten
						(daten.
							getUnscaledValue
						("Mindesstandzeit").
								longValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlSbaAutomatikProgrammDefinition clone() {
		AtlSbaAutomatikProgrammDefinition klon = new AtlSbaAutomatikProgrammDefinition();
		
						klon.setProgramm(getProgramm());
						klon.setMindesstandzeit(getMindesstandzeit());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
