/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt einen Eintrag in der Tabelle
					atl.vbaEventKombination.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlVbaEventKombinationsZeile implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			> _werte = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			>(0, true);
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 _empfehlung
			;
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von Werte.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			> getWerte() {
			return _werte;
		}
	
	
		/**
		Info.
		<p>
		
		</p>
		
		@return der Wert von Empfehlung.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 getEmpfehlung() {
			return _empfehlung;
		}
	
		/**
		Info.
		<p>
		
		</p>
		
		@param _empfehlung der neue Wert von Empfehlung.
		*/
		public void setEmpfehlung(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
		 _empfehlung) {
			this._empfehlung = _empfehlung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getWerte() != null) {
					final Data.NumberArray arrayWerte = datum.
						getUnscaledArray
						("Werte");
					arrayWerte.setLength(getWerte().size());
					for (int i = 0; i < arrayWerte.getLength(); ++i) {
						arrayWerte.getValue(i).set(getWerte().get(i).getValue());
					}
				}
				// ObjektReferenzAttributTyp
					final Object soEmpfehlung = getEmpfehlung();
					final SystemObject tmpEmpfehlung;
						if (soEmpfehlung instanceof SystemObject) {
							tmpEmpfehlung = (SystemObject)soEmpfehlung;
						} else if(soEmpfehlung instanceof SystemObjekt){
							tmpEmpfehlung = ((SystemObjekt)soEmpfehlung).getSystemObject();
						} else{
							tmpEmpfehlung = null;
						}
					datum.getReferenceValue("Empfehlung").setSystemObject(tmpEmpfehlung);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
					final Data.NumberArray arrayWerte = daten.
						getUnscaledArray
					("Werte");
	
					for (int i = 0; i < arrayWerte.getLength(); ++i) {
	                    if (arrayWerte.getValue(i).isState()) {
	                        getWerte().add(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
	                        .getZustand(arrayWerte.getValue(i).getState().getName()));
	                    } else {
	                    getWerte().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
	                    (arrayWerte.
	                    		byteValue
	                    (i)));
	                    }
	                }
				// ObjektReferenzAttributTyp
					final long idEmpfehlung = daten.getReferenceValue("Empfehlung").getId();
					final SystemObjekt tmpEmpfehlung;
					if (idEmpfehlung == 0) {
						tmpEmpfehlung = null;
					} else {
						final SystemObject soEmpfehlung = factory.getDav().getDataModel().getObject(idEmpfehlung);
						if (soEmpfehlung == null) {
								tmpEmpfehlung = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idEmpfehlung);
						} else {
							tmpEmpfehlung = factory.getModellobjekt(soEmpfehlung);
						}
					}
					setEmpfehlung((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
					) tmpEmpfehlung);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlVbaEventKombinationsZeile clone() {
		AtlVbaEventKombinationsZeile klon = new AtlVbaEventKombinationsZeile();
		
					klon._werte = getWerte().clone();
						klon.setEmpfehlung(getEmpfehlung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
