/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Eintrag in der Zuordnungsmatrix für die Bewertung der
					Windgeschwindigkeit in Sektoren.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlVbaEventUfdWindSektorEintrag implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindGeschwindigkeitMittelWert
			 _bisGeschwindigkeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
			 _gefahrenPotenzial
			;
	
		/**
		Windgeschwindigkeit (Mittel).
		<p>
		Geschwindigkeit des Windes in horizontaler Ebene (Komponente) in Meter pro Sekunde. Windgeschwindigkeit (Mittel) wird als vektorieller Mittelwert über ein gleitendes Zeitintervall von 10 Minuten ermittelt. Bei gleichzeitiger Messung der Windrichtung sind die Sensoren an der gleichen Stelle zu platzieren.
		</p>
		
		@return der Wert von BisGeschwindigkeit.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindGeschwindigkeitMittelWert
			 getBisGeschwindigkeit() {
			return _bisGeschwindigkeit;
		}
	
		/**
		Windgeschwindigkeit (Mittel).
		<p>
		Geschwindigkeit des Windes in horizontaler Ebene (Komponente) in Meter pro Sekunde. Windgeschwindigkeit (Mittel) wird als vektorieller Mittelwert über ein gleitendes Zeitintervall von 10 Minuten ermittelt. Bei gleichzeitiger Messung der Windrichtung sind die Sensoren an der gleichen Stelle zu platzieren.
		</p>
		
		@param _bisGeschwindigkeit der neue Wert von BisGeschwindigkeit.
		*/
		public void setBisGeschwindigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindGeschwindigkeitMittelWert
		 _bisGeschwindigkeit) {
			this._bisGeschwindigkeit = _bisGeschwindigkeit;
		}
	
		/**
		Beschreibt ein Gefahrenpotential durch
							ein Ereignis vom Typ
							typ.vbaEvent wie z.B. "Stehen gebliebenes
							Fahrzeug" oder "Wind von
							NO".
		<p>
		
		</p>
		
		@return der Wert von GefahrenPotenzial.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
			 getGefahrenPotenzial() {
			return _gefahrenPotenzial;
		}
	
		/**
		Beschreibt ein Gefahrenpotential durch
							ein Ereignis vom Typ
							typ.vbaEvent wie z.B. "Stehen gebliebenes
							Fahrzeug" oder "Wind von
							NO".
		<p>
		
		</p>
		
		@param _gefahrenPotenzial der neue Wert von GefahrenPotenzial.
		*/
		public void setGefahrenPotenzial(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
		 _gefahrenPotenzial) {
			this._gefahrenPotenzial = _gefahrenPotenzial;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getBisGeschwindigkeit() != null) {
	                if (getBisGeschwindigkeit().isZustand()) {
	                    datum.getUnscaledValue("BisGeschwindigkeit").setText(getBisGeschwindigkeit().toString());
	                } else {
						datum.
						getScaledValue
	                	("BisGeschwindigkeit").set(getBisGeschwindigkeit().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getGefahrenPotenzial() != null) {
	                if (getGefahrenPotenzial().isZustand()) {
	                    datum.getUnscaledValue("GefahrenPotenzial").setText(getGefahrenPotenzial().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("GefahrenPotenzial").set(getGefahrenPotenzial().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("BisGeschwindigkeit").isState()) {
							setBisGeschwindigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindGeschwindigkeitMittelWert
							.getZustand(daten.getScaledValue("BisGeschwindigkeit").getText()));
						} else {
						setBisGeschwindigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsWindGeschwindigkeitMittelWert
						(daten.
							getScaledValue
						("BisGeschwindigkeit").
							doubleValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("GefahrenPotenzial").isState()) {
							setGefahrenPotenzial(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
							.getZustand(daten.getScaledValue("GefahrenPotenzial").getText()));
						} else {
						setGefahrenPotenzial(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
						(daten.
							getUnscaledValue
						("GefahrenPotenzial").
								shortValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlVbaEventUfdWindSektorEintrag clone() {
		AtlVbaEventUfdWindSektorEintrag klon = new AtlVbaEventUfdWindSektorEintrag();
		
						klon.setBisGeschwindigkeit(getBisGeschwindigkeit());
						klon.setGefahrenPotenzial(getGefahrenPotenzial());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
