/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt ein Gefahrenpotential durch
					ein Ereignis vom Typ
					typ.vbaEvent wie z.B. "Stehen gebliebenes
					Fahrzeug" oder "Wind von
					NO".
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = -1L,
	maximum = 32767L,
	einheit = "Punkte"
)
public class AttBcGefahrenPotenzial extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MIN_VALUE =
				Short
		.valueOf("-1");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MAX_VALUE =
				Short
		.valueOf("32767");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "Punkte";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcGefahrenPotenzial ZUSTAND_1N_UNBEKANNT = new AttBcGefahrenPotenzial("Unbekannt", 		Short
	.valueOf("-1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcGefahrenPotenzial ZUSTAND_1_KEINES = new AttBcGefahrenPotenzial("Keines", 		Short
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcGefahrenPotenzial ZUSTAND_10_NIEDRIG = new AttBcGefahrenPotenzial("Niedrig", 		Short
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcGefahrenPotenzial ZUSTAND_50_GERING = new AttBcGefahrenPotenzial("Gering", 		Short
	.valueOf("50"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcGefahrenPotenzial ZUSTAND_200_MITTEL = new AttBcGefahrenPotenzial("Mittel", 		Short
	.valueOf("200"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcGefahrenPotenzial ZUSTAND_300_HOCH = new AttBcGefahrenPotenzial("Hoch", 		Short
	.valueOf("300"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcGefahrenPotenzial ZUSTAND_400_SEHR_HOCH = new AttBcGefahrenPotenzial("Sehr Hoch", 		Short
	.valueOf("400"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttBcGefahrenPotenzial ZUSTAND_600_KATASTROPHE = new AttBcGefahrenPotenzial("Katastrophe", 		Short
	.valueOf("600"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttBcGefahrenPotenzial getZustand(final 		Short
	 value) {
		for (AttBcGefahrenPotenzial e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttBcGefahrenPotenzial getZustand(final String value) {
		for (AttBcGefahrenPotenzial e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttBcGefahrenPotenzial> getZustaende() {
		List<AttBcGefahrenPotenzial> list = new ArrayList<AttBcGefahrenPotenzial>();
		list.add(ZUSTAND_1N_UNBEKANNT);
		list.add(ZUSTAND_1_KEINES);
		list.add(ZUSTAND_10_NIEDRIG);
		list.add(ZUSTAND_50_GERING);
		list.add(ZUSTAND_200_MITTEL);
		list.add(ZUSTAND_300_HOCH);
		list.add(ZUSTAND_400_SEHR_HOCH);
		list.add(ZUSTAND_600_KATASTROPHE);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut .
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttBcGefahrenPotenzial(final 		Short
	 value) {
		super(value);
	}
	
	private AttBcGefahrenPotenzial(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
