/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Bestimmt den verkehrsspezifischen Teil des Objekts.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdVbaEventVerkehr extends AbstractKonfigurationsDatensatz<KdVbaEventVerkehr.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttVerkehrsEreignisTyp
				 _typ
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.Kamera
				 _kamera
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlverkehrsmodell.objekte.AeusseresStrassenSegmentPrognose
				 _strassenSegment
				;
		
			/**
			Beschreibt die Art eines Verkehrsereignisses
								(z.B.
								"Überlast").
			<p>
			
			</p>
			
			@return der Wert von Typ.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttVerkehrsEreignisTyp
				 getTyp() {
				return _typ;
			}
		
			/**
			Beschreibt die Art eines Verkehrsereignisses
								(z.B.
								"Überlast").
			<p>
			
			</p>
			
			@param _typ der neue Wert von Typ.
			*/
			public void setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttVerkehrsEreignisTyp
			 _typ) {
				this._typ = _typ;
			}
		
			/**
			Referenz auf ein Objekt vom Typ "typ.kamera".
			<p>
			
			</p>
			
			@return der Wert von Kamera.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.Kamera
				 getKamera() {
				return _kamera;
			}
		
			/**
			Referenz auf ein Objekt vom Typ "typ.kamera".
			<p>
			
			</p>
			
			@param _kamera der neue Wert von Kamera.
			*/
			public void setKamera(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.Kamera
			 _kamera) {
				this._kamera = _kamera;
			}
		
			/**
			Verweis auf ein Objekt vom Typ typ.äußeresStraßenSegmentPrognose.
			<p>
			
			</p>
			
			@return der Wert von StrassenSegment.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlverkehrsmodell.objekte.AeusseresStrassenSegmentPrognose
				 getStrassenSegment() {
				return _strassenSegment;
			}
		
			/**
			Verweis auf ein Objekt vom Typ typ.äußeresStraßenSegmentPrognose.
			<p>
			
			</p>
			
			@param _strassenSegment der neue Wert von StrassenSegment.
			*/
			public void setStrassenSegment(	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlverkehrsmodell.objekte.AeusseresStrassenSegmentPrognose
			 _strassenSegment) {
				this._strassenSegment = _strassenSegment;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getTyp() != null) {
		                if (getTyp().isZustand()) {
		                    datum.getUnscaledValue("Typ").setText(getTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Typ").set(getTyp().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Object soKamera = getKamera();
						final SystemObject tmpKamera;
							if (soKamera instanceof SystemObject) {
								tmpKamera = (SystemObject)soKamera;
							} else if(soKamera instanceof SystemObjekt){
								tmpKamera = ((SystemObjekt)soKamera).getSystemObject();
							} else{
								tmpKamera = null;
							}
						datum.getReferenceValue("Kamera").setSystemObject(tmpKamera);
					// ObjektReferenzAttributTyp
						final Object soStrassenSegment = getStrassenSegment();
						final SystemObject tmpStrassenSegment;
							if (soStrassenSegment instanceof SystemObject) {
								tmpStrassenSegment = (SystemObject)soStrassenSegment;
							} else if(soStrassenSegment instanceof SystemObjekt){
								tmpStrassenSegment = ((SystemObjekt)soStrassenSegment).getSystemObject();
							} else{
								tmpStrassenSegment = null;
							}
						datum.getReferenceValue("StraßenSegment").setSystemObject(tmpStrassenSegment);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Typ").isState()) {
								setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttVerkehrsEreignisTyp
								.getZustand(daten.getScaledValue("Typ").getText()));
							} else {
							setTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttVerkehrsEreignisTyp
							(daten.
								getUnscaledValue
							("Typ").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final long idKamera = daten.getReferenceValue("Kamera").getId();
						final SystemObjekt tmpKamera;
						if (idKamera == 0) {
							tmpKamera = null;
						} else {
							final SystemObject soKamera = factory.getDav().getDataModel().getObject(idKamera);
							if (soKamera == null) {
									tmpKamera = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.impl.KameraUngueltig(idKamera);
							} else {
								tmpKamera = factory.getModellobjekt(soKamera);
							}
						}
						setKamera((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlvideo.objekte.Kamera
						) tmpKamera);
					// ObjektReferenzAttributTyp
						final long idStrassenSegment = daten.getReferenceValue("StraßenSegment").getId();
						final SystemObjekt tmpStrassenSegment;
						if (idStrassenSegment == 0) {
							tmpStrassenSegment = null;
						} else {
							final SystemObject soStrassenSegment = factory.getDav().getDataModel().getObject(idStrassenSegment);
							if (soStrassenSegment == null) {
									tmpStrassenSegment = new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlverkehrsmodell.objekte.impl.AeusseresStrassenSegmentPrognoseUngueltig(idStrassenSegment);
							} else {
								tmpStrassenSegment = factory.getModellobjekt(soStrassenSegment);
							}
						}
						setStrassenSegment((	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlverkehrsmodell.objekte.AeusseresStrassenSegmentPrognose
						) tmpStrassenSegment);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setTyp(getTyp());
							klon.setKamera(getKamera());
							klon.setStrassenSegment(getStrassenSegment());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.vbaEvent.verkehr";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdVbaEventVerkehr(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
