/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Info.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdBcEmpfehlerKommando extends AbstractOnlineDatensatz<OdBcEmpfehlerKommando.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.KommandoAnfrage,
					Aspekte.KommandoAntwort,
				};
			}
	
			/**
			 * Info.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt KommandoAnfrage = new Aspekte("KommandoAnfrage", "asp.kommandoAnfrage");
			
			/**
			 * Info.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt KommandoAntwort = new Aspekte("KommandoAntwort", "asp.kommandoAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcEmpfehlerKommandoTyp
				 _kommandoTyp
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcEmpfehlerAntwortTyp
				 _antwortTyp
				;
				private String
				 _verursacher
				= new String
				()
				;
				private String
				 _nachricht
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _ereignisId
				;
		
			/**
			Typ eines Kommandos an den Empfehler.
			<p>
			
			</p>
			
			@return der Wert von KommandoTyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcEmpfehlerKommandoTyp
				 getKommandoTyp() {
				return _kommandoTyp;
			}
		
			/**
			Typ eines Kommandos an den Empfehler.
			<p>
			
			</p>
			
			@param _kommandoTyp der neue Wert von KommandoTyp.
			*/
			public void setKommandoTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcEmpfehlerKommandoTyp
			 _kommandoTyp) {
				this._kommandoTyp = _kommandoTyp;
			}
		
			/**
			Typ einer Antwort des Empfehlers.
			<p>
			
			</p>
			
			@return der Wert von AntwortTyp.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcEmpfehlerAntwortTyp
				 getAntwortTyp() {
				return _antwortTyp;
			}
		
			/**
			Typ einer Antwort des Empfehlers.
			<p>
			
			</p>
			
			@param _antwortTyp der neue Wert von AntwortTyp.
			*/
			public void setAntwortTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcEmpfehlerAntwortTyp
			 _antwortTyp) {
				this._antwortTyp = _antwortTyp;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Verursacher.
			*/
				public String
				 getVerursacher() {
				return _verursacher;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _verursacher der neue Wert von Verursacher.
			*/
			public void setVerursacher(String
			 _verursacher) {
				if (_verursacher.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._verursacher = _verursacher;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Nachricht.
			*/
				public String
				 getNachricht() {
				return _nachricht;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _nachricht der neue Wert von Nachricht.
			*/
			public void setNachricht(String
			 _nachricht) {
				if (_nachricht.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._nachricht = _nachricht;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von EreignisId.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getEreignisId() {
				return _ereignisId;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _ereignisId der neue Wert von EreignisId.
			*/
			public void setEreignisId(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _ereignisId) {
				this._ereignisId = _ereignisId;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getKommandoTyp() != null) {
		                if (getKommandoTyp().isZustand()) {
		                    datum.getUnscaledValue("KommandoTyp").setText(getKommandoTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KommandoTyp").set(getKommandoTyp().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAntwortTyp() != null) {
		                if (getAntwortTyp().isZustand()) {
		                    datum.getUnscaledValue("AntwortTyp").setText(getAntwortTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AntwortTyp").set(getAntwortTyp().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getVerursacher() != null) {
						datum.getTextValue("Verursacher").setText(getVerursacher());
					}
					// ZeichenkettenAttributTyp
					if (getNachricht() != null) {
						datum.getTextValue("Nachricht").setText(getNachricht());
					}
					// GanzzahlAttributTyp
					if (getEreignisId() != null) {
		                if (getEreignisId().isZustand()) {
		                    datum.getUnscaledValue("EreignisId").setText(getEreignisId().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EreignisId").set(getEreignisId().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("KommandoTyp").isState()) {
								setKommandoTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcEmpfehlerKommandoTyp
								.getZustand(daten.getScaledValue("KommandoTyp").getText()));
							} else {
							setKommandoTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcEmpfehlerKommandoTyp
							(daten.
								getUnscaledValue
							("KommandoTyp").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AntwortTyp").isState()) {
								setAntwortTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcEmpfehlerAntwortTyp
								.getZustand(daten.getScaledValue("AntwortTyp").getText()));
							} else {
							setAntwortTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcEmpfehlerAntwortTyp
							(daten.
								getUnscaledValue
							("AntwortTyp").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						setVerursacher(daten.getTextValue("Verursacher").getText());
					// ZeichenkettenAttributTyp
						setNachricht(daten.getTextValue("Nachricht").getText());
					// GanzzahlAttributTyp
							setEreignisId(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("EreignisId").
									longValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setKommandoTyp(getKommandoTyp());
							klon.setAntwortTyp(getAntwortTyp());
							klon.setVerursacher(getVerursacher());
							klon.setNachricht(getNachricht());
							klon.setEreignisId(getEreignisId());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.bcEmpfehlerKommando";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdBcEmpfehlerKommando(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
