/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kennzeichnet den aktuellen Zustand des Events.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdVbaEventZustand extends AbstractOnlineDatensatz<OdVbaEventZustand.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _aktiv
				;
				private 	Zeitstempel
				 _zeitstempel
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
				 _gefahrenpotenzial
				;
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Aktiv.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getAktiv() {
				return _aktiv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _aktiv der neue Wert von Aktiv.
			*/
			public void setAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _aktiv) {
				this._aktiv = _aktiv;
			}
		
			/**
			Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
			<p>
			
			</p>
			
			@return der Wert von Zeitstempel.
			*/
				public 	Zeitstempel
				 getZeitstempel() {
				return _zeitstempel;
			}
		
			/**
			Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
			<p>
			
			</p>
			
			@param _zeitstempel der neue Wert von Zeitstempel.
			*/
			public void setZeitstempel(	Zeitstempel
			 _zeitstempel) {
				this._zeitstempel = _zeitstempel;
			}
		
			/**
			Jedes Ereignisobjekt hat ein ihm eigenes
									Grund-Gefahrenpotenzial
									(in atg.vbaEventParameter hinterlegt). Im
									Defaultfall steht hier
									eben dieses. Die sendende Applikation kann
									aber durch Auswertung
									anderer
									Daten das Gefahrenpotenzial für dieses
									Auftreten modifizieren.
			<p>
			
			</p>
			
			@return der Wert von Gefahrenpotenzial.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
				 getGefahrenpotenzial() {
				return _gefahrenpotenzial;
			}
		
			/**
			Jedes Ereignisobjekt hat ein ihm eigenes
									Grund-Gefahrenpotenzial
									(in atg.vbaEventParameter hinterlegt). Im
									Defaultfall steht hier
									eben dieses. Die sendende Applikation kann
									aber durch Auswertung
									anderer
									Daten das Gefahrenpotenzial für dieses
									Auftreten modifizieren.
			<p>
			
			</p>
			
			@param _gefahrenpotenzial der neue Wert von Gefahrenpotenzial.
			*/
			public void setGefahrenpotenzial(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
			 _gefahrenpotenzial) {
				this._gefahrenpotenzial = _gefahrenpotenzial;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getAktiv() != null) {
		                if (getAktiv().isZustand()) {
		                    datum.getUnscaledValue("Aktiv").setText(getAktiv().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Aktiv").set(getAktiv().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("Zeitstempel").setMillis(getZeitstempel().getTime());
					// GanzzahlAttributTyp
					if (getGefahrenpotenzial() != null) {
		                if (getGefahrenpotenzial().isZustand()) {
		                    datum.getUnscaledValue("Gefahrenpotenzial").setText(getGefahrenpotenzial().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Gefahrenpotenzial").set(getGefahrenpotenzial().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Aktiv").isState()) {
								setAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Aktiv").getText()));
							} else {
							setAktiv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Aktiv").
									byteValue
							()));
							}
					// ZeitstempelAttributTyp
						setZeitstempel(new
							Zeitstempel
							(daten.getTimeValue("Zeitstempel").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Gefahrenpotenzial").isState()) {
								setGefahrenpotenzial(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
								.getZustand(daten.getScaledValue("Gefahrenpotenzial").getText()));
							} else {
							setGefahrenpotenzial(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AttBcGefahrenPotenzial
							(daten.
								getUnscaledValue
							("Gefahrenpotenzial").
									shortValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAktiv(getAktiv());
							klon.setZeitstempel(getZeitstempel());
							klon.setGefahrenpotenzial(getGefahrenpotenzial());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.vbaEventZustand";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdVbaEventZustand(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
