/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
parametrierbare Tabelle mit Zuordnungen von Gefährdungen
					über Sektoren der Windrichtung und der Windgeschwindigkeit.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class PdVbaEventUfdWindsektoren extends AbstractParameterDatensatz<PdVbaEventUfdWindsektoren.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				@Defaultwert(wert = "100")
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 _wichtungMittelwert
				;
				@Defaultwert(wert = "0")
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 _wichtungSpitze
				;
				@Defaultwert(wert = "10")
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _mittelungsTiefe
				;
				@Defaultwert(wert = "0.3")
				private 	Double
				 _glaettungsfaktor
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventUfdWindSektorBewertung
				> _sektoren = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventUfdWindSektorBewertung
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Prozentwert.
			<p>
			
			</p>
			
			@return der Wert von WichtungMittelwert.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 getWichtungMittelwert() {
				return _wichtungMittelwert;
			}
		
			/**
			Prozentwert.
			<p>
			
			</p>
			
			@param _wichtungMittelwert der neue Wert von WichtungMittelwert.
			*/
			public void setWichtungMittelwert(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _wichtungMittelwert) {
				this._wichtungMittelwert = _wichtungMittelwert;
			}
		
			/**
			Prozentwert.
			<p>
			
			</p>
			
			@return der Wert von WichtungSpitze.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 getWichtungSpitze() {
				return _wichtungSpitze;
			}
		
			/**
			Prozentwert.
			<p>
			
			</p>
			
			@param _wichtungSpitze der neue Wert von WichtungSpitze.
			*/
			public void setWichtungSpitze(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _wichtungSpitze) {
				this._wichtungSpitze = _wichtungSpitze;
			}
		
			/**
			die Anzahl der Werte über die die Windrichtung gemittelt
									wird.
			<p>
			
			</p>
			
			@return der Wert von MittelungsTiefe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getMittelungsTiefe() {
				return _mittelungsTiefe;
			}
		
			/**
			die Anzahl der Werte über die die Windrichtung gemittelt
									wird.
			<p>
			
			</p>
			
			@param _mittelungsTiefe der neue Wert von MittelungsTiefe.
			*/
			public void setMittelungsTiefe(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _mittelungsTiefe) {
				this._mittelungsTiefe = _mittelungsTiefe;
			}
		
			/**
			der Glättungsfaktor für die Windstärke.
			<p>
			
			</p>
			
			@return der Wert von Glaettungsfaktor.
			*/
				public 	Double
				 getGlaettungsfaktor() {
				return _glaettungsfaktor;
			}
		
			/**
			der Glättungsfaktor für die Windstärke.
			<p>
			
			</p>
			
			@param _glaettungsfaktor der neue Wert von Glaettungsfaktor.
			*/
			public void setGlaettungsfaktor(	Double
			 _glaettungsfaktor) {
				this._glaettungsfaktor = _glaettungsfaktor;
			}
		
			/**
			Definition eines Sektors.
			<p>
			
			</p>
			
			@return der Wert von Sektoren.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventUfdWindSektorBewertung
				> getSektoren() {
				return _sektoren;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getWichtungMittelwert() != null) {
		                if (getWichtungMittelwert().isZustand()) {
		                    datum.getUnscaledValue("WichtungMittelwert").setText(getWichtungMittelwert().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("WichtungMittelwert").set(getWichtungMittelwert().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getWichtungSpitze() != null) {
		                if (getWichtungSpitze().isZustand()) {
		                    datum.getUnscaledValue("WichtungSpitze").setText(getWichtungSpitze().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("WichtungSpitze").set(getWichtungSpitze().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMittelungsTiefe() != null) {
		                if (getMittelungsTiefe().isZustand()) {
		                    datum.getUnscaledValue("MittelungsTiefe").setText(getMittelungsTiefe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MittelungsTiefe").set(getMittelungsTiefe().getValue());
		                }
					}
					// KommazahlAttributTyp
					if (getGlaettungsfaktor() != null) {
						datum.getUnscaledValue("Glaettungsfaktor").set(getGlaettungsfaktor());
					}
					// AttributListenDefinition
						final Data.Array arraySektoren = datum.getArray("Sektoren");
						arraySektoren.setLength(getSektoren().size());
						for (int i = 0; i < arraySektoren.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventUfdWindSektorBewertung
							 atl = getSektoren().get(i);
							atl.bean2Atl(arraySektoren.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("WichtungMittelwert").isState()) {
								setWichtungMittelwert(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
								.getZustand(daten.getScaledValue("WichtungMittelwert").getText()));
							} else {
							setWichtungMittelwert(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							(daten.
								getUnscaledValue
							("WichtungMittelwert").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("WichtungSpitze").isState()) {
								setWichtungSpitze(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
								.getZustand(daten.getScaledValue("WichtungSpitze").getText()));
							} else {
							setWichtungSpitze(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							(daten.
								getUnscaledValue
							("WichtungSpitze").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setMittelungsTiefe(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("MittelungsTiefe").
									longValue
							()));
					// KommazahlAttributTyp
						setGlaettungsfaktor(daten.getUnscaledValue("Glaettungsfaktor").
							doubleValue()
						);
					// AttributListenDefinition
						final Data.Array arraySektoren = daten.getArray("Sektoren");
						for (int i = 0; i < arraySektoren.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventUfdWindSektorBewertung
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlevent.attribute.AtlVbaEventUfdWindSektorBewertung
							 ();
							atl.atl2Bean(arraySektoren.getItem(i), factory);
							getSektoren().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setWichtungMittelwert(getWichtungMittelwert());
							klon.setWichtungSpitze(getWichtungSpitze());
							klon.setMittelungsTiefe(getMittelungsTiefe());
							klon.setGlaettungsfaktor(getGlaettungsfaktor());
						klon._sektoren = getSektoren().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.vbaEvent.ufd.windsektoren";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdVbaEventUfdWindsektoren(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
