/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlplausibilisierungobjektuebergreifend.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt eine Plausibilisierungsregel.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdPloRegel extends AbstractParameterDatensatz<PdPloRegel.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private String
				 _bezeichnung
				= new String
				()
				;
				private String
				 _beschreibung
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _aktiv
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _grenzwert
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _absolut
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 _anzahlMesswerte
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsVergleichsOperator
				 _operator
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AtlPositivNegativListe
				 _datenpunkte
				= new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AtlPositivNegativListe
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _bmv
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _popup
				;
				private String
				 _klang
				= new String
				()
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Bezeichnung.
			*/
				public String
				 getBezeichnung() {
				return _bezeichnung;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _bezeichnung der neue Wert von Bezeichnung.
			*/
			public void setBezeichnung(String
			 _bezeichnung) {
				if (_bezeichnung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bezeichnung = _bezeichnung;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Beschreibung.
			*/
				public String
				 getBeschreibung() {
				return _beschreibung;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _beschreibung der neue Wert von Beschreibung.
			*/
			public void setBeschreibung(String
			 _beschreibung) {
				if (_beschreibung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._beschreibung = _beschreibung;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Aktiv.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getAktiv() {
				return _aktiv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _aktiv der neue Wert von Aktiv.
			*/
			public void setAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _aktiv) {
				this._aktiv = _aktiv;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von Grenzwert.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getGrenzwert() {
				return _grenzwert;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _grenzwert der neue Wert von Grenzwert.
			*/
			public void setGrenzwert(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _grenzwert) {
				this._grenzwert = _grenzwert;
			}
		
			/**
			Dient zur Unterscheidung, ob der Absolutwert oder der
									Betrag der Differenz dem Vergleich mit dem Grenzwert unterzogen
									werden soll.
			<p>
			
			</p>
			
			@return der Wert von Absolut.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getAbsolut() {
				return _absolut;
			}
		
			/**
			Dient zur Unterscheidung, ob der Absolutwert oder der
									Betrag der Differenz dem Vergleich mit dem Grenzwert unterzogen
									werden soll.
			<p>
			
			</p>
			
			@param _absolut der neue Wert von Absolut.
			*/
			public void setAbsolut(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _absolut) {
				this._absolut = _absolut;
			}
		
			/**
			Objektübergreifende Plausibilisierungen können oft nur
									sinnvoll durchgeführt werden, wenn eine bestimmte Anzahl Messwerte
									erfasst und aggregiert wurden. Diese Anzahl wird hiermit bestimmt.
			<p>
			
			</p>
			
			@return der Wert von AnzahlMesswerte.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
				 getAnzahlMesswerte() {
				return _anzahlMesswerte;
			}
		
			/**
			Objektübergreifende Plausibilisierungen können oft nur
									sinnvoll durchgeführt werden, wenn eine bestimmte Anzahl Messwerte
									erfasst und aggregiert wurden. Diese Anzahl wird hiermit bestimmt.
			<p>
			
			</p>
			
			@param _anzahlMesswerte der neue Wert von AnzahlMesswerte.
			*/
			public void setAnzahlMesswerte(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _anzahlMesswerte) {
				this._anzahlMesswerte = _anzahlMesswerte;
			}
		
			/**
			Zu verwendender Operator zum Vergleich des Messwerts mit einem Grenzwert.
			<p>
			
			</p>
			
			@return der Wert von Operator.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsVergleichsOperator
				 getOperator() {
				return _operator;
			}
		
			/**
			Zu verwendender Operator zum Vergleich des Messwerts mit einem Grenzwert.
			<p>
			
			</p>
			
			@param _operator der neue Wert von Operator.
			*/
			public void setOperator(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsVergleichsOperator
			 _operator) {
				this._operator = _operator;
			}
		
			/**
			Doppel-Summenliste von Datenpunkten. Sie definiert zwei
								Listen von Datenpunkten, deren aktuelle Werte jeweils addiert
								werden. Die Summe der Negativliste wird dann von der Summe der
								Positivliste abgezogen und liefert das aktuelle Ergebnis.
			<p>
			
			</p>
			
			@return der Wert von Datenpunkte.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AtlPositivNegativListe
				 getDatenpunkte() {
				return _datenpunkte;
			}
		
			/**
			Doppel-Summenliste von Datenpunkten. Sie definiert zwei
								Listen von Datenpunkten, deren aktuelle Werte jeweils addiert
								werden. Die Summe der Negativliste wird dann von der Summe der
								Positivliste abgezogen und liefert das aktuelle Ergebnis.
			<p>
			
			</p>
			
			@param _datenpunkte der neue Wert von Datenpunkte.
			*/
			public void setDatenpunkte(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AtlPositivNegativListe
			 _datenpunkte) {
				this._datenpunkte = _datenpunkte;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Bmv.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getBmv() {
				return _bmv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _bmv der neue Wert von Bmv.
			*/
			public void setBmv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _bmv) {
				this._bmv = _bmv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Popup.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getPopup() {
				return _popup;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _popup der neue Wert von Popup.
			*/
			public void setPopup(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _popup) {
				this._popup = _popup;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Klang.
			*/
				public String
				 getKlang() {
				return _klang;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _klang der neue Wert von Klang.
			*/
			public void setKlang(String
			 _klang) {
				if (_klang.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._klang = _klang;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
					if (getBezeichnung() != null) {
						datum.getTextValue("Bezeichnung").setText(getBezeichnung());
					}
					// ZeichenkettenAttributTyp
					if (getBeschreibung() != null) {
						datum.getTextValue("Beschreibung").setText(getBeschreibung());
					}
					// GanzzahlAttributTyp
					if (getAktiv() != null) {
		                if (getAktiv().isZustand()) {
		                    datum.getUnscaledValue("Aktiv").setText(getAktiv().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Aktiv").set(getAktiv().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getGrenzwert() != null) {
		                if (getGrenzwert().isZustand()) {
		                    datum.getUnscaledValue("Grenzwert").setText(getGrenzwert().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Grenzwert").set(getGrenzwert().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAbsolut() != null) {
		                if (getAbsolut().isZustand()) {
		                    datum.getUnscaledValue("Absolut").setText(getAbsolut().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Absolut").set(getAbsolut().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnzahlMesswerte() != null) {
		                if (getAnzahlMesswerte().isZustand()) {
		                    datum.getUnscaledValue("AnzahlMesswerte").setText(getAnzahlMesswerte().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzahlMesswerte").set(getAnzahlMesswerte().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getOperator() != null) {
		                if (getOperator().isZustand()) {
		                    datum.getUnscaledValue("Operator").setText(getOperator().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Operator").set(getOperator().getValue());
		                }
					}
					// AttributListenDefinition
						getDatenpunkte().bean2Atl(datum.getItem("Datenpunkte"), factory);
					// GanzzahlAttributTyp
					if (getBmv() != null) {
		                if (getBmv().isZustand()) {
		                    datum.getUnscaledValue("Bmv").setText(getBmv().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Bmv").set(getBmv().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPopup() != null) {
		                if (getPopup().isZustand()) {
		                    datum.getUnscaledValue("Popup").setText(getPopup().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Popup").set(getPopup().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getKlang() != null) {
						datum.getTextValue("Klang").setText(getKlang());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
						setBezeichnung(daten.getTextValue("Bezeichnung").getText());
					// ZeichenkettenAttributTyp
						setBeschreibung(daten.getTextValue("Beschreibung").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Aktiv").isState()) {
								setAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Aktiv").getText()));
							} else {
							setAktiv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Aktiv").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setGrenzwert(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("Grenzwert").
									longValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Absolut").isState()) {
								setAbsolut(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Absolut").getText()));
							} else {
							setAbsolut(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Absolut").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setAnzahlMesswerte(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
							(daten.
								getUnscaledValue
							("AnzahlMesswerte").
									longValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Operator").isState()) {
								setOperator(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsVergleichsOperator
								.getZustand(daten.getScaledValue("Operator").getText()));
							} else {
							setOperator(new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AttUfdsVergleichsOperator
							(daten.
								getUnscaledValue
							("Operator").
									byteValue
							()));
							}
					// AttributListenDefinition
						getDatenpunkte().atl2Bean(daten.getItem("Datenpunkte"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Bmv").isState()) {
								setBmv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Bmv").getText()));
							} else {
							setBmv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Bmv").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Popup").isState()) {
								setPopup(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Popup").getText()));
							} else {
							setPopup(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Popup").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						setKlang(daten.getTextValue("Klang").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setBezeichnung(getBezeichnung());
							klon.setBeschreibung(getBeschreibung());
							klon.setAktiv(getAktiv());
							klon.setGrenzwert(getGrenzwert());
							klon.setAbsolut(getAbsolut());
							klon.setAnzahlMesswerte(getAnzahlMesswerte());
							klon.setOperator(getOperator());
							klon._datenpunkte = getDatenpunkte().clone();
							klon.setBmv(getBmv());
							klon.setPopup(getPopup());
							klon.setKlang(getKlang());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ploRegel";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdPloRegel(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
