/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ein Eintrag, der einer Menge von Anzeigen eine
					Fehlerbeschreibung
					für das Verhalten bei Störungen zuordnet.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlSelektivesIgnorierenEintrag implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			> _anzeigen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			>(0, true);
			private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AtlSelektivesIgnorierenFehlerBeschreibung
			 _fehlerBeschreibung
			= new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AtlSelektivesIgnorierenFehlerBeschreibung
			()
			;
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.anzeige.
		<p>
		
		</p>
		
		@return der Wert von Anzeigen.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
			> getAnzeigen() {
			return _anzeigen;
		}
	
	
		/**
		Beschreibt alle Fehler, die eine Anzeige haben
							kann und die potentiell
							dazu führen, dass sie für bestimmte
							Stellbefehle ignoriert wird.
		<p>
		
		</p>
		
		@return der Wert von FehlerBeschreibung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AtlSelektivesIgnorierenFehlerBeschreibung
			 getFehlerBeschreibung() {
			return _fehlerBeschreibung;
		}
	
		/**
		Beschreibt alle Fehler, die eine Anzeige haben
							kann und die potentiell
							dazu führen, dass sie für bestimmte
							Stellbefehle ignoriert wird.
		<p>
		
		</p>
		
		@param _fehlerBeschreibung der neue Wert von FehlerBeschreibung.
		*/
		public void setFehlerBeschreibung(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AtlSelektivesIgnorierenFehlerBeschreibung
		 _fehlerBeschreibung) {
			this._fehlerBeschreibung = _fehlerBeschreibung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAnzeigen = datum.getReferenceArray("Anzeigen");
					arrayAnzeigen.setLength(getAnzeigen().size());
					for (int i = 0; i < arrayAnzeigen.getLength(); ++i) {
						final Object soAnzeigen = getAnzeigen().get(i);
						final SystemObject tmpAnzeigen;
						if (soAnzeigen instanceof SystemObject) {
							tmpAnzeigen = (SystemObject)soAnzeigen;
						} else if(soAnzeigen instanceof SystemObjekt){
							tmpAnzeigen = ((SystemObjekt)soAnzeigen).getSystemObject();
						} else{
							tmpAnzeigen = null;
						}
						arrayAnzeigen.getReferenceValue(i).setSystemObject(tmpAnzeigen);
					}
				// AttributListenDefinition
					getFehlerBeschreibung().bean2Atl(datum.getItem("FehlerBeschreibung"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayAnzeigen = daten.getReferenceArray("Anzeigen");
					for (int i = 0; i < arrayAnzeigen.getLength(); ++i) {
						final long idAnzeigen = daten.getReferenceArray("Anzeigen").getReferenceValue(i).getId();
						final SystemObjekt tmpAnzeigen;
						if (idAnzeigen == 0) {
							tmpAnzeigen = null;
						} else {
							final SystemObject soAnzeigen = factory.getDav().getDataModel().getObject(idAnzeigen);
							if (soAnzeigen == null) {
									tmpAnzeigen = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeUngueltig(idAnzeigen);
							} else {
								tmpAnzeigen = factory.getModellobjekt(soAnzeigen);
							}
						}
							getAnzeigen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
							) tmpAnzeigen);
					}
				// AttributListenDefinition
					getFehlerBeschreibung().atl2Bean(daten.getItem("FehlerBeschreibung"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlSelektivesIgnorierenEintrag clone() {
		AtlSelektivesIgnorierenEintrag klon = new AtlSelektivesIgnorierenEintrag();
		
					klon._anzeigen = getAnzeigen().clone();
						klon._fehlerBeschreibung = getFehlerBeschreibung().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
