/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Info.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdKommando extends AbstractOnlineDatensatz<OdKommando.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.KommandoAnfrage,
					Aspekte.KommandoAntwort,
				};
			}
	
			/**
			 * Info.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt KommandoAnfrage = new Aspekte("KommandoAnfrage", "asp.kommandoAnfrage");
			
			/**
			 * Info.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt KommandoAntwort = new Aspekte("KommandoAntwort", "asp.kommandoAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _applikationsID
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _anfrageID
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttKommandoTyp
				 _typ
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
				 _verursacher
				;
				private String
				 _nachricht
				= new String
				()
				;
				private 	Zeitstempel
				 _timeout
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				 _schaltProgram
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				 _zielProgram
				;
				private Feld<String
				> _verletzteRegeln = new Feld<String
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
				> _fehlendeAnzeigen = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
				>(0, true);
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von ApplikationsID.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getApplikationsID() {
				return _applikationsID;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _applikationsID der neue Wert von ApplikationsID.
			*/
			public void setApplikationsID(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _applikationsID) {
				this._applikationsID = _applikationsID;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von AnfrageID.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getAnfrageID() {
				return _anfrageID;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _anfrageID der neue Wert von AnfrageID.
			*/
			public void setAnfrageID(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _anfrageID) {
				this._anfrageID = _anfrageID;
			}
		
			/**
			Typ eines Kommandos an den Schaltprogramm-Server.
			<p>
			
			</p>
			
			@return der Wert von Typ.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttKommandoTyp
				 getTyp() {
				return _typ;
			}
		
			/**
			Typ eines Kommandos an den Schaltprogramm-Server.
			<p>
			
			</p>
			
			@param _typ der neue Wert von Typ.
			*/
			public void setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttKommandoTyp
			 _typ) {
				this._typ = _typ;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.benutzer.
			<p>
			
			</p>
			
			@return der Wert von Verursacher.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
				 getVerursacher() {
				return _verursacher;
			}
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.benutzer.
			<p>
			
			</p>
			
			@param _verursacher der neue Wert von Verursacher.
			*/
			public void setVerursacher(	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
			 _verursacher) {
				this._verursacher = _verursacher;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Nachricht.
			*/
				public String
				 getNachricht() {
				return _nachricht;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _nachricht der neue Wert von Nachricht.
			*/
			public void setNachricht(String
			 _nachricht) {
				if (_nachricht.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._nachricht = _nachricht;
			}
		
			/**
			Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
			<p>
			
			</p>
			
			@return der Wert von Timeout.
			*/
				public 	Zeitstempel
				 getTimeout() {
				return _timeout;
			}
		
			/**
			Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
			<p>
			
			</p>
			
			@param _timeout der neue Wert von Timeout.
			*/
			public void setTimeout(	Zeitstempel
			 _timeout) {
				this._timeout = _timeout;
			}
		
			/**
			Ausgangsprogramm ist immer das aktuelle
									Programm.
			<p>
			
			</p>
			
			@return der Wert von SchaltProgram.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				 getSchaltProgram() {
				return _schaltProgram;
			}
		
			/**
			Ausgangsprogramm ist immer das aktuelle
									Programm.
			<p>
			
			</p>
			
			@param _schaltProgram der neue Wert von SchaltProgram.
			*/
			public void setSchaltProgram(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 _schaltProgram) {
				this._schaltProgram = _schaltProgram;
			}
		
			/**
			Zielprogramm ist jetzt immer das
									Globalprogramm.
			<p>
			
			</p>
			
			@return der Wert von ZielProgram.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
				 getZielProgram() {
				return _zielProgram;
			}
		
			/**
			Zielprogramm ist jetzt immer das
									Globalprogramm.
			<p>
			
			</p>
			
			@param _zielProgram der neue Wert von ZielProgram.
			*/
			public void setZielProgram(	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
			 _zielProgram) {
				this._zielProgram = _zielProgram;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von VerletzteRegeln.
			*/
				public Feld<String
				> getVerletzteRegeln() {
				return _verletzteRegeln;
			}
		
		
			/**
			Die Anzeigeelemente, die nach einem Timeout eines
									Kommandos
									nicht den Zustand haben, der für sie vorgesehen was.
									Dieses
									Feld wird vom Schaltprogrammserver erst gefüllt, nachdem ein
									Soll-Globalprogramm versendet wurde.
			<p>
			
			</p>
			
			@return der Wert von FehlendeAnzeigen.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
				> getFehlendeAnzeigen() {
				return _fehlendeAnzeigen;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getApplikationsID() != null) {
		                if (getApplikationsID().isZustand()) {
		                    datum.getUnscaledValue("ApplikationsID").setText(getApplikationsID().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ApplikationsID").set(getApplikationsID().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnfrageID() != null) {
		                if (getAnfrageID().isZustand()) {
		                    datum.getUnscaledValue("AnfrageID").setText(getAnfrageID().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnfrageID").set(getAnfrageID().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getTyp() != null) {
		                if (getTyp().isZustand()) {
		                    datum.getUnscaledValue("Typ").setText(getTyp().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Typ").set(getTyp().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Object soVerursacher = getVerursacher();
						final SystemObject tmpVerursacher;
							if (soVerursacher instanceof SystemObject) {
								tmpVerursacher = (SystemObject)soVerursacher;
							} else if(soVerursacher instanceof SystemObjekt){
								tmpVerursacher = ((SystemObjekt)soVerursacher).getSystemObject();
							} else{
								tmpVerursacher = null;
							}
						datum.getReferenceValue("Verursacher").setSystemObject(tmpVerursacher);
					// ZeichenkettenAttributTyp
					if (getNachricht() != null) {
						datum.getTextValue("Nachricht").setText(getNachricht());
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("Timeout").setMillis(getTimeout().getTime());
					// ObjektReferenzAttributTyp
						final Object soSchaltProgram = getSchaltProgram();
						final SystemObject tmpSchaltProgram;
							if (soSchaltProgram instanceof SystemObject) {
								tmpSchaltProgram = (SystemObject)soSchaltProgram;
							} else if(soSchaltProgram instanceof SystemObjekt){
								tmpSchaltProgram = ((SystemObjekt)soSchaltProgram).getSystemObject();
							} else{
								tmpSchaltProgram = null;
							}
						datum.getReferenceValue("SchaltProgram").setSystemObject(tmpSchaltProgram);
					// ObjektReferenzAttributTyp
						final Object soZielProgram = getZielProgram();
						final SystemObject tmpZielProgram;
							if (soZielProgram instanceof SystemObject) {
								tmpZielProgram = (SystemObject)soZielProgram;
							} else if(soZielProgram instanceof SystemObjekt){
								tmpZielProgram = ((SystemObjekt)soZielProgram).getSystemObject();
							} else{
								tmpZielProgram = null;
							}
						datum.getReferenceValue("ZielProgram").setSystemObject(tmpZielProgram);
					// ZeichenkettenAttributTyp
					if (getVerletzteRegeln() != null) {
						final Data.TextArray arrayVerletzteRegeln = datum.getTextArray("VerletzteRegeln");
						arrayVerletzteRegeln.setLength(getVerletzteRegeln().size());
						for (int i = 0; i < arrayVerletzteRegeln.getLength(); ++i) {
							arrayVerletzteRegeln.getTextValue(i).setText(getVerletzteRegeln().get(i));
						}
					}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayFehlendeAnzeigen = datum.getReferenceArray("FehlendeAnzeigen");
						arrayFehlendeAnzeigen.setLength(getFehlendeAnzeigen().size());
						for (int i = 0; i < arrayFehlendeAnzeigen.getLength(); ++i) {
							final Object soFehlendeAnzeigen = getFehlendeAnzeigen().get(i);
							final SystemObject tmpFehlendeAnzeigen;
							if (soFehlendeAnzeigen instanceof SystemObject) {
								tmpFehlendeAnzeigen = (SystemObject)soFehlendeAnzeigen;
							} else if(soFehlendeAnzeigen instanceof SystemObjekt){
								tmpFehlendeAnzeigen = ((SystemObjekt)soFehlendeAnzeigen).getSystemObject();
							} else{
								tmpFehlendeAnzeigen = null;
							}
							arrayFehlendeAnzeigen.getReferenceValue(i).setSystemObject(tmpFehlendeAnzeigen);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setApplikationsID(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("ApplikationsID").
									longValue
							()));
					// GanzzahlAttributTyp
							setAnfrageID(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("AnfrageID").
									longValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Typ").isState()) {
								setTyp(de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttKommandoTyp
								.getZustand(daten.getScaledValue("Typ").getText()));
							} else {
							setTyp(new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.attribute.AttKommandoTyp
							(daten.
								getUnscaledValue
							("Typ").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final long idVerursacher = daten.getReferenceValue("Verursacher").getId();
						final SystemObjekt tmpVerursacher;
						if (idVerursacher == 0) {
							tmpVerursacher = null;
						} else {
							final SystemObject soVerursacher = factory.getDav().getDataModel().getObject(idVerursacher);
							if (soVerursacher == null) {
									tmpVerursacher = new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.impl.BenutzerUngueltig(idVerursacher);
							} else {
								tmpVerursacher = factory.getModellobjekt(soVerursacher);
							}
						}
						setVerursacher((	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.objekte.Benutzer
						) tmpVerursacher);
					// ZeichenkettenAttributTyp
						setNachricht(daten.getTextValue("Nachricht").getText());
					// ZeitstempelAttributTyp
						setTimeout(new
							Zeitstempel
							(daten.getTimeValue("Timeout").getMillis()));
					// ObjektReferenzAttributTyp
						final long idSchaltProgram = daten.getReferenceValue("SchaltProgram").getId();
						final SystemObjekt tmpSchaltProgram;
						if (idSchaltProgram == 0) {
							tmpSchaltProgram = null;
						} else {
							final SystemObject soSchaltProgram = factory.getDav().getDataModel().getObject(idSchaltProgram);
							if (soSchaltProgram == null) {
									tmpSchaltProgram = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idSchaltProgram);
							} else {
								tmpSchaltProgram = factory.getModellobjekt(soSchaltProgram);
							}
						}
						setSchaltProgram((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
						) tmpSchaltProgram);
					// ObjektReferenzAttributTyp
						final long idZielProgram = daten.getReferenceValue("ZielProgram").getId();
						final SystemObjekt tmpZielProgram;
						if (idZielProgram == 0) {
							tmpZielProgram = null;
						} else {
							final SystemObject soZielProgram = factory.getDav().getDataModel().getObject(idZielProgram);
							if (soZielProgram == null) {
									tmpZielProgram = new de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.impl.SchaltProgrammUngueltig(idZielProgram);
							} else {
								tmpZielProgram = factory.getModellobjekt(soZielProgram);
							}
						}
						setZielProgram((	de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.objekte.SchaltProgramm
						) tmpZielProgram);
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayVerletzteRegeln = daten.getTextArray("VerletzteRegeln");
						for (int i = 0; i < arrayVerletzteRegeln.getLength(); ++i) {
							getVerletzteRegeln().add(arrayVerletzteRegeln.getText(i));
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayFehlendeAnzeigen = daten.getReferenceArray("FehlendeAnzeigen");
						for (int i = 0; i < arrayFehlendeAnzeigen.getLength(); ++i) {
							final long idFehlendeAnzeigen = daten.getReferenceArray("FehlendeAnzeigen").getReferenceValue(i).getId();
							final SystemObjekt tmpFehlendeAnzeigen;
							if (idFehlendeAnzeigen == 0) {
								tmpFehlendeAnzeigen = null;
							} else {
								final SystemObject soFehlendeAnzeigen = factory.getDav().getDataModel().getObject(idFehlendeAnzeigen);
								if (soFehlendeAnzeigen == null) {
										tmpFehlendeAnzeigen = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeUngueltig(idFehlendeAnzeigen);
								} else {
									tmpFehlendeAnzeigen = factory.getModellobjekt(soFehlendeAnzeigen);
								}
							}
								getFehlendeAnzeigen().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
								) tmpFehlendeAnzeigen);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setApplikationsID(getApplikationsID());
							klon.setAnfrageID(getAnfrageID());
							klon.setTyp(getTyp());
							klon.setVerursacher(getVerursacher());
							klon.setNachricht(getNachricht());
							klon.setTimeout(getTimeout());
							klon.setSchaltProgram(getSchaltProgram());
							klon.setZielProgram(getZielProgram());
						klon._verletzteRegeln = getVerletzteRegeln().clone();
						klon._fehlendeAnzeigen = getFehlendeAnzeigen().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.kommando";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdKommando(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
