/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmbitctrlschaltprogramm.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
AQ und Anzeigen, die beim Schalten ignoriert werden
					sollen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdVbaAQIgnore extends AbstractParameterDatensatz<PdVbaAQIgnore.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
				> _aQIgnore = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
				>(0, true);
				private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
				> _anzeigeIgnore = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
				>(0, true);
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.anzeigeQuerschnitt.
			<p>
			
			</p>
			
			@return der Wert von AQIgnore.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
				> getAQIgnore() {
				return _aQIgnore;
			}
		
		
			/**
			Attribut zur Referenzierung des Objekttyps: typ.anzeige.
			<p>
			
			</p>
			
			@return der Wert von AnzeigeIgnore.
			*/
				public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
				> getAnzeigeIgnore() {
				return _anzeigeIgnore;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAQIgnore = datum.getReferenceArray("AQIgnore");
						arrayAQIgnore.setLength(getAQIgnore().size());
						for (int i = 0; i < arrayAQIgnore.getLength(); ++i) {
							final Object soAQIgnore = getAQIgnore().get(i);
							final SystemObject tmpAQIgnore;
							if (soAQIgnore instanceof SystemObject) {
								tmpAQIgnore = (SystemObject)soAQIgnore;
							} else if(soAQIgnore instanceof SystemObjekt){
								tmpAQIgnore = ((SystemObjekt)soAQIgnore).getSystemObject();
							} else{
								tmpAQIgnore = null;
							}
							arrayAQIgnore.getReferenceValue(i).setSystemObject(tmpAQIgnore);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAnzeigeIgnore = datum.getReferenceArray("AnzeigeIgnore");
						arrayAnzeigeIgnore.setLength(getAnzeigeIgnore().size());
						for (int i = 0; i < arrayAnzeigeIgnore.getLength(); ++i) {
							final Object soAnzeigeIgnore = getAnzeigeIgnore().get(i);
							final SystemObject tmpAnzeigeIgnore;
							if (soAnzeigeIgnore instanceof SystemObject) {
								tmpAnzeigeIgnore = (SystemObject)soAnzeigeIgnore;
							} else if(soAnzeigeIgnore instanceof SystemObjekt){
								tmpAnzeigeIgnore = ((SystemObjekt)soAnzeigeIgnore).getSystemObject();
							} else{
								tmpAnzeigeIgnore = null;
							}
							arrayAnzeigeIgnore.getReferenceValue(i).setSystemObject(tmpAnzeigeIgnore);
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAQIgnore = daten.getReferenceArray("AQIgnore");
						for (int i = 0; i < arrayAQIgnore.getLength(); ++i) {
							final long idAQIgnore = daten.getReferenceArray("AQIgnore").getReferenceValue(i).getId();
							final SystemObjekt tmpAQIgnore;
							if (idAQIgnore == 0) {
								tmpAQIgnore = null;
							} else {
								final SystemObject soAQIgnore = factory.getDav().getDataModel().getObject(idAQIgnore);
								if (soAQIgnore == null) {
										tmpAQIgnore = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeQuerschnittUngueltig(idAQIgnore);
								} else {
									tmpAQIgnore = factory.getModellobjekt(soAQIgnore);
								}
							}
								getAQIgnore().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.AnzeigeQuerschnitt
								) tmpAQIgnore);
						}
					// ObjektReferenzAttributTyp
						final Data.ReferenceArray arrayAnzeigeIgnore = daten.getReferenceArray("AnzeigeIgnore");
						for (int i = 0; i < arrayAnzeigeIgnore.getLength(); ++i) {
							final long idAnzeigeIgnore = daten.getReferenceArray("AnzeigeIgnore").getReferenceValue(i).getId();
							final SystemObjekt tmpAnzeigeIgnore;
							if (idAnzeigeIgnore == 0) {
								tmpAnzeigeIgnore = null;
							} else {
								final SystemObject soAnzeigeIgnore = factory.getDav().getDataModel().getObject(idAnzeigeIgnore);
								if (soAnzeigeIgnore == null) {
										tmpAnzeigeIgnore = new de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.impl.AnzeigeUngueltig(idAnzeigeIgnore);
								} else {
									tmpAnzeigeIgnore = factory.getModellobjekt(soAnzeigeIgnore);
								}
							}
								getAnzeigeIgnore().add((	de.bsvrz.sys.funclib.bitctrl.modell.tmanzeigenglobal.objekte.Anzeige
								) tmpAnzeigeIgnore);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._aQIgnore = getAQIgnore().clone();
						klon._anzeigeIgnore = getAnzeigeIgnore().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.vbaAQIgnore";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdVbaAQIgnore(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
